/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.perftest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.addons.WikittyLabelUtil;
import org.nuiton.wikitty.perftest.PerfTestUtils;

public class PerfTestLabelAdd {
    private static Log log = LogFactory.getLog(PerfTestLabelAdd.class);

    public static void addLabel(WikittyProxy proxy, List<String> ids, int loopsToAvg, int threadsNb) {
        long time = System.currentTimeMillis();
        int wikittiesToCreate = ids.size();
        for (int k = 0; k < loopsToAvg; ++k) {
            for (String id : ids) {
                WikittyLabelUtil.addLabel((WikittyProxy)proxy, (String)id, (String)(id + time));
            }
        }
        time = System.currentTimeMillis() - time;
        PerfTestUtils.out("1 thread took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to add " + wikittiesToCreate + " labels on " + wikittiesToCreate + " wikitties\n");
        ArrayList<PerfTestLabelAddThread> threads = new ArrayList<PerfTestLabelAddThread>();
        time = System.currentTimeMillis();
        int threadMod = wikittiesToCreate % threadsNb != 0 ? 1 : 0;
        for (int j = 0; j < loopsToAvg; ++j) {
            int i;
            for (i = 0; i < threadsNb; ++i) {
                threads.add(new PerfTestLabelAddThread(wikittiesToCreate / threadsNb, proxy, ids, i * (wikittiesToCreate / threadsNb)));
            }
            if (threadMod == 1) {
                threads.add(new PerfTestLabelAddThread(wikittiesToCreate % threadsNb, proxy, ids, threadsNb * (wikittiesToCreate / threadsNb)));
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                ((PerfTestLabelAddThread)threads.get(i)).start();
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                try {
                    ((PerfTestLabelAddThread)threads.get(i)).join();
                    continue;
                }
                catch (InterruptedException eee) {
                    log.error((Object)eee);
                }
            }
            threads.clear();
        }
        time = System.currentTimeMillis() - time;
        PerfTestUtils.out(threadsNb + (threadMod == 1 ? "(+1)" : "") + " threads took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to add " + wikittiesToCreate / threadsNb + " labels each " + (threadMod == 1 ? "(+" + wikittiesToCreate % threadsNb + " labels) " : "") + "on " + wikittiesToCreate + " wikitties\n");
    }

    private static class PerfTestLabelAddThread
    extends Thread {
        private int labelsToAdd;
        private WikittyProxy proxy;
        private List<String> ids;
        private int startAt;

        PerfTestLabelAddThread(int labelsToAdd, WikittyProxy proxy, List<String> ids, int startAt) {
            this.labelsToAdd = labelsToAdd;
            this.proxy = proxy;
            this.ids = ids;
            this.startAt = startAt;
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            for (int i = this.startAt; i < this.labelsToAdd + this.startAt; ++i) {
                WikittyLabelUtil.addLabel((WikittyProxy)this.proxy, (String)this.ids.get(i), (String)(this.ids.get(i) + time));
            }
        }
    }
}

