/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyServiceNotifier;

public class WikittyServiceNotifierTest {
    private static Log log = LogFactory.getLog(WikittyServiceNotifierTest.class);
    protected EnumSet<WikittyEvent.WikittyEventType> lastEvent = null;
    protected int nbEvent = 0;

    @Test
    public void testEvent() throws Exception {
        WikittyServiceNotifier wsn = new WikittyServiceNotifier(null, null, null);
        Listener l = new Listener();
        wsn.addWikittyServiceListener((WikittyListener)l, WikittyService.ServiceListenerType.ALL);
        this.sendEvent(wsn, true);
        wsn.removeWikittyServiceListener((WikittyListener)l, WikittyService.ServiceListenerType.ALL);
        this.sendEvent(wsn, false);
        Assert.assertEquals((long)6L, (long)this.nbEvent);
    }

    protected void sendEvent(WikittyServiceNotifier wsn, boolean hasListener) throws Exception {
        WikittyEvent event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.PUT_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.PUT_WIKITTY), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.REMOVE_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.REMOVE_WIKITTY), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.CLEAR_WIKITTY);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.CLEAR_WIKITTY), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.PUT_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.PUT_EXTENSION), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.REMOVE_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.REMOVE_EXTENSION), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
        event = new WikittyEvent((Object)"test");
        event.addType(WikittyEvent.WikittyEventType.CLEAR_EXTENSION);
        wsn.processRemoteEvent(event);
        wsn.getEventThread().waitFor(event.getTime());
        if (hasListener) {
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.CLEAR_EXTENSION), this.lastEvent);
        } else {
            Assert.assertEquals(null, this.lastEvent);
        }
        this.lastEvent = null;
    }

    class Listener
    implements WikittyListener {
        Listener() {
        }

        public void putWikitty(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.PUT_WIKITTY), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }

        public void removeWikitty(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.REMOVE_WIKITTY), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }

        public void clearWikitty(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.CLEAR_WIKITTY), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }

        public void putExtension(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.PUT_EXTENSION), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }

        public void removeExtension(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.REMOVE_EXTENSION), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }

        public void clearExtension(WikittyEvent event) {
            ++WikittyServiceNotifierTest.this.nbEvent;
            Assert.assertEquals(EnumSet.of(WikittyEvent.WikittyEventType.CLEAR_EXTENSION), (Object)event.getType());
            WikittyServiceNotifierTest.this.lastEvent = event.getType();
        }
    }
}

