/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: Condition.java 1462 2012-04-05 15:31:15Z maven-release $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.6/wikitty-api/src/main/java/org/nuiton/wikitty/query/conditions/Condition.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.query.conditions;

import java.io.Serializable;
import org.nuiton.wikitty.query.WikittyQueryVisitor;

/**
 *
 * @author poussin
 * @version $Revision: 1462 $
 *
 * Last update: $Date: 2012-04-05 17:31:15 +0200 (jeu, 05 avr 2012) $
 * by : $Author: maven-release $
 */
public interface Condition extends Serializable {

    void accept(WikittyQueryVisitor visitor);

    /**
     * For non terminal condition this method add subCondition.
     * For terminal this method must accept only {@link ConditionValue}
     *
     * @param c
     * @return this
     */
    Condition addCondition(Condition c);

    Condition copy();

    boolean waitCondition();

}
