/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.test.ProductPicture;
import org.nuiton.wikitty.test.ProductPictureHelper;

public abstract class ProductPictureAbstract
extends BusinessEntityImpl
implements ProductPicture {
    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionProductPicture;
    private static final long serialVersionUID = 3834308415651527009L;

    @Override
    public String getPicture() {
        String value = ProductPictureHelper.getPicture(this.getWikitty());
        return value;
    }

    @Override
    public void setPicture(String picture) {
        String oldValue = this.getPicture();
        ProductPictureHelper.setPicture(this.getWikitty(), picture);
        this.getPropertyChangeSupport().firePropertyChange("picture", oldValue, this.getPicture());
    }

    @Override
    public int getPicturePrice() {
        int value = ProductPictureHelper.getPicturePrice(this.getWikitty());
        return value;
    }

    @Override
    public void setPicturePrice(int price) {
        int oldValue = this.getPicturePrice();
        ProductPictureHelper.setPicturePrice(this.getWikitty(), price);
        this.getPropertyChangeSupport().firePropertyChange("price", oldValue, this.getPicturePrice());
    }

    public ProductPictureAbstract() {
    }

    public ProductPictureAbstract(Wikitty wikitty) {
        super(wikitty);
    }

    public ProductPictureAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
    }

    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    public String toString() {
        return ProductPictureHelper.toString(this.getWikitty());
    }

    static {
        extensionProductPicture = new WikittyExtension("ProductPicture", "1.0", WikittyUtil.tagValuesToMap((String)""), (List)null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String picture unique=\"true\"", "Numeric price unique=\"true\" alternativeName=\"picturePrice\""}));
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionProductPicture);
        extensions = Collections.unmodifiableList(exts);
    }
}

