/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyClientAbstractTest;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyI18nTestUtil;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.addons.WikittyLabelUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.entities.WikittyGroupImpl;
import org.nuiton.wikitty.entities.WikittyI18n;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.entities.WikittyUserImpl;
import org.nuiton.wikitty.query.FacetSortType;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryParser;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.query.conditions.Aggregate;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.test.CatalogNode;
import org.nuiton.wikitty.test.Category;
import org.nuiton.wikitty.test.Product;

public class WikittyClientTest
extends WikittyClientAbstractTest {
    private static Log log = LogFactory.getLog(WikittyClientTest.class);

    @Test
    public void testStorageRestoreBasics() {
        WikittyImpl w = new WikittyImpl();
        w.addExtension(MEDIA_EXTENSION);
        w.addExtension(MOVIE_EXTENSION);
        String id = w.getId();
        w = this.wikittyClient.store((Wikitty)w);
        w = this.wikittyClient.restore(id);
        Assert.assertTrue((boolean)w.hasExtension("Movies"));
        Assert.assertTrue((boolean)w.hasField("Movies", "name"));
        Assert.assertTrue((boolean)w.hasField("Movies", "authors"));
        Assert.assertTrue((boolean)w.hasField("Movies", "category"));
        Assert.assertTrue((boolean)w.hasField("Movies", "date"));
    }

    @Test
    public void testStorageExtensionMethod() {
        List extIds = this.wikittyClient.getAllExtensionIds();
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)8L, (long)extIds.size());
        Assert.assertTrue((boolean)extIds.contains("Movies[2.0]"));
        WikittyExtension ext = this.wikittyClient.restoreExtension("Movies[2.0]");
        Assert.assertEquals((Object)"Movies", (Object)ext.getName());
        Assert.assertEquals((Object)"2.0", (Object)ext.getVersion());
        Assert.assertEquals((Object)MOVIE_EXTENSION, (Object)ext);
    }

    @Test
    public void testStorageExtensionDelete() {
        WikittyExtension volatileExt = new WikittyExtension("VolatileExt", "4.0", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name unique=\"true\""}));
        this.wikittyClient.storeExtension(volatileExt);
        List extIds = this.wikittyClient.getAllExtensionIds();
        Assert.assertTrue((boolean)extIds.contains("VolatileExt[4.0]"));
        this.wikittyClient.deleteExtension("VolatileExt");
        extIds = this.wikittyClient.getAllExtensionIds();
        Assert.assertFalse((boolean)extIds.contains("VolatileExt[4.0]"));
    }

    @Test(expected=WikittyException.class)
    public void testStorageExtensionDeleteUsed() {
        this.wikittyClient.deleteExtension("Movies");
    }

    @Test
    public void testStorageExtensionRequires() {
        this.wikittyClient.storeExtension(MEDIA_EXTENSION);
        this.wikittyClient.storeExtension(MOVIE_EXTENSION);
        List extIds = this.wikittyClient.getAllExtensionsRequires("Media");
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)1L, (long)extIds.size());
        WikittyExtension ext = this.wikittyClient.restoreExtension((String)extIds.get(0));
        Assert.assertEquals((Object)"Movies", (Object)ext.getName());
        Assert.assertEquals((Object)"2.0", (Object)ext.getVersion());
        Assert.assertEquals((Object)MOVIE_EXTENSION, (Object)ext);
    }

    @Test
    public void testStorageRestoreLists() throws ParseException {
        WikittyImpl gf1Movie = new WikittyImpl();
        gf1Movie.addExtension(MEDIA_EXTENSION);
        gf1Movie.addExtension(MOVIE_EXTENSION);
        gf1Movie.setField("Movies", "name", (Object)"The godfather");
        gf1Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf1Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("March 15, 1972")));
        WikittyImpl gf2Movie = new WikittyImpl();
        gf2Movie.addExtension(MEDIA_EXTENSION);
        gf2Movie.addExtension(MOVIE_EXTENSION);
        gf2Movie.setField("Movies", "name", (Object)"The godfather 2");
        gf2Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf2Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("October 12, 1974")));
        WikittyImpl gf3Movie = new WikittyImpl();
        gf3Movie.addExtension(MEDIA_EXTENSION);
        gf3Movie.addExtension(MOVIE_EXTENSION);
        gf3Movie.setField("Movies", "name", (Object)"The godfather 3");
        gf3Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf3Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("July 30, 1990")));
        this.wikittyClient.store((Wikitty)gf1Movie, (Wikitty)gf2Movie, new Wikitty[]{gf3Movie});
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(gf1Movie.getId());
        ids.add(gf2Movie.getId());
        ids.add(gf3Movie.getId());
        List wikitties = this.wikittyClient.restore(ids);
        Assert.assertEquals((Object)"The godfather", (Object)((Wikitty)wikitties.get(0)).getFieldAsString("Movies", "name"));
        Assert.assertEquals((Object)"The godfather 2", (Object)((Wikitty)wikitties.get(1)).getFieldAsString("Movies", "name"));
        Assert.assertEquals((Object)"The godfather 3", (Object)((Wikitty)wikitties.get(2)).getFieldAsString("Movies", "name"));
    }

    @Test
    public void testStorageRestoreSingle() throws Exception {
        WikittyImpl w = new WikittyImpl();
        String id = w.getId();
        w = this.wikittyClient.store((Wikitty)w);
        w = this.wikittyClient.restore(id);
        Assert.assertEquals((Object)id, (Object)w.getId());
    }

    @Test
    public void testStorageRestoreNull() throws Exception {
        Wikitty result = this.wikittyClient.store((Wikitty)null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testFieldConstraint() throws Exception {
        WikittyExtension ext = new WikittyExtension("TestConstraint", "1", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String id notNull=true", "String ext[0-n] unique=true", "String other[0-n] unique=true notNull=true"}));
        this.wikittyClient.storeExtension(ext);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        try {
            w = this.wikittyClient.store((Wikitty)w);
            Assert.fail((String)"not null contraint don't work on String");
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.setField("TestConstraint", "id", (Object)"toto");
        try {
            w = this.wikittyClient.store((Wikitty)w);
            Assert.fail((String)"not null contraint don't work in Collection");
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.addToField("TestConstraint", "other", (Object)"titi");
        w = this.wikittyClient.store((Wikitty)w);
        w.addToField("TestConstraint", "ext", (Object)"tata");
        w.addToField("TestConstraint", "ext", (Object)"titi");
        w = this.wikittyClient.store((Wikitty)w);
        Wikitty w2 = this.wikittyClient.restore(w.getId());
        w2.addToField("TestConstraint", "ext", (Object)"tata");
        w2.addToField("TestConstraint", "ext", (Object)"toto");
        w2 = this.wikittyClient.store(w2);
        Wikitty w3 = this.wikittyClient.restore(w.getId());
        HashSet<String> set = new HashSet<String>(Arrays.asList("tata", "titi", "toto"));
        Assert.assertEquals(set, (Object)w3.getFieldAsSet("TestConstraint", "ext", String.class));
    }

    @Test
    public void testSearchByExampleFacet() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyImpl gf1Movie = new WikittyImpl();
        gf1Movie.addExtension(MEDIA_EXTENSION);
        gf1Movie.addExtension(MOVIE_EXTENSION);
        gf1Movie.setField("Media", "type", (Object)"movie");
        gf1Movie.setField("Movies", "name", (Object)"The godfather");
        gf1Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf1Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("March 15, 1972")));
        WikittyImpl gf2Movie = new WikittyImpl();
        gf2Movie.addExtension(MEDIA_EXTENSION);
        gf2Movie.addExtension(MOVIE_EXTENSION);
        gf2Movie.setField("Media", "type", (Object)"movie");
        gf2Movie.setField("Movies", "name", (Object)"The godfather 2");
        gf2Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf2Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("October 12, 1974")));
        WikittyImpl gf3Movie = new WikittyImpl();
        gf3Movie.addExtension(MEDIA_EXTENSION);
        gf3Movie.addExtension(MOVIE_EXTENSION);
        gf3Movie.setField("Media", "type", (Object)"movie");
        gf3Movie.setField("Movies", "name", (Object)"Fly me to the moon");
        gf3Movie.addToField("Movies", "authors", (Object)"Pixar");
        gf3Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("October 12, 1974")));
        this.wikittyClient.store((Wikitty)gf1Movie, (Wikitty)gf2Movie, new Wikitty[]{gf3Movie});
        WikittyImpl w = new WikittyImpl();
        w.addExtension(MEDIA_EXTENSION);
        w.addExtension(MOVIE_EXTENSION);
        w.setField("Media", "type", (Object)"movie");
        WikittyQuery query = new WikittyQueryMaker().wikitty((Wikitty)w).end();
        query.addFacetField((Element)new ElementField("Movies", "authors"));
        query.addFacetField((Element)new ElementField("Movies", "date"));
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        Assert.assertTrue((boolean)result.getFacetNames().contains("Movies.date"));
        Assert.assertTrue((boolean)result.getFacetNames().contains("Movies.authors"));
        Assert.assertEquals((long)2L, (long)result.getTopic("Movies.authors").size());
        Assert.assertEquals((Object)"Coppola", (Object)((FacetTopic)result.getTopic("Movies.authors").get(0)).getTopicName());
        Assert.assertEquals((long)2L, (long)((FacetTopic)result.getTopic("Movies.authors").get(0)).getCount());
        Assert.assertEquals((Object)"Pixar", (Object)((FacetTopic)result.getTopic("Movies.authors").get(1)).getTopicName());
        Assert.assertEquals((long)1L, (long)((FacetTopic)result.getTopic("Movies.authors").get(1)).getCount());
        Assert.assertEquals((long)2L, (long)result.getTopic("Movies.date").size());
    }

    @Test
    public void testSearchExtensionFacet() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().keyword((Object)"*").end();
        query.setFirst(0);
        query.setLimit(0);
        query.addFacetField((Element)Element.EXTENSION);
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.getFacetNames().size());
        Assert.assertNotNull(result.getFacets().get(Element.EXTENSION.getValue()));
    }

    @Test
    public void testStorageFindDelete() throws ParseException {
        WikittyImpl gf1Movie = new WikittyImpl();
        gf1Movie.addExtension(MEDIA_EXTENSION);
        gf1Movie.addExtension(MOVIE_EXTENSION);
        gf1Movie.setField("Media", "type", (Object)"movie");
        gf1Movie.setField("Movies", "name", (Object)"The godfather");
        gf1Movie.addToField("Movies", "authors", (Object)"Coppola");
        gf1Movie.setField("Movies", "date", (Object)WikittyUtil.formatDate((Date)df.parse("March 15, 1972")));
        String oldVersion = gf1Movie.getVersion();
        Wikitty newWik = this.wikittyClient.store((Wikitty)gf1Movie);
        Assert.assertTrue((boolean)WikittyUtil.versionGreaterThan((String)newWik.getVersion(), (String)oldVersion));
        WikittyImpl w = new WikittyImpl();
        w.addExtension(MEDIA_EXTENSION);
        w.addExtension(MOVIE_EXTENSION);
        w.setField("Movies", "name", (Object)"The godfather");
        WikittyQuery query = new WikittyQueryMaker().wikitty((Wikitty)w).end();
        Wikitty resultFind = (Wikitty)this.wikittyClient.findByQuery(Wikitty.class, query);
        Assert.assertEquals((Object)w.getFieldAsString("Movies", "name"), (Object)resultFind.getFieldAsString("Movies", "name"));
        Assert.assertEquals((Object)gf1Movie.getId(), (Object)resultFind.getId());
        Assert.assertEquals((Object)gf1Movie, (Object)resultFind);
        Assert.assertEquals((Object)gf1Movie.getFieldAsString("Movies", "name"), (Object)resultFind.getFieldAsString("Movies", "name"));
        Assert.assertEquals((Object)gf1Movie.getFieldAsDate("Movies", "date"), (Object)resultFind.getFieldAsDate("Movies", "date"));
        Assert.assertEquals((Object)gf1Movie.getFieldAsSet("Movies", "authors", String.class), (Object)resultFind.getFieldAsSet("Movies", "authors", String.class));
        WikittyQuery query1 = new WikittyQueryMaker().ideq((Object)gf1Movie.getId()).end();
        Wikitty searchedWikitty1 = (Wikitty)this.wikittyClient.findByQuery(Wikitty.class, query1);
        Assert.assertNotNull((Object)searchedWikitty1);
        this.wikittyClient.delete(gf1Movie.getId());
        Wikitty deletedObject = this.wikittyClient.restore(gf1Movie.getId());
        Assert.assertNull((Object)deletedObject);
        Wikitty searchedWikitty2 = (Wikitty)this.wikittyClient.findByQuery(Wikitty.class, query1);
        Assert.assertNull((Object)searchedWikitty2);
    }

    @Test
    public void testStorageAndLabel() throws Exception {
        WikittyQuery query1 = new WikittyQueryMaker().exteq("Movies").end();
        List wikitties = this.wikittyClient.findAllByQuery(Wikitty.class, query1).getAll();
        long ts = new Date().getTime();
        Wikitty w1 = (Wikitty)wikitties.get(0);
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w1.getId(), (String)("titi" + ts));
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w1.getId(), (String)("toto" + ts));
        Wikitty w2 = (Wikitty)wikitties.get(1);
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w2.getId(), (String)("tata" + ts));
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w2.getId(), (String)("titi" + ts));
        Wikitty w3 = (Wikitty)wikitties.get(2);
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w3.getId(), (String)("tutu" + ts));
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)w3.getId(), (String)("titi" + ts));
        Wikitty wt = WikittyLabelUtil.findByLabel((WikittyClient)this.wikittyClient, (String)("toto" + ts));
        Assert.assertEquals((Object)w1, (Object)wt);
        Set labels = WikittyLabelUtil.findAllAppliedLabels((WikittyClient)this.wikittyClient, (String)w2.getId());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("tata" + ts, "titi" + ts)), (Object)labels);
    }

    @Test
    public void testStorageAndClassification() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = new WikittyQueryMaker().exteq("Movies").end();
        List wikitties = this.wikittyClient.findAllByQuery(Wikitty.class, query1).getAll();
        List<Wikitty> wikittyNodes = new ArrayList<Wikitty>();
        WikittyTreeNodeImpl root = new WikittyTreeNodeImpl();
        wikittyNodes.add(root.getWikitty());
        root.setName("MyCategoryRoot");
        for (int i = 0; i < 3; ++i) {
            WikittyTreeNodeImpl leaf = new WikittyTreeNodeImpl();
            wikittyNodes.add(leaf.getWikitty());
            leaf.setName("cat-" + i);
            leaf.setParent(root.getWikittyId());
            for (int j = 0; j < 5; ++j) {
                WikittyTreeNodeImpl subLeaf = new WikittyTreeNodeImpl();
                subLeaf.setName("subcat-" + i + "-" + j);
                subLeaf.setParent(leaf.getWikittyId());
                wikittyNodes.add(subLeaf.getWikitty());
            }
        }
        wikittyNodes = this.wikittyClient.storeWikitty(wikittyNodes);
        Wikitty dieHard = (Wikitty)wikitties.get(0);
        Wikitty edgar = (Wikitty)wikitties.get(1);
        Wikitty knight = (Wikitty)wikitties.get(2);
        this.assign(dieHard, root, "cat-1/subcat-1-4");
        this.assign(edgar, root, "cat-1");
        this.assign(knight, root, "cat-2/subcat-2-4");
        WikittyQueryResultTreeNode t = this.wikittyClient.findTreeNode(WikittyTreeNode.class, root.getWikitty().getId(), 0, false, null);
        Assert.assertEquals((Object)"MyCategoryRoot", (Object)((WikittyTreeNode)t.getObject()).getName());
    }

    @Deprecated
    protected void assign(Wikitty wikitty, WikittyTreeNodeImpl root, String path) {
        String[] nodeNames = path.split("/");
        WikittyTreeNodeImpl currentNode = root;
        block0: for (String nodeName : nodeNames) {
            WikittyTreeNodeImpl node = new WikittyTreeNodeImpl();
            node.setName(nodeName);
            WikittyQuery query = new WikittyQueryMaker().wikitty(node.getWikitty()).end();
            List wikittiesId = this.wikittyClient.findAllByQuery(query).getAll();
            List wikitties = this.wikittyClient.restore(wikittiesId);
            for (Wikitty child : wikitties) {
                if (!child.hasExtension("WikittyTreeNode") || !(node = new WikittyTreeNodeImpl(child)).getName().equals(nodeName)) continue;
                currentNode = node;
                continue block0;
            }
            Assert.fail((String)("Unable to find node " + nodeName + " inside " + currentNode.getName()));
        }
        currentNode.addAttachment(new String[]{wikitty.getId()});
        this.wikittyClient.store(currentNode.getWikitty());
    }

    @Test
    public void testStorageCastTo() {
        WikittyTreeNodeImpl node = new WikittyTreeNodeImpl();
        node.setName("nodeName");
        WikittyLabel label = (WikittyLabel)this.wikittyClient.castTo(WikittyLabel.class, (Object)node);
        label.addLabels(new String[]{"testlabel"});
        label = (WikittyLabel)this.wikittyClient.store((BusinessEntity)label);
        String wikittyId = label.getWikittyId();
        WikittyTreeNode node2 = (WikittyTreeNode)this.wikittyClient.restore(WikittyTreeNode.class, wikittyId);
        Assert.assertEquals((Object)"nodeName", (Object)node2.getName());
        WikittyLabel label2 = (WikittyLabel)this.wikittyClient.castTo(WikittyLabel.class, (Object)node);
        ArrayList labels = new ArrayList(label2.getLabels());
        Assert.assertFalse((boolean)labels.isEmpty());
        Assert.assertEquals((Object)"testlabel", labels.get(0));
    }

    @Test
    public void testStorageVersionForce() {
        WikittyImpl myNewWikitty;
        WikittyImpl myWikitty;
        block2: {
            this.assumeTrueSearchEngineCanRunTest();
            myWikitty = new WikittyImpl();
            myWikitty.addExtension((Collection)WikittyTreeNodeImpl.extensions);
            WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"name");
            myWikitty = this.wikittyClient.store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"1.0", (Object)myWikitty.getVersion());
            myWikitty = this.wikittyClient.store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"1.0", (Object)myWikitty.getVersion());
            WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"new name");
            myWikitty = this.wikittyClient.store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"2.0", (Object)myWikitty.getVersion());
            myNewWikitty = new WikittyImpl(myWikitty.getId());
            myNewWikitty.addExtension((Collection)WikittyTreeNodeImpl.extensions);
            WikittyTreeNodeHelper.setName((Wikitty)myNewWikitty, (String)"new wikitty");
            try {
                myWikitty = this.wikittyClient.store((Wikitty)myNewWikitty);
                Assert.fail((String)"Test must throw WikittyObsoleteException");
            }
            catch (WikittyObsoleteException ex) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Wikitty obsolete", (Throwable)ex);
            }
        }
        WikittyEvent event = this.wikittyClient.getWikittyService().store(null, Collections.singletonList(myWikitty), true);
        event.update((Wikitty)myWikitty);
        Assert.assertEquals((Object)"3.0", (Object)myWikitty.getVersion());
        myNewWikitty.setVersion("11.0");
        event = this.wikittyClient.getWikittyService().store(null, Collections.singletonList(myNewWikitty), true);
        event.update((Wikitty)myNewWikitty);
        Assert.assertEquals((Object)"11.0", (Object)myNewWikitty.getVersion());
    }

    @Test
    public void testStoragePreviouslyDeleted() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyImpl myWikitty = new WikittyImpl();
        myWikitty.addExtension((Collection)WikittyTreeNodeImpl.extensions);
        WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"name");
        myWikitty = this.wikittyClient.store((Wikitty)myWikitty);
        this.wikittyClient.delete(myWikitty.getId());
        Wikitty restoredWikitty = this.wikittyClient.restore(myWikitty.getId());
        Assert.assertNull((Object)restoredWikitty);
        myWikitty = this.wikittyClient.store((Wikitty)myWikitty);
        restoredWikitty = this.wikittyClient.restore(myWikitty.getId());
        Assert.assertNotNull((Object)restoredWikitty);
    }

    @Test
    @Ignore
    public void testStorageBinaryField() {
        String extName = "BinaryExt";
        byte[] bytes = "Coucou le monde".getBytes();
        WikittyExtension BinaryExt = new WikittyExtension(extName, "1.0", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name unique=\"true\"", "Binary content"}));
        WikittyImpl w = new WikittyImpl();
        w.addExtension(BinaryExt);
        w.setField(extName, "name", (Object)"LeBin");
        w.setField(extName, "content", (Object)bytes);
        w = this.wikittyClient.store((Wikitty)w);
        Wikitty restoredWikitty = this.wikittyClient.restore(w.getId());
        Assert.assertNotNull((Object)restoredWikitty);
        Assert.assertEquals((Object)"LeBin", (Object)restoredWikitty.getFieldAsString(extName, "name"));
        Assert.assertEquals((Object)bytes, (Object)restoredWikitty.getFieldAsBytes(extName, "content"));
    }

    @Test
    public void testStoreUnmodifiedEntity() {
        WikittyLabelImpl wikitty1 = new WikittyLabelImpl();
        WikittyLabelImpl wikitty2 = new WikittyLabelImpl();
        ArrayList toStore = new ArrayList();
        Collections.addAll(toStore, wikitty1, wikitty2);
        List stored = this.wikittyClient.store(toStore);
        ((WikittyLabel)stored.get(0)).addLabels(new String[]{"lbl"});
        stored = this.wikittyClient.store(toStore);
        Assert.assertEquals(Collections.singleton("lbl"), (Object)((WikittyLabel)stored.get(0)).getLabels());
    }

    @Test
    public void testFindByQueryMaker() {
        WikittyQuery query = new WikittyQueryMaker().and().like((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"*universe*").end();
        Product product = (Product)this.wikittyClient.findByQuery(Product.class, query);
        Assert.assertEquals((long)4662L, (long)product.totalPrice());
    }

    @Test
    public void testFindByQueryMakerNoneFound() {
        WikittyQuery query = new WikittyQueryMaker().and().like((Element)Element.ALL_FIELD, (Object)"toto").end();
        Product product = (Product)this.wikittyClient.findByQuery(Product.class, query);
        Assert.assertNull((Object)product);
    }

    @Test
    public void testFindByQueryMakerMuliple() {
        WikittyQuery query = new WikittyQueryMaker().and().like((Element)Element.ALL_FIELD, (Object)"*everything*").end();
        query.setLimit(0);
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertTrue((boolean)results.getAll().isEmpty());
    }

    @Test
    public void testFindQueryParser() {
        WikittyQuery query = WikittyQueryParser.parse((String)"ProductPicture.price=420");
        Product product = (Product)this.wikittyClient.findByQuery(Product.class, query);
        Assert.assertEquals((long)420L, (long)product.getPicturePrice());
    }

    @Test
    public void testFindQueryParserMuliple() {
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.price=[0 TO 99] Product.colors!=red");
        WikittyQueryResult product = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)2L, (long)product.getTotalResult());
    }

    @Test
    public void testFindQueryOnMovies() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().eq("Movies.name", (Object)"*ar?*").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testExportXml() {
        WikittyImportExportService ieService = new WikittyImportExportService(this.wikittyClient);
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Element.EXTENSION, (Object)"WikittyTreeNode").end();
        String xmlExport = ieService.syncExportAllByQuery(WikittyImportExportService.FORMAT.XML, query);
        Assert.assertTrue((boolean)xmlExport.contains("<extension name='WikittyTreeNode' version='2.0'>"));
        Assert.assertTrue((boolean)xmlExport.contains("<WikittyTreeNode.name>Books</WikittyTreeNode.name>"));
        Assert.assertTrue((boolean)xmlExport.contains("extensions='WikittyTreeNode[2.0],CatalogNode[2.0]'"));
        Assert.assertTrue((boolean)xmlExport.contains("<WikittyTreeNode.attachment>"));
    }

    @Test
    public void testImportXml() throws IOException {
        WikittyImportExportService ieService = new WikittyImportExportService(this.wikittyClient);
        InputStream is = WikittyClientTest.class.getResourceAsStream("/xml/importclient.xml");
        InputStreamReader reader = new InputStreamReader(is);
        ieService.syncImport(WikittyImportExportService.FORMAT.XML, (Reader)reader);
        reader.close();
        Wikitty wClient = this.wikittyClient.restore("fbcc8aed-7f67-4e3c-a9aa-221373765f8d");
        Assert.assertEquals((Object)"Entreprise dupont", (Object)wClient.getFieldAsString("Client", "name"));
        WikittyTreeNode node = (WikittyTreeNode)this.wikittyClient.restore(WikittyTreeNode.class, "0d13cb0b-bc06-431c-9438-7bcb357f45da");
        Assert.assertEquals((Object)"MySubNode", (Object)node.getName());
    }

    @Test
    public void testExportCSV() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyImportExportService ieService = new WikittyImportExportService(this.wikittyClient);
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Element.EXTENSION, (Object)"WikittyTreeNode").end();
        String csvExport = ieService.syncExportAllByQuery(WikittyImportExportService.FORMAT.CSV, query);
        Assert.assertTrue((boolean)csvExport.startsWith("\"Wikitty.Id\",\"Wikitty.Ext\",\"WikittyTreeNode.attachment\",\"WikittyTreeNode.name\",\"WikittyTreeNode.parent\""));
        Assert.assertTrue((boolean)csvExport.contains("\"WikittyTreeNode,CatalogNode\",,\"Everything else\""));
        Assert.assertTrue((boolean)csvExport.contains("\"WikittyTreeNode,CatalogNode\",,\"Catalog\""));
        Assert.assertTrue((boolean)csvExport.contains("\"WikittyTreeNode,CatalogNode\",,\"Books\""));
        Assert.assertTrue((boolean)csvExport.contains("Nouvelles"));
    }

    @Test
    public void testImportCSVBooks() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Element.EXTENSION, (Object)"Product").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)17L, (long)results.getTotalResult());
    }

    @Test
    public void testImportCSVBooksLinks() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"Da vinci code").end();
        Product product = (Product)this.wikittyClient.findByQuery(Product.class, query);
        String categoryId = product.getCategory();
        Category category = (Category)this.wikittyClient.restore(Category.class, categoryId);
        Assert.assertEquals((Object)"science fiction", (Object)category.getName());
    }

    @Test
    public void testImportClients() throws IOException {
        this.importClients();
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Element.EXTENSION, (Object)"Tag").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)results.getTotalResult());
        WikittyQuery query2 = new WikittyQueryMaker().eq("Client.name", (Object)"Entreprise dupont").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(query2);
        Assert.assertEquals((long)1L, (long)results2.getTotalResult());
        WikittyQuery query3 = new WikittyQueryMaker().eq((Element)WikittyTreeNode.ELEMENT_FIELD_WIKITTYTREENODE_NAME, (Object)"MyTreeNode").end();
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(WikittyTreeNode.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        WikittyTreeNode myTreeNode = (WikittyTreeNode)results3.get(0);
        Assert.assertEquals((long)1L, (long)myTreeNode.getAttachment().size());
        WikittyQuery query4 = new WikittyQueryMaker().eq((Element)WikittyTreeNode.ELEMENT_FIELD_WIKITTYTREENODE_PARENT, (Object)myTreeNode.getWikittyId()).end();
        WikittyQueryResult results4 = this.wikittyClient.findAllByQuery(WikittyTreeNode.class, query4);
        Assert.assertEquals((long)1L, (long)results4.getTotalResult());
        WikittyTreeNode mySubNode = (WikittyTreeNode)results4.get(0);
        Assert.assertEquals((Object)"MySubNode", (Object)mySubNode.getName());
    }

    @Test
    public void testImportTwice() throws IOException {
        this.importClients();
        Wikitty w = this.wikittyClient.restore("fbcc8aed-7f67-4e3c-a9aa-221373765f8d");
        Assert.assertNotNull((String)"Erreur d'import de fichier csv", (Object)w);
        w.setField("Client", "name", (Object)"titi");
        this.wikittyClient.store(w);
        this.importClients();
        w = this.wikittyClient.restore("fbcc8aed-7f67-4e3c-a9aa-221373765f8d");
        Assert.assertEquals((Object)"Entreprise dupont", (Object)w.getFieldAsString("Client", "name"));
    }

    @Test
    public void testI18n() {
        WikittyLabelImpl label = new WikittyLabelImpl();
        Wikitty labelWikitty = (Wikitty)this.wikittyClient.castTo(Wikitty.class, (Object)label);
        WikittyExtension ext = labelWikitty.getExtension("WikittyLabel");
        WikittyI18n i18n = WikittyI18nUtil.getI18n((WikittyClient)this.wikittyClient, (WikittyExtension)ext);
        i18n.setTranslation("fr", "labels", "\u00e9tiquette");
        this.wikittyClient.store((BusinessEntity)i18n);
        String trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
        Assert.assertEquals((long)1L, (long)i18n.getLang().size());
        Assert.assertEquals((Object)"fr", i18n.getLang().iterator().next());
        Assert.assertEquals((Object)"[fr:\"labels\"=\"\u00e9tiquette\"]", (Object)i18n.getTranslations());
        i18n.setTranslation("es", "labels", "etiqueta");
        Assert.assertEquals((long)2L, (long)i18n.getLang().size());
        WikittyI18nTestUtil.cleanCache(i18n);
        trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
    }

    @Test
    public void testFindAllByLabel() {
        WikittyExtension ext = ExtensionFactory.create((String)"test", (String)"1").addField("toto", WikittyTypes.NUMERIC).extension();
        WikittyImpl w = new WikittyImpl();
        String id = w.getId();
        w.addExtension(ext);
        w.setField(ext.getName(), "toto", (Object)42);
        this.wikittyClient.store((Wikitty)w);
        WikittyLabelUtil.addLabel((WikittyClient)this.wikittyClient, (String)id, (String)"hello");
        WikittyQueryResult wikitties = WikittyLabelUtil.findAllByLabel((WikittyClient)this.wikittyClient, (String)"hello", (int)0, (int)1);
        Assert.assertEquals((Object)wikitties.get(0), (Object)w);
    }

    @Test
    public void testQueryMakerEq() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().eq((Element)Product.ELEMENT_FIELD_PRODUCT_PRICE, (Object)42).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)1L, (long)results.getTotalResult());
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Product resultP = (Product)results.peek();
        Assert.assertEquals((Object)"Answer to life the universe and everything", (Object)resultP.getName());
        Assert.assertEquals((long)42L, (long)resultP.getPriceFromProduct());
        WikittyQuery query2 = new WikittyQueryMaker().eq((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"Indign*").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)1L, (long)results2.getTotalResult());
        Assert.assertEquals((long)1L, (long)results2.getAll().size());
        WikittyQuery query3 = new WikittyQueryMaker().eq((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"Indign*").end();
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        Assert.assertEquals((long)1L, (long)results3.getAll().size());
    }

    @Test
    public void testQueryMakerEqFqf() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().eq("Product.price", (Object)42).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)1L, (long)results.getTotalResult());
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Product resultP = (Product)results.peek();
        Assert.assertEquals((Object)"Answer to life the universe and everything", (Object)resultP.getName());
        Assert.assertEquals((long)42L, (long)resultP.getPriceFromProduct());
        WikittyQuery query2 = new WikittyQueryMaker().eq("Product.name", (Object)"Indign*").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)1L, (long)results2.getTotalResult());
        Assert.assertEquals((long)1L, (long)results2.getAll().size());
        WikittyQuery query3 = new WikittyQueryMaker().eq("Product.name", (Object)"Indign*").end();
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        Assert.assertEquals((long)1L, (long)results3.getAll().size());
    }

    @Test
    public void testQueryMakerNeq() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().ne("Product.price", (Object)42).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)21L, (long)results.getTotalResult());
        Assert.assertEquals((long)21L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerBw() {
        WikittyQuery query = new WikittyQueryMaker().bw("Product.price", (Object)14, (Object)99).end();
        query.setLimit(-1);
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerLt() {
        WikittyQuery query = new WikittyQueryMaker().lt("Product.price", (Object)15).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)1L, (long)results.getTotalResult());
        Assert.assertEquals((long)1L, (long)results.getAll().size());
    }

    @Test
    public void testQueryParserLe() {
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.price <= 15");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerGt() {
        WikittyQuery query = new WikittyQueryMaker().gt("Product.price", (Object)15).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testQueryParserGe() {
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.price >= 15");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)3L, (long)results.getTotalResult());
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerContainsAll() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().containsAll((Element)Product.ELEMENT_FIELD_PRODUCT_COLORS, Arrays.asList("white", "black")).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testQueryParserContainsAll() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.colors=[white, black]");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerContainsOne() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().containsOne((Element)Product.ELEMENT_FIELD_PRODUCT_COLORS, Arrays.asList("white", "black")).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)9L, (long)results.getTotalResult());
        Assert.assertEquals((long)9L, (long)results.getAll().size());
    }

    @Test
    public void testQueryParserContainsOne() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.colors={white, black}");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)9L, (long)results.getTotalResult());
        Assert.assertEquals((long)9L, (long)results.getAll().size());
    }

    @Test
    public void testQueryParserExteq() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"extension=Product");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)17L, (long)results.getTotalResult());
        Assert.assertEquals((long)17L, (long)results.getAll().size());
    }

    @Test
    public void testQueryMakerIdeq() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().ideq((Object)"db9dc782-e650-4fd4-83ac-3c1c5c136cde").end();
        Product p = (Product)this.wikittyClient.findByQuery(Product.class, query);
        Assert.assertEquals((Object)"Da vinci code", (Object)p.getName());
    }

    @Test
    public void testQueryParserIdeq() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"id=db9dc782-e650-4fd4-83ac-3c1c5c136cde");
        Product p = (Product)this.wikittyClient.findByQuery(Product.class, query);
        Assert.assertEquals((Object)"Da vinci code", (Object)p.getName());
    }

    @Test
    public void testQueryMakerIdneq() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().idne((Object)"db9dc782-e650-4fd4-83ac-3c1c5c136cde").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)34L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserIdneq() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"id!=db9dc782-e650-4fd4-83ac-3c1c5c136cde");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)34L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerUnlike() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().unlike((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"*Potter*").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)29L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserUnlike() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name UNLIKE *Potter*");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)29L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerLike() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().like((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"*potter*").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)6L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserLike() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name LIKE *potter*");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)6L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerSw() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().sw((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, "Harry").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)6L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserEw() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name=*sorciers");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)1L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerNotsw() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().notsw((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, "Harry").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)29L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserNotsw() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name!=Harry*");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)29L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerNotew() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().notew((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"sorciers").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)34L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserNotew() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name!=*sorciers");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)34L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerKeyword() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().keyword((Object)"potter").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)6L, (long)results.getTotalResult());
        WikittyQuery query2 = new WikittyQueryMaker().keyword((Object)"yellow").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)2L, (long)results2.getTotalResult());
    }

    @Test
    public void testQueryParserKeyword() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"potter");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)6L, (long)results.getTotalResult());
        WikittyQuery query2 = WikittyQueryParser.parse((String)"yellow");
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)2L, (long)results2.getTotalResult());
    }

    @Test
    public void testQueryMakerIsNull() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().isNull((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserIsNull() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.category=NULL");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)2L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerIsNotNull() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().isNotNull((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)15L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserIsNotNull() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.category!=NULL");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)15L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerFalse() {
        WikittyQuery query = new WikittyQueryMaker().rFalse().end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)0L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerTrue() {
        WikittyQuery query = new WikittyQueryMaker().rTrue().end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)22L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParseTrue() {
        WikittyQuery query = WikittyQueryParser.parse((String)"TRUE");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)22L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParseFalse() {
        WikittyQuery query = WikittyQueryParser.parse((String)"FALSE");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)0L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerAnd() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().and().sw("Product.name", "Harry").notew((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"sorciers").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)5L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserAnd() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name=Harry* Product.name!=*sorciers");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)5L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerOr() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().or().sw("Product.name", "Harry").like((Element)Product.ELEMENT_FIELD_PRODUCT_NAME, (Object)"*code*").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)7L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserOr() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.name=Harry* OR Product.name LIKE *code*");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(Product.class, query);
        Assert.assertEquals((long)7L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerNot() {
        WikittyQuery query = new WikittyQueryMaker().not().exteq("Product").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)18L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryMakerSelect() throws IOException {
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().and().bw((Element)Product.ELEMENT_FIELD_PRODUCT_PRICE, (Object)0, (Object)75).containsOne((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).select((Element)Element.ID).eq("Category.code", (Object)"history").end();
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)3L, (long)results.getTotalResult());
    }

    @Test
    public void testQueryParserSelect() throws IOException {
        this.importBooks();
        WikittyQuery query = WikittyQueryParser.parse((String)"Product.price=[0 TO 75] AND Product.category={SELECT id WHERE Category.code = history}");
        WikittyQueryResult results = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)3L, (long)results.getTotalResult());
    }

    @Test
    public void testSearchFacetSingleField() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().exteq("Product").end();
        query.setLimit(0);
        query.addFacetField((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY);
        query.setFacetSort(FacetSortType.count);
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)4L, (long)result.getTopic((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).size());
        Assert.assertEquals((long)10L, (long)((FacetTopic)result.getTopic((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).get(0)).getCount());
        Assert.assertEquals((long)3L, (long)((FacetTopic)result.getTopic((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).get(1)).getCount());
        Assert.assertEquals((long)1L, (long)((FacetTopic)result.getTopic((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).get(2)).getCount());
        Assert.assertEquals((long)1L, (long)((FacetTopic)result.getTopic((Element)Product.ELEMENT_FIELD_PRODUCT_CATEGORY).get(3)).getCount());
    }

    @Test
    @Ignore
    public void testQueryMarkerWilcardEquals() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = new WikittyQueryMaker().eq("Product.name", (Object)"Lanfeust").end();
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)1L, (long)results1.getTotalResult());
        WikittyQuery query2 = new WikittyQueryMaker().eq("*.name", (Object)"Lanfeust").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)1L, (long)results2.getTotalResult());
        WikittyQuery query3 = new WikittyQueryMaker().eq("Product.name." + WikittyTypes.STRING, (Object)"Lanfeust").end();
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        WikittyQuery query4 = new WikittyQueryMaker().eq("*.name." + WikittyTypes.STRING, (Object)"Lanfeust").end();
        WikittyQueryResult results4 = this.wikittyClient.findAllByQuery(Product.class, query4);
        Assert.assertEquals((long)1L, (long)results4.getTotalResult());
    }

    @Test
    @Ignore
    public void testQueryParserWilcardEquals() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = WikittyQueryParser.parse((String)"Product.name=Lanfeust");
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)1L, (long)results1.getTotalResult());
        WikittyQuery query2 = WikittyQueryParser.parse((String)"*.name=Lanfeust");
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)1L, (long)results2.getTotalResult());
        WikittyQuery query3 = WikittyQueryParser.parse((String)"Product.name.STRING=Lanfeust");
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        WikittyQuery query4 = WikittyQueryParser.parse((String)"*.name.STRING=Lanfeust");
        WikittyQueryResult results4 = this.wikittyClient.findAllByQuery(Product.class, query4);
        Assert.assertEquals((long)1L, (long)results4.getTotalResult());
    }

    @Test
    public void testQueryMakerLowerCaseSearch() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = new WikittyQueryMaker().eq("Product.name", (Object)"Lanfeust").end();
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)1L, (long)results1.getTotalResult());
        WikittyQuery query2 = new WikittyQueryMaker().eq("Product.name", (Object)"lanfeust").end();
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)0L, (long)results2.getTotalResult());
        WikittyQuery query3 = new WikittyQueryMaker().like("Product.name", (Object)"Lanfeust").end();
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        WikittyQuery query4 = new WikittyQueryMaker().like("Product.name", (Object)"lanfeust").end();
        WikittyQueryResult results4 = this.wikittyClient.findAllByQuery(Product.class, query4);
        Assert.assertEquals((long)1L, (long)results4.getTotalResult());
    }

    @Test
    public void testQueryParserLowerCaseSearch() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = WikittyQueryParser.parse((String)"Product.name=Lanfeust");
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)1L, (long)results1.getTotalResult());
        WikittyQuery query2 = WikittyQueryParser.parse((String)"Product.name=lanfeust");
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Product.class, query2);
        Assert.assertEquals((long)0L, (long)results2.getTotalResult());
        WikittyQuery query3 = WikittyQueryParser.parse((String)"Product.name LIKE Lanfeust");
        WikittyQueryResult results3 = this.wikittyClient.findAllByQuery(Product.class, query3);
        Assert.assertEquals((long)1L, (long)results3.getTotalResult());
        WikittyQuery query4 = WikittyQueryParser.parse((String)"Product.name LIKE lanfeust");
        WikittyQueryResult results4 = this.wikittyClient.findAllByQuery(Product.class, query4);
        Assert.assertEquals((long)1L, (long)results4.getTotalResult());
    }

    @Test
    public void testSearchWithSort1() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = WikittyQueryParser.parse((String)"*.name=*");
        query1.setSortAscending(new Element[]{new ElementField("*.name")});
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)15L, (long)results1.getTotalResult());
    }

    @Test
    public void testSearchWithSort2() {
        this.assumeTrueSearchEngineCanRunTest();
        String sortableExtName = "sortable";
        String numFieldName = "num";
        WikittyExtension sortable = ExtensionFactory.create((String)sortableExtName, (String)"1.0").addField(numFieldName, WikittyTypes.NUMERIC).extension();
        this.wikittyClient.storeExtension(sortable);
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(10);
        expected.add(1);
        expected.add(7);
        for (Integer i : expected) {
            WikittyImpl w = new WikittyImpl();
            w.addExtension(sortable);
            w.setField(sortableExtName, numFieldName, (Object)i);
            this.wikittyClient.store((Wikitty)w);
        }
        Collections.sort(expected);
        WikittyQuery query2 = new WikittyQueryMaker().exteq(sortableExtName).end();
        query2.setSortAscending(new Element[]{new ElementField(WikittyUtil.getFQFieldName((String)sortableExtName, (String)numFieldName))});
        WikittyQueryResult results2 = this.wikittyClient.findAllByQuery(Wikitty.class, query2);
        ArrayList<Integer> resulted = new ArrayList<Integer>();
        for (Wikitty w : results2.getAll()) {
            resulted.add(w.getFieldAsInt(sortableExtName, numFieldName));
        }
        Assert.assertEquals(expected, resulted);
    }

    @Test
    public void testSearchWithSortTestData() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query1 = WikittyQueryParser.parse((String)"Product.price <= 100");
        query1.setSortDescending(new Element[]{Product.ELEMENT_FIELD_PRODUCT_PRICE});
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(Product.class, query1);
        Assert.assertEquals((long)100L, (long)((Product)results1.get(0)).getPriceFromProduct());
        Assert.assertEquals((long)42L, (long)((Product)results1.get(1)).getPriceFromProduct());
        Assert.assertEquals((long)15L, (long)((Product)results1.get(2)).getPriceFromProduct());
        Assert.assertEquals((long)13L, (long)((Product)results1.get(3)).getPriceFromProduct());
    }

    @Test
    @Ignore
    public void testSearchWithAccent() {
        WikittyGroupImpl group = new WikittyGroupImpl();
        group.setName("coucou");
        WikittyGroupImpl groupAccent = new WikittyGroupImpl();
        groupAccent.setName("\u00e7\u00e9\u00e7\u00e0");
        this.wikittyClient.store((BusinessEntity)group, (BusinessEntity)groupAccent, (BusinessEntity[])new WikittyGroupImpl[0]);
        WikittyQuery query = new WikittyQueryMaker().keyword((Object)"coucou").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        query = new WikittyQueryMaker().keyword((Object)"\u00e7\u00e9\u00e7\u00e0").end();
        result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"\u00e7\u00e9\u00e7\u00e0").end();
        result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        query = new WikittyQueryMaker().eq("WikittyGroup.name_c_t", (Object)"ceca").end();
        result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        query = new WikittyQueryMaker().eq("WikittyGroup.name_c_t", (Object)"CECA").end();
        result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
        query = new WikittyQueryMaker().like("WikittyGroup.name", (Object)"ceca").end();
        result = this.wikittyClient.findAllByQuery(query);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testPaginedSearchSelect() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query1 = new WikittyQueryMaker().select((Element)Product.ELEMENT_FIELD_PRODUCT_PRICE).exteq("Product").end();
        query1.setSortAscending(new Element[]{Product.ELEMENT_FIELD_PRODUCT_PRICE});
        query1.setFirst(0);
        query1.setLimit(2);
        WikittyQueryResult results1 = this.wikittyClient.findAllByQuery(query1);
        Assert.assertEquals((long)11L, (long)results1.getTotalResult());
        Assert.assertEquals((long)2L, (long)results1.getAll().size());
        Assert.assertEquals((Object)"13.0", (Object)results1.get(0));
        query1.setFirst(0);
        query1.setLimit(0);
        results1 = this.wikittyClient.findAllByQuery(query1);
        Assert.assertEquals((long)11L, (long)results1.getTotalResult());
        Assert.assertEquals((long)0L, (long)results1.getAll().size());
    }

    @Test
    public void testQueryMarkerSelectSortAndAggregate() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyExtension ext = new WikittyExtension("Test", "1.0", WikittyUtil.tagValuesToMap((String)" version=\"1.0\""), (List)null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"Numeric number", "String string", "Date date"}));
        WikittyImpl w1 = new WikittyImpl();
        w1.addExtension(ext);
        w1.setField("Test", "number", (Object)5);
        w1.setField("Test", "date", (Object)WikittyUtil.parseDate((String)"02/05/1975"));
        WikittyImpl w2 = new WikittyImpl();
        w2.addExtension(ext);
        w2.setField("Test", "number", (Object)-4);
        w2.setField("Test", "date", (Object)WikittyUtil.parseDate((String)"19830606"));
        WikittyImpl w3 = new WikittyImpl();
        w3.addExtension(ext);
        w3.setField("Test", "number", (Object)10);
        w3.setField("Test", "date", (Object)WikittyUtil.parseDate((String)"21/05/2002"));
        WikittyImpl w4 = new WikittyImpl();
        w4.addExtension(ext);
        w4.setField("Test", "number", (Object)1);
        w4.setField("Test", "date", (Object)WikittyUtil.parseDate((String)"05/01/2012"));
        this.wikittyClient.store((Wikitty)w1, (Wikitty)w2, new Wikitty[]{w3, w4});
        WikittyQuery q = new WikittyQueryMaker().select("Test.number").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        q = new WikittyQueryMaker().select("Test.number").end().addSortDescending(new Element[]{new ElementField("Test", "number")});
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        q = new WikittyQueryMaker().select("Test.date").end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        q = new WikittyQueryMaker().select("Test.date").end().addSortDescending(new Element[]{new ElementField("Test", "date")});
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        q = new WikittyQueryMaker().select("Test.number", Aggregate.AVG).end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"3", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.COUNT).end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"4", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.MAX).end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"10.0", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.MAX).end().addSortDescending(new Element[]{new ElementField("Test", "number")});
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"10.0", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.MIN).end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"-4.0", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.MIN).end().addSortDescending(new Element[]{new ElementField("Test", "number")});
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"-4.0", (Object)result.peek());
        q = new WikittyQueryMaker().select("Test.number", Aggregate.SUM).end();
        result = this.wikittyClient.findAllByQuery(q);
        System.out.println("q: " + result);
        Assert.assertEquals((Object)"12", (Object)result.peek());
    }

    @Test
    public void testQueryMakerFacetOnGroup() throws Exception {
        WikittyGroupImpl g1 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g1"));
        g1.setName("Group1");
        WikittyGroupImpl g2 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g2"));
        g2.setName("GROUP");
        WikittyGroupImpl g3 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g3"));
        g3.setName("Group3");
        WikittyGroupImpl g4 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g4"));
        g4.setName("GROUP");
        this.wikittyClient.store((BusinessEntity)g1, (BusinessEntity)g2, (BusinessEntity[])new WikittyGroupImpl[]{g3, g4});
        WikittyQuery query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"Group*").end().addFacetField((Element)WikittyGroup.ELEMENT_FIELD_WIKITTYGROUP_NAME);
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testFacet" + result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)((List)result.getFacets().get("WikittyGroup.name")).size());
        query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"GROUP").end().addFacetField((Element)WikittyGroup.ELEMENT_FIELD_WIKITTYGROUP_NAME);
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testFacet" + result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((List)result.getFacets().get("WikittyGroup.name")).size());
        Assert.assertEquals((long)2L, (long)((FacetTopic)((List)result.getFacets().get("WikittyGroup.name")).get(0)).getCount());
        query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"GROUP").end().addFacetField((Element)WikittyGroup.ELEMENT_FIELD_WIKITTYGROUP_NAME).setLimit(0);
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testFacet" + result);
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((List)result.getFacets().get("WikittyGroup.name")).size());
        Assert.assertEquals((long)2L, (long)((FacetTopic)((List)result.getFacets().get("WikittyGroup.name")).get(0)).getCount());
    }

    @Test
    public void testQueryMakerEqOnGroup() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyGroupImpl g1 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g1"));
        g1.setName("Group1");
        WikittyGroupImpl g2 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g2"));
        g2.setName("GROUP2");
        this.wikittyClient.store((BusinessEntity)g1, (BusinessEntity)g2, (BusinessEntity[])new WikittyGroupImpl[0]);
        WikittyQuery query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"Group1").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testEq" + result.getAll());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)g1.getWikittyId(), (Object)result.peek());
        query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"Group*").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testEq" + result.getAll());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)g1.getWikittyId(), (Object)result.peek());
        query = new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"G*").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testEq" + result.getAll());
        Assert.assertEquals((long)2L, (long)result.size());
        query = new WikittyQueryMaker().like("WikittyGroup.name", (Object)"*oup*").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testLike" + result);
        Assert.assertEquals((long)2L, (long)result.size());
        query = new WikittyQueryMaker().like("*", (Object)"Grou*").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testLike" + result);
        Assert.assertEquals((long)2L, (long)result.size());
        query = new WikittyQueryMaker().keyword((Object)"Gro").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println("testKeyword:" + result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testQueryMarkerSelect() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyImpl w = new WikittyImpl("g1");
        WikittyGroupImpl g1 = new WikittyGroupImpl((Wikitty)w);
        g1.setName("Group1");
        w = new WikittyImpl("g2");
        WikittyGroupImpl g2 = new WikittyGroupImpl((Wikitty)w);
        g2.setName("GROUP2");
        w = new WikittyImpl("l1");
        WikittyLabelImpl l1 = new WikittyLabelImpl((Wikitty)w);
        l1.addLabels(new String[]{g1.getName()});
        this.wikittyClient.store((BusinessEntity)g1, (BusinessEntity)g2, (BusinessEntity[])new BusinessEntityImpl[]{l1});
        WikittyQuery query = new WikittyQueryMaker().select("WikittyGroup.name").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        System.out.println(result.getAll());
        Assert.assertEquals((long)2L, (long)result.getTotalResult());
        query = new WikittyQueryMaker().and().exteq("WikittyGroup").containsOne("WikittyGroup.name").select("WikittyLabel.labels").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println(result.getAll());
        Assert.assertEquals((long)1L, (long)result.getTotalResult());
    }

    @Test
    public void testQueryParserOnTree() throws Exception {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQueryParser parser = new WikittyQueryParser();
        parser.addAlias("MyAlias\\((.*), (.*)\\)", "id={SELECT WikittyTreeNode.attachment WHERE (rootNode={SELECT ID WHERE (WikittyTreeNode.name=$1)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=$2)})}");
        WikittyQuery q1 = parser.parseQuery("WikittyGroup.name=Group* AND MyAlias(OtherTree, OtherBranch)");
        WikittyQuery q2 = parser.parseQuery("WikittyGroup.name=Group* AND id={SELECT WikittyTreeNode.attachment WHERE (rootNode={SELECT ID WHERE (WikittyTreeNode.name=OtherTree)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=OtherBranch)})}");
        System.out.println("Q1:" + q1);
        System.out.println("Q2:" + q2);
        Assert.assertEquals((Object)q2, (Object)q1);
        WikittyGroupImpl g1 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g1"));
        g1.setName("Group1");
        WikittyGroupImpl g2 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g2"));
        g2.setName("GROUP2");
        WikittyGroupImpl g3 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g3"));
        g3.setName("Group3");
        WikittyGroupImpl g4 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g4"));
        g4.setName("group4");
        WikittyTreeNodeImpl root = new WikittyTreeNodeImpl((Wikitty)new WikittyImpl("root"));
        root.setName("OtherTree");
        WikittyTreeNodeImpl node = new WikittyTreeNodeImpl((Wikitty)new WikittyImpl("node1"));
        node.setName("node1");
        node.setParent(root.getWikittyId());
        node.addAttachment(new String[]{g1.getWikittyId(), g2.getWikittyId()});
        WikittyTreeNodeImpl branch = new WikittyTreeNodeImpl((Wikitty)new WikittyImpl("branch"));
        branch.setName("OtherBranch");
        branch.setParent(node.getWikittyId());
        WikittyTreeNodeImpl leaf = new WikittyTreeNodeImpl((Wikitty)new WikittyImpl("leaf"));
        leaf.setName("leaf");
        leaf.setParent(branch.getWikittyId());
        leaf.addAttachment(new String[]{g3.getWikittyId(), g4.getWikittyId()});
        this.wikittyClient.store((BusinessEntity)g1, (BusinessEntity)g2, new BusinessEntity[]{g3, g4, root, node, branch, leaf});
        WikittyQuery q0 = parser.parseQuery("rootNode={SELECT ID WHERE (WikittyTreeNode.name=OtherTree)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=OtherBranch)}");
        System.out.println("qO: " + q0);
        WikittyQueryResult q0Result = this.wikittyClient.findAllByQuery(q0);
        System.out.println("q0Result:" + q0Result);
        q0 = parser.parseQuery("SELECT WikittyTreeNode.attachment WHERE (rootNode={SELECT ID WHERE (WikittyTreeNode.name=OtherTree)} AND pathNode={SELECT ID WHERE (WikittyTreeNode.name=OtherBranch)})").addFacetField((Element)WikittyTreeNode.ELEMENT_FIELD_WIKITTYTREENODE_ATTACHMENT);
        System.out.println("qO: " + q0);
        q0Result = this.wikittyClient.findAllByQuery(q0);
        System.out.println("q0Result:" + q0Result);
        q0 = parser.parseQuery("SELECT WikittyTreeNode.attachment WHERE (ID={branch, leaf})").addFacetField((Element)WikittyTreeNode.ELEMENT_FIELD_WIKITTYTREENODE_ATTACHMENT);
        System.out.println("qO: " + q0);
        q0Result = this.wikittyClient.findAllByQuery(q0);
        System.out.println("q0Result:" + q0Result);
        q0 = parser.parseQuery("ID={branch, leaf}").addFacetField((Element)WikittyTreeNode.ELEMENT_FIELD_WIKITTYTREENODE_ATTACHMENT);
        System.out.println("qO: " + q0);
        q0Result = this.wikittyClient.findAllByQuery(q0);
        System.out.println("q0Result:" + q0Result);
        q0 = parser.parseQuery("WikittyGroup.name=Group*");
        System.out.println("q0: " + q0);
        q0Result = this.wikittyClient.findAllByQuery(q0);
        System.out.println("q0Result:" + q0Result);
        WikittyQueryResult q1Result = this.wikittyClient.findAllByQuery(q1);
        WikittyQueryResult q2Result = this.wikittyClient.findAllByQuery(q2);
        System.out.println("q2Result: " + q2Result);
        Assert.assertEquals((Object)q2Result.getAll(), (Object)q1Result.getAll());
        Assert.assertEquals((long)1L, (long)q2Result.size());
        Assert.assertEquals(Collections.singletonList(g3.getWikittyId()), (Object)q2Result.getAll());
    }

    @Test
    public void testSearchEngineFullTextSearch() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyImpl w = new WikittyImpl("label");
        WikittyLabelImpl l = new WikittyLabelImpl((Wikitty)w);
        l.addLabels(new String[]{"label"});
        w = new WikittyImpl("LABEL");
        WikittyLabelImpl l2 = new WikittyLabelImpl((Wikitty)w);
        l2.addLabels(new String[]{"OTHER LABEL"});
        w = new WikittyImpl("TATA");
        WikittyUserImpl u = new WikittyUserImpl((Wikitty)w);
        u.setLogin("tata");
        ArrayList<Wikitty> toStore = new ArrayList<Wikitty>();
        toStore.add(l.getWikitty());
        toStore.add(l2.getWikitty());
        toStore.add(u.getWikitty());
        this.wikittyClient.storeWikitty(toStore);
        WikittyQuery query = new WikittyQueryMaker().keyword((Object)"lab*").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(query);
        System.out.println(result.getAll());
        Assert.assertEquals((long)2L, (long)result.getTotalResult());
        query = new WikittyQueryMaker().and().exteq("WikittyLabel").keyword((Object)"*a*").end();
        result = this.wikittyClient.findAllByQuery(query);
        System.out.println(result.getAll());
        Assert.assertEquals((long)2L, (long)result.getTotalResult());
    }

    @Test
    public void testReindexWithAttachement() {
        WikittyImpl attach1 = new WikittyImpl("att1");
        WikittyImpl attach2 = new WikittyImpl("att2");
        ArrayList<WikittyImpl> toStore = new ArrayList<WikittyImpl>();
        toStore.add(attach1);
        toStore.add(attach2);
        this.wikittyClient.storeWikitty(toStore);
        WikittyImpl treeNode = new WikittyImpl();
        WikittyTreeNodeImpl treeNodeImpl = new WikittyTreeNodeImpl((Wikitty)treeNode);
        treeNodeImpl.setName("root");
        treeNodeImpl.addAttachment(new String[]{attach1.getId()});
        treeNodeImpl.addAttachment(new String[]{attach2.getId()});
        this.wikittyClient.store((Wikitty)treeNode);
        this.wikittyClient.syncSearchEngine();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"root").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(Wikitty.class, query);
        Assert.assertEquals((long)1L, (long)result.getTotalResult());
        WikittyTreeNodeImpl resultTreeNode = new WikittyTreeNodeImpl((Wikitty)result.get(0));
        Assert.assertEquals((long)2L, (long)resultTreeNode.getAttachment().size());
    }

    @Test
    public void testReindexWithAttachementOrdering() {
        WikittyImpl treeNode = new WikittyImpl();
        WikittyTreeNodeImpl treeNodeImpl = new WikittyTreeNodeImpl((Wikitty)treeNode);
        treeNodeImpl.setName("root");
        treeNode = this.wikittyClient.store((Wikitty)treeNode);
        treeNodeImpl = new WikittyTreeNodeImpl((Wikitty)treeNode);
        WikittyImpl attach1 = new WikittyImpl("att1");
        WikittyImpl attach2 = new WikittyImpl("att2");
        treeNodeImpl.addAttachment(new String[]{attach1.getId()});
        treeNodeImpl.addAttachment(new String[]{attach2.getId()});
        ArrayList<WikittyImpl> toStore = new ArrayList<WikittyImpl>();
        toStore.add(attach1);
        toStore.add(attach2);
        toStore.add(treeNode);
        this.wikittyClient.storeWikitty(toStore);
        this.wikittyClient.syncSearchEngine();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"root").end();
        WikittyQueryResult result = this.wikittyClient.findAllByQuery(Wikitty.class, query);
        Assert.assertEquals((long)1L, (long)result.getTotalResult());
        WikittyTreeNodeImpl resultTreeNode = new WikittyTreeNodeImpl((Wikitty)result.get(0));
        Assert.assertEquals((long)2L, (long)resultTreeNode.getAttachment().size());
    }

    @Test
    public void testSolrDeleteDocument() {
        WikittyImpl toDeleteWikitty = new WikittyImpl("wikkitytodelete");
        this.wikittyClient.store((Wikitty)toDeleteWikitty);
        WikittyQuery query = new WikittyQueryMaker().ideq((Object)"wikkitytodelete").end();
        Assert.assertEquals((long)1L, (long)((WikittyQueryResult)this.wikittyClient.findAllByQuery(Collections.singletonList(query)).get(0)).getTotalResult());
        Assert.assertEquals((long)1L, (long)this.wikittyClient.findAllByQuery(query).getTotalResult());
        this.wikittyClient.delete(Collections.singleton(toDeleteWikitty.getId()));
        Assert.assertEquals((long)0L, (long)this.wikittyClient.findAllByQuery(query).getTotalResult());
        Assert.assertEquals((long)0L, (long)((WikittyQueryResult)this.wikittyClient.findAllByQuery(Collections.singletonList(query)).get(0)).getTotalResult());
    }

    @Test
    public void testSolrDeleteMoreThan10Documents() {
        int NB_DOCS_TO_DELETE = 37;
        ArrayList<WikittyLabelImpl> toDelete = new ArrayList<WikittyLabelImpl>();
        for (int i = 0; i < 37; ++i) {
            WikittyLabelImpl toDeleteEntity = new WikittyLabelImpl();
            toDeleteEntity.addLabels(new String[]{"toDeleteEntity" + i});
            toDelete.add(toDeleteEntity);
        }
        this.wikittyClient.store(toDelete);
        WikittyQuery query = new WikittyQueryMaker().exteq("WikittyLabel").end();
        Assert.assertEquals((long)37L, (long)((WikittyQueryResult)this.wikittyClient.findAllByQuery(Collections.singletonList(query)).get(0)).getTotalResult());
        Assert.assertEquals((long)37L, (long)this.wikittyClient.findAllByQuery(query).getTotalResult());
        Assert.assertEquals((long)37L, (long)this.wikittyClient.findAllByQuery(WikittyLabel.class, query).getTotalResult());
        this.wikittyClient.delete(toDelete);
        Assert.assertEquals((long)0L, (long)((WikittyQueryResult)this.wikittyClient.findAllByQuery(Collections.singletonList(query)).get(0)).getTotalResult());
        Assert.assertEquals((long)0L, (long)this.wikittyClient.findAllByQuery(query).getTotalResult());
        Assert.assertEquals((long)0L, (long)this.wikittyClient.findAllByQuery(WikittyLabel.class, query).getTotalResult());
    }

    @Test
    public void testSearchEngineCountAttachment() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"Catalog").end();
        CatalogNode catalogNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"Books").end();
        CatalogNode bookNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"Bande dessin\u00e9es").end();
        CatalogNode bdNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        query = new WikittyQueryMaker().and().exteq("WikittyTreeNode").eq("WikittyTreeNode.name", (Object)"Roman").end();
        CatalogNode romanNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        WikittyQueryResultTreeNode treeNodeResult = this.wikittyClient.findAllIdTreeNode(catalogNode.getWikittyId(), 0, true, null);
        Assert.assertEquals((long)7L, (long)treeNodeResult.getAttCount());
        WikittyQueryResultTreeNode children = this.wikittyClient.findAllIdTreeNode(bookNode.getWikittyId(), 1, true, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Children : " + children));
        }
        Assert.assertEquals((long)3L, (long)children.getChildCount());
        Assert.assertEquals((long)1L, (long)children.getChild((Serializable)((Object)bdNode.getWikittyId())).getAttCount());
        Assert.assertEquals((long)2L, (long)children.getChild((Serializable)((Object)romanNode.getWikittyId())).getAttCount());
    }

    @Test
    public void testSearchEngineCountAttachmentFiltered() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Catalog").end();
        CatalogNode catalogNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        WikittyQuery filter = WikittyQueryParser.parse((String)"Product.category={SELECT id WHERE Category.code = society}");
        WikittyQueryResultTreeNode treeNodeResult = this.wikittyClient.findAllIdTreeNode(catalogNode.getWikittyId(), 0, true, filter);
        Assert.assertEquals((long)1L, (long)treeNodeResult.getAttCount());
    }

    @Test
    public void testSearchEngineCountAttachmentAfterDeletion() {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("Product").eq("Product.name", (Object)"Lanfeust").end();
        String bookId = this.wikittyClient.findByQuery(query);
        this.wikittyClient.delete(bookId);
        query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Catalog").end();
        CatalogNode catalogNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        WikittyQueryResultTreeNode treeNodeResult = this.wikittyClient.findAllIdTreeNode(catalogNode.getWikittyId(), 0, true, null);
        Assert.assertEquals((long)6L, (long)treeNodeResult.getAttCount());
    }

    @Test
    public void testSearchEngineCountAttachmentMultipleSameNode() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        this.importBooks();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Action").end();
        CatalogNode actionNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Everything else").end();
        CatalogNode eeNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        actionNode.addAttachment(new String[]{"db9dc782-e650-4fd4-83ac-3c1c5c136cde"});
        actionNode.addAttachment(new String[]{"584adc1e-726d-4348-9a57-77153d245b34"});
        eeNode.addAttachment(new String[]{"db9dc782-e650-4fd4-83ac-3c1c5c136cde"});
        eeNode.addAttachment(new String[]{"584adc1e-726d-4348-9a57-77153d245b34"});
        this.wikittyClient.store((BusinessEntity)actionNode, (BusinessEntity)eeNode, (BusinessEntity[])new CatalogNode[0]);
        query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Catalog").end();
        CatalogNode catalogNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        WikittyQueryResultTreeNode treeNodeResult = this.wikittyClient.findAllIdTreeNode(catalogNode.getWikittyId(), 0, true, null);
        Assert.assertEquals((long)9L, (long)treeNodeResult.getAttCount());
    }

    @Test
    public void testSearchEngineCountAttachmentNodeMove() throws IOException {
        this.assumeTrueSearchEngineCanRunTest();
        WikittyQuery query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Action").end();
        CatalogNode actionNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Everything else").end();
        CatalogNode eeNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        actionNode.setParent(eeNode.getWikittyId());
        this.wikittyClient.store((BusinessEntity)actionNode);
        query = new WikittyQueryMaker().and().exteq("CatalogNode").eq("WikittyTreeNode.name", (Object)"Media").end();
        CatalogNode mediaNode = (CatalogNode)this.wikittyClient.findAllByQuery(CatalogNode.class, query).peek();
        WikittyQueryResultTreeNode treeNodeResult = this.wikittyClient.findAllIdTreeNode(mediaNode.getWikittyId(), 0, true, null);
        Assert.assertEquals((long)5L, (long)treeNodeResult.getAttCount());
        treeNodeResult = this.wikittyClient.findAllIdTreeNode(eeNode.getWikittyId(), 0, true, null);
        Assert.assertEquals((long)2L, (long)treeNodeResult.getAttCount());
    }
}

