package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WikittyHookAbstract extends BusinessEntityImpl implements WikittyHook {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyHook;

    private static final long serialVersionUID = 3833179448315818341L;

    @Override
    public String getName() {
String value = WikittyHookHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
WikittyHookHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_NAME, oldValue, getName());
}

    @Override
    public Set<String> getActionToHook() {
Set<String> result = WikittyHookHelper.getActionToHook(getWikitty());
return result;
}

    @Override
    public void setActionToHook(Set<String> actionToHook) {
Set<String> oldValue = getActionToHook();
WikittyHookHelper.setActionToHook(getWikitty(), actionToHook);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    @Override
    public void addAllActionToHook(Collection<String> actionToHook) {
Set<String> oldValue = getActionToHook();
WikittyHookHelper.addAllActionToHook(getWikitty(), actionToHook);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    @Override
    public void addActionToHook(String... element) {
Set<String> oldValue = getActionToHook();
WikittyHookHelper.addActionToHook(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    @Override
    public void removeActionToHook(String... element) {
Set<String> oldValue = getActionToHook();
WikittyHookHelper.removeActionToHook(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, oldValue, getActionToHook());
}

    @Override
    public void clearActionToHook() {
WikittyHookHelper.clearActionToHook(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_ACTIONTOHOOK, null, getActionToHook());
}

    @Override
    public String getScript() {
String value = WikittyHookHelper.getScript(getWikitty());
return value;
}

    @Override
    public void setScript(String script) {
String oldValue = getScript();
WikittyHookHelper.setScript(getWikitty(), script);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_SCRIPT, oldValue, getScript());
}

    @Override
    public String getMimetype() {
String value = WikittyHookHelper.getMimetype(getWikitty());
return value;
}

    @Override
    public void setMimetype(String mimetype) {
String oldValue = getMimetype();
WikittyHookHelper.setMimetype(getWikitty(), mimetype);
getPropertyChangeSupport().firePropertyChange(WikittyHook.FIELD_WIKITTYHOOK_MIMETYPE, oldValue, getMimetype());
}

    public WikittyHookAbstract() {
        super();
}

    public WikittyHookAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyHookAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyHook = new WikittyExtension(EXT_WIKITTYHOOK,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\"", 
                                             "String actionToHook[0-*] unique=\"true\"", 
                                             "String script unique=\"true\"", 
                                             "String mimetype unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyHook);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyHookHelper.toString(getWikitty());
}

} //WikittyHookAbstract
