package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;
import org.nuiton.wikitty.query.conditions.ElementField;

public interface ProductEntity extends BusinessEntity {

    String EXT_PRODUCTENTITY = "ProductEntity";

    String FIELD_PRODUCTENTITY_NAME = "name";

    String FQ_FIELD_PRODUCTENTITY_NAME = EXT_PRODUCTENTITY + ".name";

    ElementField ELEMENT_FIELD_PRODUCTENTITY_NAME = new ElementField(FQ_FIELD_PRODUCTENTITY_NAME);

    String FIELD_PRODUCTENTITY_PRICE = "price";

    String FQ_FIELD_PRODUCTENTITY_PRICE = EXT_PRODUCTENTITY + ".price";

    ElementField ELEMENT_FIELD_PRODUCTENTITY_PRICE = new ElementField(FQ_FIELD_PRODUCTENTITY_PRICE);

    String FIELD_PRODUCTENTITY_COLORS = "colors";

    String FQ_FIELD_PRODUCTENTITY_COLORS = EXT_PRODUCTENTITY + ".colors";

    ElementField ELEMENT_FIELD_PRODUCTENTITY_COLORS = new ElementField(FQ_FIELD_PRODUCTENTITY_COLORS);

    String FIELD_PRODUCTENTITY_CATEGORYENTITY = "categoryEntity";

    String FQ_FIELD_PRODUCTENTITY_CATEGORYENTITY = EXT_PRODUCTENTITY + ".categoryEntity";

    ElementField ELEMENT_FIELD_PRODUCTENTITY_CATEGORYENTITY = new ElementField(FQ_FIELD_PRODUCTENTITY_CATEGORYENTITY);

    String getName();

    void setName(String name);

    int getPrice();

    void setPrice(int price);

    Set<String> getColors();

    void setColors(Set<String> colors);

    void addAllColors(Collection<String> colors);

    void addColors(String... element);

    void removeColors(String... element);

    void clearColors();

    String getCategoryEntity();

    void setCategoryEntity(String categoryEntity);

} //ProductEntity
