package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class MineralAbstract extends BusinessEntityImpl implements Mineral {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionMineral;

    public MineralAbstract() {
        super();
}

    public MineralAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public MineralAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionMineral = new WikittyExtension(EXT_MINERAL,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" deprecated=\"true\" documentation=\"Plus utilis\\u00E9 depuis la fin du monde de 2012\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                    ));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionMineral);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return MineralHelper.toString(getWikitty());
}

} //MineralAbstract
