package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WikittyAccessStatAbstract extends BusinessEntityImpl implements WikittyAccessStat {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyAccessStat;

    @Override
    public String getToken() {
String value = WikittyAccessStatHelper.getToken(getWikitty());
return value;
}

    @Override
    public void setToken(String token) {
String oldValue = getToken();
WikittyAccessStatHelper.setToken(getWikitty(), token);
getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_TOKEN, oldValue, getToken());
}

    @Override
    public String getUser() {
String value = WikittyAccessStatHelper.getUser(getWikitty());
return value;
}

    @Override
    public void setUser(String user) {
String oldValue = getUser();
WikittyAccessStatHelper.setUser(getWikitty(), user);
getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_USER, oldValue, getUser());
}

    @Override
    public String getRestored() {
String value = WikittyAccessStatHelper.getRestored(getWikitty());
return value;
}

    @Override
    public void setRestored(String restored) {
String oldValue = getRestored();
WikittyAccessStatHelper.setRestored(getWikitty(), restored);
getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_RESTORED, oldValue, getRestored());
}

    @Override
    public Date getDate() {
Date value = WikittyAccessStatHelper.getDate(getWikitty());
return value;
}

    @Override
    public void setDate(Date date) {
Date oldValue = getDate();
WikittyAccessStatHelper.setDate(getWikitty(), date);
getPropertyChangeSupport().firePropertyChange(WikittyAccessStat.FIELD_WIKITTYACCESSSTAT_DATE, oldValue, getDate());
}

    public WikittyAccessStatAbstract() {
        super();
}

    public WikittyAccessStatAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyAccessStatAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyAccessStat = new WikittyExtension(EXT_WIKITTYACCESSSTAT,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" version=\"1.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Wikitty token unique=\"true\"", 
                                             "Wikitty user unique=\"true\"", 
                                             "Wikitty restored unique=\"true\"", 
                                             "Date date unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyAccessStat);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyAccessStatHelper.toString(getWikitty());
}

} //WikittyAccessStatAbstract
