/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyServiceSecurityTest.java 1136 2011-08-12 14:24:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.2/wikitty-api/src/test/java/org/nuiton/wikitty/layers/WikittyServiceSecurityTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.layers;

import java.util.Collections;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisation;
import org.nuiton.wikitty.entities.WikittyAuthorisationAbstract;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyAuthorisationImpl;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.services.WikittySecurityHelper;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.services.WikittyServiceSecurity;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;

/** test {@link org.nuiton.wikitty.WikittyServiceSecurity}. */
public class WikittyServiceSecurityTest extends AbstractWikittyServiceTest {

    // FIXME 20101112 poussin classe a revoir suite au refactoring de la secu

    private static final Log log = LogFactory.getLog(WikittyServiceSecurityTest.class);

//    protected WikittyServiceSecurity securityService;

    protected String noRightsToken;
    protected String readerToken;
    protected String writerToken;
    protected String adminToken;
    protected String ownerToken;

    @Before
    public void setUpWikittyServiceSecurityTest() {
        ApplicationConfig config = WikittyConfig.getConfig();
        WikittyService inMemoryService = new WikittyServiceInMemory(config);

        WikittyServiceSecurity securityService =
                new WikittyServiceSecurity(config, inMemoryService);

        /** /
        // TODO 20101005 bleny implementation should be able to allow
        // passing trough two security layers
        securityService = new WikittyServiceSecurity(securityService);
        /**/

        setService(securityService);

        // token = service.login(APPADMIN_LOGIN, APPADMIN_PASSWORD);
        token = null;

        WikittyProxy proxy = new WikittyProxy(service);
        proxy.setSecurityToken(token);
        
        WikittyUser anonymous = new WikittyUserImpl();
        anonymous.setLogin("i have no rights");
        anonymous.setPassword("");
        proxy.store(anonymous);

        WikittyUser reader = new WikittyUserImpl();
        reader.setLogin("reader");
        reader.setPassword("");
        proxy.store(reader);

        WikittyUser writer = new WikittyUserImpl();
        writer.setLogin("writer");
        writer.setPassword("");
        proxy.store(writer);

        WikittyUser admin = new WikittyUserImpl();
        admin.setLogin("admin");
        admin.setPassword("");
        proxy.store(admin);

        WikittyUser owner = new WikittyUserImpl();
        owner.setLogin("owner");
        owner.setPassword("");
        owner = proxy.store(owner);

        Wikitty authorizations = WikittySecurityHelper.createExtensionAuthorisation(owner, extension);
        WikittyAuthorisationHelper.addReader(authorizations, reader.getWikittyId());
        WikittyAuthorisationHelper.addWriter(authorizations, writer.getWikittyId());
        WikittyAuthorisationHelper.addAdmin(authorizations, admin.getWikittyId());
        WikittyAuthorisationHelper.setOwner(authorizations, owner.getWikittyId());

        log.debug("initial wikitty rights" + authorizations);

        service.storeExtension(token, Collections.singletonList(extension));
        service.store(token, Collections.singletonList(authorizations), false);


//        Wikitty extensionAuthorisation =
//                WikittySecurityHelper.restoreExtensionAuthorisation(proxy, extension);
//
//        log.debug("restored initial rights " + extensionAuthorisation);

        token = null;

        ownerToken = service.login("owner", "");
        adminToken = service.login("admin", "");
        writerToken = service.login("writer", "");
        readerToken = service.login("reader", "");
        noRightsToken = service.login("i have no rights", "");

        /**/
        WikittyUser root = new WikittyUserImpl();
        root.setLogin("root");
        root.setPassword("");
        proxy.store(root);

        String rootToken = service.login("root", "");
        WikittyGroup appAdmin = WikittySecurityHelper.createAppAdminGroup(root);
        proxy.store(appAdmin);
        /**/
    }

    @Test
    public void testInvalidToken() {
        // try to store with invalid token
        String invalidToken = WikittyUtil.genSecurityTokenId();
        try {
            service.store(invalidToken, getaWikitty());
            fail();
        } catch (SecurityException e) {}

        // now storing the wikitty for next tests
        service.store(readerToken, getaWikitty());

        // try to make operations on the stored wikitty with a bad token
        try {
            service.restore(invalidToken, getaWikitty().getId());
            fail();
        } catch (SecurityException e) {}

        try {
            service.logout(invalidToken);
        } catch (SecurityException e) {
            // log out must be never faild
            fail();
        }

        // now try to make a valid token invalid
        service.logout(readerToken);
        try {
            service.store(readerToken, Collections.singletonList(getaWikitty()), false);
            fail();
        } catch (SecurityException e) {}
    }

    /* *** level 1 security tests ***/

    @Test
    public void testReaderRightOnWikitty() {
        getaWikitty().addExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation);
        WikittyAuthorisation auth = new WikittyAuthorisationImpl(getaWikitty());

        WikittyProxy proxy = new WikittyProxy(service);
        String readerId = WikittySecurityHelper.getUserWikittyId(proxy, "reader");

        auth.clearReader();
        auth.addReader(readerId);

        log.debug("will store wikitty" + getaWikitty());
        service.store(ownerToken, Collections.singletonList(getaWikitty()), false);

        try {
            Wikitty restoredWikitty = service.restore(null, getaWikitty().getId());
            log.debug("restored wikitty is " + restoredWikitty);
            fail("an exception should have been raised");
        } catch (SecurityException e) {
            log.info("raised exception : " + e);
        }
    }

    @Test
    public void testWriterRightOnWikitty() {
        getaWikitty().addExtension(WikittyAuthorisationAbstract.extensionWikittyAuthorisation);
        WikittyAuthorisation auth = new WikittyAuthorisationImpl(getaWikitty());
        service.store(ownerToken, Collections.singletonList(getaWikitty()), false);

        WikittyProxy proxy = new WikittyProxy(service);
        String adminId = WikittySecurityHelper.getUserWikittyId(proxy, "admin");

        auth.clearReader();
        auth.clearWriter();
        auth.clearAdmin();
        auth.addAdmin(adminId);

        log.debug("will store wikitty" + getaWikitty());

        try {
            service.store(writerToken, Collections.singletonList(getaWikitty()), false);
            fail("an exception should have been raised");
        } catch (SecurityException e) {
            log.info("raised exception : " + e);
        }

        Wikitty restoredWikitty = service.restore(null, getaWikitty().getId());
        log.debug("restored wikitty is " + restoredWikitty);
        assertNotNull(restoredWikitty);
    }

    /* *** level 2 security tests ***/

    /** test level 2 reader right */
    @Test
    public void checkReaderRightOnExtension() {

        try {
            service.store(noRightsToken, Collections.singletonList(getaWikitty()), false);
            fail("an exception should have been raised");
        } catch (SecurityException e) {
            log.debug("creating a wikitty without rights", e);
        }

        try {
            service.restoreExtension(noRightsToken, extension.getId());
        } catch (SecurityException e) {
            fail("no exception should have been raised");
        }

        try {
            service.restoreExtensionLastVersion(noRightsToken, extension.getName());
        } catch (SecurityException e) {
            fail("no exception should have been raised");
        }

        try {
            service.store(readerToken, Collections.singletonList(getaWikitty()), false);
            service.restoreExtension(readerToken, extension.getId());
            service.restoreExtensionLastVersion(readerToken, extension.getName());
        } catch (SecurityException e) {
            fail("an exception has been raised");
        }

    }

    @Test
    public void checkWriterRightOnExtension() {

        FieldType fieldType = new FieldType(FieldType.TYPE.STRING, 0, 1);

        service.restoreExtensionLastVersion(writerToken, extension.getName());
        extension.addField("new_field", fieldType);

        try {
            service.storeExtension(readerToken, Collections.singletonList(extension));
            fail("an exception should have been raised");
        } catch (SecurityException e) {}

        try {
            service.storeExtension(writerToken, Collections.singletonList(extension));
        } catch (SecurityException e) {
            fail("an exception has been raised");
        }
    }

    @Test
    public void checkAdminRightOnExtension() {
        // TODO 20100923 bleny check that store with no sufficient rights fail

        WikittyProxy adminProxy = new WikittyProxy(service);
        adminProxy.setSecurityToken(adminToken);
        Wikitty extensionAuthorisation =
                WikittySecurityHelper.restoreExtensionAuthorisation(adminProxy, extension);

        log.debug("initial rights " + extensionAuthorisation);

        // set no reader, ID1 as single writer and ID2 as owner
        WikittyAuthorisationHelper.clearReader(extensionAuthorisation);
        WikittyAuthorisationHelper.clearWriter(extensionAuthorisation);
        WikittyAuthorisationHelper.addWriter(extensionAuthorisation, "ID1");
        WikittyAuthorisationHelper.setOwner(extensionAuthorisation, "ID2");

        // FIXME 20100920 bleny this instruction mekes the test fail by clearing
        // the admin field. There is a side effect on the stored wikitty and restored
        // wikitty in store (oldVersion) has "admin" field empty
        // WikittyAuthorisationHelper.clearAdmin(extensionAuthorisation);

        log.debug("will store rights " + extensionAuthorisation);

        try {
            service.store(writerToken, Collections.singletonList(extensionAuthorisation), false);
            fail("an exception should habe raised");
        } catch (SecurityException e) {}

        service.store(adminToken, Collections.singletonList(extensionAuthorisation), false);

        // now, restore and check that rights are preserved
        extensionAuthorisation =
                WikittySecurityHelper.restoreExtensionAuthorisation(adminProxy, extension);

        log.debug("restored rights " + extensionAuthorisation);

        // check that reader changes has been saved
        assertTrue(WikittyAuthorisationHelper.getReader(extensionAuthorisation).isEmpty());

        // check that ID1 is writer
        assertTrue(WikittyAuthorisationHelper.getWriter(extensionAuthorisation).contains("ID1"));
        // ... and no one else
        assertEquals(1, WikittyAuthorisationHelper.getWriter(extensionAuthorisation).size());

        // check that ID2 is owner
        assertTrue(WikittyAuthorisationHelper.getOwner(extensionAuthorisation).contains("ID2"));

    }
}
