/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: Element.java 1136 2011-08-12 14:24:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.2/wikitty-api/src/main/java/org/nuiton/wikitty/search/operators/Element.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.search.operators;

import java.io.Serializable;

/**
 * Search on field.
 * 
 * @author ruchaud
 */
public class Element implements Serializable {

    /** Represent a element on extension */
    public static String ELT_EXTENSION = "elt_extension";

    /** Represent a element on id */
    public static String ELT_ID = "elt_id";

    /** Represent type to search an element */
    public static enum ElementType {BINARY, NUMERIC, STRING, WIKITTY, BOOLEAN, DATE};

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected String name;

    public Element() {
        super();
    }

    public Element(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
