/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

public abstract class AbstractSearchTest {
    public static final String EXT_PRODUCT = "Product";
    public static final String EXT_CATEGORY = "Category";
    public static final String PRODUCT_PRICE = "price";
    public static final String PRODUCT_NAME = "name";
    public static final String PRODUCT_CATEGORY = "category";
    public static final String CATEGORY_NAME = "name";
    public static final String VERSION = "1.0";
    public static String W_ID = "";
    protected WikittyProxy proxy = new WikittyProxy(this.getWikittyService());

    @Before
    public void initData() {
        WikittyExtension product = ExtensionFactory.create((String)EXT_PRODUCT, (String)VERSION).addField(PRODUCT_PRICE, FieldType.TYPE.NUMERIC).addField("name", FieldType.TYPE.STRING).addField(PRODUCT_CATEGORY, FieldType.TYPE.WIKITTY).extension();
        this.proxy.storeExtension(product);
        WikittyExtension category = ExtensionFactory.create((String)EXT_CATEGORY, (String)VERSION).addField("name", FieldType.TYPE.STRING).extension();
        this.proxy.storeExtension(category);
        WikittyImpl category1 = new WikittyImpl();
        category1.addExtension(category);
        category1.setField(EXT_CATEGORY, "name", (Object)"Hardware");
        this.proxy.store((Wikitty)category1);
        WikittyImpl category2 = new WikittyImpl();
        category2.addExtension(category);
        category2.setField(EXT_CATEGORY, "name", (Object)"Wrong category");
        this.proxy.store((Wikitty)category2);
        WikittyImpl product1 = new WikittyImpl();
        product1.addExtension(product);
        product1.setField(EXT_PRODUCT, "name", (Object)"Paint");
        product1.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)20);
        product1.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category1.getId());
        this.proxy.store((Wikitty)product1);
        WikittyImpl product2 = new WikittyImpl();
        product2.addExtension(product);
        product2.setField(EXT_PRODUCT, "name", (Object)"Screwdriver");
        product2.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)3);
        product2.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        this.proxy.store((Wikitty)product2);
        WikittyImpl product3 = new WikittyImpl();
        product3.addExtension(product);
        product3.setField(EXT_PRODUCT, "name", (Object)"Paint Blue");
        product3.setField(EXT_PRODUCT, PRODUCT_PRICE, (Object)22);
        product3.setField(EXT_PRODUCT, PRODUCT_CATEGORY, (Object)category2.getId());
        this.proxy.store((Wikitty)product3);
        W_ID = product3.getId();
    }

    @Test
    public void testEq() throws Exception {
        Search query = Search.query().eq("Product.price", "3");
        Criteria eqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(eqCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query2 = Search.query().eq("Product.name", "*dri*");
        Criteria eqCriteria2 = query2.criteria();
        PagedResult results2 = this.proxy.findAllByCriteria(eqCriteria2);
        Assert.assertEquals((long)1L, (long)results2.getAll().size());
        Wikitty resultW2 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW2.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW2.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        Search query3 = Search.query().eq("Product.name", "*dri?er");
        Criteria eqCriteria3 = query3.criteria();
        PagedResult results3 = this.proxy.findAllByCriteria(eqCriteria3);
        Assert.assertEquals((long)1L, (long)results3.getAll().size());
        Wikitty resultW3 = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW3.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW3.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNeq() throws Exception {
        Search query = Search.query().neq("Product.price", "3");
        Criteria neqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(neqCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testBw() throws Exception {
        Search query = Search.query().bw("Product.price", "3", "5");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testLt() throws Exception {
        Search query = Search.query().lt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testLe() throws Exception {
        Search query = Search.query().le("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testGt() throws Exception {
        Search query = Search.query().gt("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testGe() throws Exception {
        Search query = Search.query().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testContains() throws Exception {
        Search query = Search.query().contains("Product.price", "3", new String[0]);
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testIn() throws Exception {
        Search query = Search.query().in("Product.price", "1", new String[]{"2", "3", "4", "5"});
        Criteria inCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(inCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testExteq() throws Exception {
        Search query = Search.query().exteq(EXT_PRODUCT);
        Criteria exteqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(exteqCriteria);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testExtneq() throws Exception {
        Search query = Search.query().extneq(EXT_PRODUCT);
        Criteria extneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(extneqCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testIdeq() throws Exception {
        Search query = Search.query().ideq(W_ID);
        Criteria ideqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ideqCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint Blue", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)22L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testIdneq() throws Exception {
        Search query = Search.query().idneq(W_ID);
        Criteria idneqCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(idneqCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Ignore
    @Test
    public void testUnlike() throws Exception {
        Search query = Search.query().unlike("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Ignore
    @Test
    public void testLike() throws Exception {
        Search query = Search.query().like("Product.name", "*dri*");
        Criteria likeCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(likeCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
    }

    @Test
    public void testSw() throws Exception {
        Search query = Search.query().sw("Product.name", "Scre");
        Criteria swCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(swCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNsw() throws Exception {
        Search query = Search.query().nsw("Product.name", "Scre");
        Criteria nswCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(nswCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testEw() throws Exception {
        Search query = Search.query().ew("Product.name", "ver");
        Criteria ewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(ewCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Screwdriver", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)3L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
    }

    @Test
    public void testNotew() throws Exception {
        Search query = Search.query().notew("Product.name", "ver");
        Criteria notewCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(notewCriteria);
        Assert.assertEquals((long)4L, (long)results.getAll().size());
    }

    @Test
    public void testKeyword() throws Exception {
        Search query = Search.query().keyword("Paint");
        Criteria keywordCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(keywordCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testIsNull() throws Exception {
        Search query = Search.query().isNull("Product.name");
        Criteria isNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNull);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testIsNotNull() throws Exception {
        Search query = Search.query().isNotNull("Product.name");
        Criteria isNotNull = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(isNotNull);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testFalse() throws Exception {
        Search query = Search.query().rFalse();
        Criteria rFalse = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rFalse);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testTrue() throws Exception {
        Search query = Search.query().rTrue();
        Criteria rTrue = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(rTrue);
        Assert.assertEquals((long)5L, (long)results.getAll().size());
    }

    @Test
    public void testAnd() throws Exception {
        Search query = Search.query().and().bw("Product.price", "15", "25").sw("Product.name", "Paint");
        Criteria andCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(andCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testOr() throws Exception {
        Search query = Search.query();
        query.or().gt("Product.price", "20").sw("Product.name", "Screw");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)2L, (long)results.getAll().size());
    }

    @Test
    public void testNot() throws Exception {
        Search query = Search.query();
        query.not().ge("Product.price", "20");
        Criteria bwCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(bwCriteria);
        Assert.assertEquals((long)3L, (long)results.getAll().size());
    }

    @Test
    public void testAssociated() throws Exception {
        Search query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "Hardware");
        Criteria associatedCriteria = query.criteria();
        PagedResult results = this.proxy.findAllByCriteria(associatedCriteria);
        Assert.assertEquals((long)1L, (long)results.getAll().size());
        Wikitty resultW = (Wikitty)results.getFirst();
        Assert.assertEquals((Object)"Paint", (Object)resultW.getFieldAsString(EXT_PRODUCT, "name"));
        Assert.assertEquals((long)20L, (long)resultW.getFieldAsInt(EXT_PRODUCT, PRODUCT_PRICE));
        query = Search.query().bw("Product.price", "15", "25").sw("Product.name", "Paint").associated("Product.category").eq("Category.name", "don't return anything");
        associatedCriteria = query.criteria();
        results = this.proxy.findAllByCriteria(associatedCriteria);
        Assert.assertEquals((long)0L, (long)results.getAll().size());
    }

    @Test
    public void testComplexQueries() throws Exception {
    }

    public abstract WikittyService getWikittyService();
}

