/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: ImportExportTest.java 805 2011-04-13 16:59:23Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1/wikitty-api/src/test/java/org/nuiton/wikitty/conform/ImportExportTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.conform;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertNotNull;
import static junit.framework.Assert.assertTrue;
import static junit.framework.Assert.fail;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.Search;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportExportTest extends AbstractTestConformance {

    private static Log log = LogFactory.getLog(ImportExportTest.class);

    protected WikittyImportExportService ieService;

    private ApplicationConfig config = null;

    @Override
    public ApplicationConfig getConfig() {
        if (config == null) {
            config = WikittyConfig.getConfig(); // default config for in memory
//            String msg = "Try to passe test with " + config.getPrintableConfig("wikitty.*", 50);
//            log.info(msg);
        }
        return config;
    }

    @Before
    public void clearStorage() throws Exception {
        getProxy().clear();
    }

    protected WikittyImportExportService getImportExportService() {
        if (ieService == null) {
            ApplicationConfig config = WikittyConfig.getConfig();
            ieService = new WikittyImportExportService(
                    config, null, getWikittyService());
        }
        return ieService;
    }

    @Test
    public void testExport() throws Exception {
        final List<Wikitty> wikitties = createSampleWikitty(getWikittyService());

        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, AbstractTestConformance.EXTNAME).criteria();
        String result = getImportExportService().syncExportAllByCriteria(
                WikittyImportExportService.FORMAT.XML, criteria);
        log.debug("[XML] " + result);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse( new ByteArrayInputStream(result.getBytes()) );

        Node rootNode = document.getChildNodes().item(0);
        // check root node ...
        assertEquals("wikengo", rootNode.getNodeName());

        // check childs ...
        acceptNodeList(rootNode.getChildNodes(), new NodeVisitor() {
            public void visitNode( Node node, Map<String, String> attrs ) {
                String nodeName = node.getNodeName();
                if ( "extension".equals(nodeName) ) {
                    assertEquals( "1.0", attrs.get("version") );
                    assertEquals( "wikittyExt", attrs.get("name") );
                } else if ( "object".equals(nodeName) ) {
                    Wikitty wikitty = null;
                    String id = attrs.get("id");
                    for ( Wikitty w : wikitties ) {
                        if ( w.getId().equals(id) ) {
                            wikitty = w; break;
                        }
                    }
                    assertNotNull( wikitty );
                    assertEquals( "1.0", attrs.get("version") );
                    assertEquals( "wikittyExt[1.0]", attrs.get("extensions") );
                    wikitties.remove( wikitty );
                } else {
                    fail( "Node [" + node.getNodeName() + "] is neither an extension or an object" );
                }

            }
        });

        assertTrue( "some objects were not exported ...", wikitties.isEmpty() );
    }

    interface NodeVisitor {
        public void visitNode( Node node, Map<String, String> attributes );
    }

    private void acceptNodeList( NodeList nodeList, NodeVisitor visitor ) {
        int len = nodeList.getLength();
        Map<String, String> attrs = new HashMap<String, String>();
        for ( int i = 0; i < len; i ++) {
            attrs.clear();
            Node node = nodeList.item(i);
            if ( node.getNodeType() == Node.TEXT_NODE ) continue;
            NamedNodeMap map = node.getAttributes();
            if ( map != null ) {
                int attrLen = map.getLength();
                for( int j = 0; j < attrLen; j++ ) attrs.put(map.item(j).getNodeName(), map.item(j).getNodeValue());
            }
            visitor.visitNode( node, attrs );
        }
    }

    @Test
    public void testImport() throws Exception {
        String xml =
                    "<wikengo>" +
                    "  <extension name='wikittyExt' version='1.0' requires=''>" +
                    "    <field>STRING fieldName0[0-1]</field>" +
                    "    <field>NUMERIC fieldName1[1-1]</field>" +
                    "    <field>DATE fieldName2[1-1]</field>" +
                    "  </extension>" +
                    "  <object id='f4ef949b-09e4-438f-b359-2a4332771c81' version='1.0' extensions='wikittyExt[1.0]'>" +
                    "    <wikittyExt.fieldName0>table</wikittyExt.fieldName0>" +
                    "    <wikittyExt.fieldName1>3300</wikittyExt.fieldName1>" +
                    "    <wikittyExt.fieldName2>1982-01-22T23:00:00.000+0000Z</wikittyExt.fieldName2>" +
                    "  </object>" +
                    "  <object id='7ca86742-5957-4659-b12f-4915cbef9193' version='1.0' extensions='wikittyExt[1.0]'>" +
                    "    <wikittyExt.fieldName0>chaise</wikittyExt.fieldName0>" +
                    "    <wikittyExt.fieldName1>113311</wikittyExt.fieldName1>" +
                    "    <wikittyExt.fieldName2>2009-09-25T22:00:00.000+0000Z</wikittyExt.fieldName2>" +
                    "  </object>" +
                    "  <object id='77d7640c-573d-421c-a7e9-9b70bd025983' version='1.0' extensions='wikittyExt[1.0]'>" +
                    "    <wikittyExt.fieldName0>bureau</wikittyExt.fieldName0>" +
                    "    <wikittyExt.fieldName1>223322</wikittyExt.fieldName1>" +
                    "    <wikittyExt.fieldName2>2029-12-24T23:00:00.000+0000Z</wikittyExt.fieldName2>" +
                    "  </object>" +
                    "</wikengo>";

        getImportExportService().syncImport(WikittyImportExportService.FORMAT.XML, xml);

        String[] ids = new String[] {
                "f4ef949b-09e4-438f-b359-2a4332771c81",
                "7ca86742-5957-4659-b12f-4915cbef9193",
                "77d7640c-573d-421c-a7e9-9b70bd025983"
        };
        List<Wikitty> wikitties = getProxy().restore(Arrays.asList(ids));
        assertEquals(3, wikitties.size());
    }
}
