/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyServiceCachedTest.java 627 2010-12-19 03:21:36Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.3/wikitty-api/src/test/java/org/nuiton/wikitty/layers/WikittyServiceCachedTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.layers;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotSame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.services.WikittyCacheJCS;
import org.nuiton.wikitty.services.WikittyServiceCached;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

/** test {@link WikittyServiceCached} */
public class WikittyServiceCachedTest extends AbstractWikittyServiceTest {

    @Before
    public void setUpWikittyServiceCachedTest() {
        WikittyConfig config = new WikittyConfig();
        setService(new WikittyServiceCached(config,
                new WikittyServiceInMemory(config),
                new WikittyCacheJCS(config)));
        token = service.login(null, null);
        service.store(token, Collections.singletonList(getaWikitty()), false);
    }

    /** setting a field value doesn't corrupt cache */
    @Test
    public void testRestore() throws Exception {
        Wikitty anotherWikitty = service.restore(token, getaWikitty().getId());

        // we set the value of a field
        anotherWikitty.setField(EXT_NAME, FIELD_NAME, "myothervalue");

        // now let's suppose, the user cancel its modification
        // we don't have call store()
        anotherWikitty = service.restore(token, anotherWikitty.getId());

        // the remaining wikitty should hold old value
        assertEquals("myvalue", anotherWikitty.getFieldAsString(EXT_NAME, FIELD_NAME));
    }

    /** same as testRestore() using methods that restore multiple ids */
    @Test
    public void testRestoreMultipleIds() throws Exception {
        // now, let's do the same test, just by using others restore() available
        List<String> idsToRestore = new ArrayList<String>();
        idsToRestore.add(getaWikitty().getId());

        List<Wikitty> otherWikitties = service.restore(token, idsToRestore);
        Wikitty anotherWikitty = otherWikitties.get(0);

        // we set the value of a field
        anotherWikitty.setField(EXT_NAME, FIELD_NAME, "myothervalue");

        // now let's suppose, the user cancel its modification
        // we don't have call store()
        otherWikitties = service.restore(token, idsToRestore);
        anotherWikitty = otherWikitties.get(0);

        // the remaining wikitty should hold old value
        assertEquals("myvalue", anotherWikitty.getFieldAsString(EXT_NAME, FIELD_NAME));
    }

    /** this test is the same but service cache policy is changed */
    @Test
    public void testRestoreAllwaysCopyPolicy() throws Exception {

        WikittyConfig config = new WikittyConfig();
        config.setOption(
                WikittyConfig.WikittyOption.WIKITTY_CACHE_RESTORE_COPIES.getKey(),
                "true");
        
        setService(new WikittyServiceCached(config,
                new WikittyServiceInMemory(config),
                new WikittyCacheJCS(config)));
        token = service.login(null, null);
        service.store(token, Collections.singletonList(getaWikitty()), false);

        // restoring two times the same wikitty should produces two different copies
        Wikitty anotherWikitty = service.restore(token, getaWikitty().getId());
        Wikitty yetAnotherWikitty = service.restore(token, anotherWikitty.getId());

        assertEquals(anotherWikitty, yetAnotherWikitty);
        assertNotSame(anotherWikitty, yetAnotherWikitty); // two different objects
    }

}
