/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.layers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.layers.AbstractWikittyServiceTest;
import org.nuiton.wikitty.services.WikittyCache;
import org.nuiton.wikitty.services.WikittyCacheJCS;
import org.nuiton.wikitty.services.WikittyServiceCached;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

public class WikittyServiceCachedTest
extends AbstractWikittyServiceTest {
    @Before
    public void setUpWikittyServiceCachedTest() {
        WikittyConfig config = new WikittyConfig();
        this.setService((WikittyService)new WikittyServiceCached((ApplicationConfig)config, (WikittyService)new WikittyServiceInMemory((ApplicationConfig)config), (WikittyCache)new WikittyCacheJCS((ApplicationConfig)config)));
        this.token = this.service.login(null, null);
        this.service.store(this.token, Collections.singletonList(this.getaWikitty()), false);
    }

    @Test
    public void testRestore() throws Exception {
        Wikitty anotherWikitty = this.service.restore(this.token, this.getaWikitty().getId());
        anotherWikitty.setField("myextension", "myfield", (Object)"myothervalue");
        anotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString("myextension", "myfield"));
    }

    @Test
    public void testRestoreMultipleIds() throws Exception {
        ArrayList<String> idsToRestore = new ArrayList<String>();
        idsToRestore.add(this.getaWikitty().getId());
        List otherWikitties = this.service.restore(this.token, idsToRestore);
        Wikitty anotherWikitty = (Wikitty)otherWikitties.get(0);
        anotherWikitty.setField("myextension", "myfield", (Object)"myothervalue");
        otherWikitties = this.service.restore(this.token, idsToRestore);
        anotherWikitty = (Wikitty)otherWikitties.get(0);
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString("myextension", "myfield"));
    }

    @Test
    public void testRestoreAllwaysCopyPolicy() throws Exception {
        WikittyConfig config = new WikittyConfig();
        config.setOption(WikittyConfig.WikittyOption.WIKITTY_CACHE_RESTORE_COPIES.getKey(), "true");
        this.setService((WikittyService)new WikittyServiceCached((ApplicationConfig)config, (WikittyService)new WikittyServiceInMemory((ApplicationConfig)config), (WikittyCache)new WikittyCacheJCS((ApplicationConfig)config)));
        this.token = this.service.login(null, null);
        this.service.store(this.token, Collections.singletonList(this.getaWikitty()), false);
        Wikitty anotherWikitty = this.service.restore(this.token, this.getaWikitty().getId());
        Wikitty yetAnotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)anotherWikitty, (Object)yetAnotherWikitty);
        Assert.assertNotSame((Object)anotherWikitty, (Object)yetAnotherWikitty);
    }
}

