/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyLabelUtil;
import org.nuiton.wikitty.conform.AbstractTestConformance;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;

public abstract class StorageTest
extends AbstractTestConformance {
    private static final Log log = LogFactory.getLog(StorageTest.class);

    @Test
    public void testStoreRestoreBasics() throws Exception {
        Wikitty w = StorageTest.createBasicWikitty();
        String id = w.getId();
        w = this.getProxy().store(w);
        w = this.getProxy().restore(id);
        Assert.assertTrue((boolean)w.hasExtension("wikittyExt"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)w.hasField("wikittyExt", "fieldName" + i));
        }
    }

    @Test
    public void testExtensionMethod() throws Exception {
        this.getProxy().storeExtension(EXT_TEST);
        List extIds = this.getProxy().getAllExtensionIds();
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)1L, (long)extIds.size());
        WikittyExtension ext = this.getProxy().restoreExtension((String)extIds.get(0));
        Assert.assertEquals((Object)EXT_TEST.getName(), (Object)ext.getName());
        Assert.assertEquals((Object)EXT_TEST.getVersion(), (Object)ext.getVersion());
        Assert.assertEquals((Object)EXT_TEST, (Object)ext);
        this.getProxy().deleteExtension(EXT_TEST.getName());
        extIds = this.getProxy().getAllExtensionIds();
        Assert.assertEquals((long)0L, (long)extIds.size());
        this.getProxy().storeExtension(EXT_TEST);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w = this.getProxy().store((Wikitty)w);
        try {
            this.getProxy().deleteExtension(EXT_TEST.getName());
            Assert.assertTrue((boolean)false);
        }
        catch (WikittyException eee) {
            Assert.assertTrue((boolean)true);
        }
        List extIds2 = this.getProxy().getAllExtensionIds();
        Assert.assertEquals((long)1L, (long)extIds2.size());
    }

    @Test
    public void testExtensionRequires() throws Exception {
        this.getProxy().storeExtension(Arrays.asList(EXT_REQUIRED, EXT_REQUIRES));
        List extIds = this.getProxy().getAllExtensionsRequires("wikittyRequired");
        log.debug((Object)("extIds: " + extIds));
        Assert.assertEquals((long)1L, (long)extIds.size());
        WikittyExtension ext = this.getProxy().restoreExtension((String)extIds.get(0));
        Assert.assertEquals((Object)EXT_REQUIRES.getName(), (Object)ext.getName());
        Assert.assertEquals((Object)EXT_REQUIRES.getVersion(), (Object)ext.getVersion());
        Assert.assertEquals((Object)EXT_REQUIRES, (Object)ext);
    }

    @Test
    public void testStoreRestoreLists() throws Exception {
        String[] wValues;
        List<Wikitty> wikitties = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        for (String wValue : wValues = new String[]{"fieldName0 = hello,fieldName1 = 123456,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = Bonzai !,fieldName1 = 111111,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = ho ho ho !,fieldName1 = 987654,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
            ids.add(w.getId());
        }
        wikitties = this.getProxy().storeWikitty(wikitties);
        wikitties = this.getProxy().restore(ids);
        int wIndex = 0;
        for (String wValue : wValues) {
            Wikitty w = (Wikitty)wikitties.get(wIndex);
            int i = 0;
            for (Map.Entry<String, String> keyValuePair : StorageTest.getKeyPairs(wValue)) {
                String fieldName = "fieldName" + i;
                Assert.assertEquals((Object)fieldName, (Object)keyValuePair.getKey());
                String errorMsg = "Error check field '" + fieldName + "' on wikitty[" + i + "]";
                switch (i) {
                    case 0: {
                        Assert.assertEquals((String)errorMsg, (Object)keyValuePair.getValue(), (Object)w.getFieldAsString("wikittyExt", fieldName));
                        break;
                    }
                    case 1: {
                        Assert.assertEquals((String)errorMsg, (long)Integer.parseInt(keyValuePair.getValue()), (long)w.getFieldAsInt("wikittyExt", fieldName));
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((String)errorMsg, (Object)WikittyUtil.parseDate((String)keyValuePair.getValue()), (Object)w.getFieldAsDate("wikittyExt", fieldName));
                        break;
                    }
                    default: {
                        Assert.fail((String)("this structure should only get 3 elements, unexpected : " + keyValuePair.getKey()));
                    }
                }
                ++i;
            }
            ++wIndex;
        }
    }

    @Test
    public void testStoreRestoreNullEmpty() throws Exception {
        Wikitty w = null;
        try {
            w = this.getProxy().store(w);
            Assert.fail((String)"store(null) Must throw an exception !");
        }
        catch (Exception e) {
            // empty catch block
        }
        w = new WikittyImpl();
        String id = w.getId();
        w = this.getProxy().store(w);
        w = this.getProxy().restore(id);
        Assert.assertEquals((Object)id, (Object)w.getId());
    }

    @Test
    public void testFieldConstraint() throws Exception {
        WikittyExtension ext = new WikittyExtension("TestConstraint", "1", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String id notNull=true", "String ext[0-n] unique=true", "String other[0-n] unique=true notNull=true"}));
        this.getProxy().storeExtension(ext);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        try {
            w = this.getProxy().store((Wikitty)w);
            Assert.fail((String)"not null contraint don't work on String");
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.setField("TestConstraint", "id", (Object)"toto");
        try {
            w = this.getProxy().store((Wikitty)w);
            Assert.fail((String)"not null contraint don't work in Collection");
        }
        catch (WikittyException eee) {
            eee.printStackTrace();
        }
        w.addToField("TestConstraint", "other", (Object)"titi");
        w = this.getProxy().store((Wikitty)w);
        w.addToField("TestConstraint", "ext", (Object)"tata");
        w.addToField("TestConstraint", "ext", (Object)"titi");
        w = this.getProxy().store((Wikitty)w);
        Wikitty w2 = this.getProxy().restore(w.getId());
        w2.addToField("TestConstraint", "ext", (Object)"tata");
        w2.addToField("TestConstraint", "ext", (Object)"toto");
        w2 = this.getProxy().store(w2);
        Wikitty w3 = this.getProxy().restore(w.getId());
        HashSet<String> set = new HashSet<String>(Arrays.asList("tata", "titi", "toto"));
        Assert.assertEquals(set, (Object)w3.getFieldAsSet("TestConstraint", "ext", String.class));
    }

    @Test
    public void testStoreFindAll() throws Exception {
        String[] wValues;
        List<Wikitty> wikitties = new ArrayList();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003309,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 003309,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        wikitties = this.getProxy().storeWikitty(wikitties);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"003309");
        Criteria criteria = Search.query((Wikitty)w).criteria().addSortDescending(EXT_TEST.getName() + ".fieldName0");
        PagedResult resultFind = this.getProxy().findAllIdByCriteria(criteria);
        Assert.assertEquals((long)2L, (long)resultFind.size());
        List wikittyFind = this.getProxy().restore(resultFind.getAll());
        Assert.assertEquals(wikitties.subList(0, 2), (Object)wikittyFind);
    }

    @Test
    public void testStoreFindAllFacet() throws Exception {
        String[] wValues;
        List<Wikitty> wikitties = new ArrayList();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 663300,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaise,fieldName1 = 663300,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223322,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        wikitties = this.getProxy().storeWikitty(wikitties);
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName1", (Object)"663300");
        Criteria criteria = Search.query((Wikitty)w).criteria().setFirstIndex(0).setEndIndex(-1).addFacetField(EXT_TEST.getName() + ".fieldName0").addFacetField(EXT_TEST.getName() + ".fieldName1");
        PagedResult resultFind = this.getProxy().findAllIdByCriteria(criteria);
        ArrayList facetNames = new ArrayList(resultFind.getFacetNames());
        Collections.sort(facetNames);
        Assert.assertEquals(Arrays.asList(EXT_TEST.getName() + ".fieldName0", EXT_TEST.getName() + ".fieldName1"), facetNames);
        Assert.assertEquals((long)2L, (long)resultFind.getTopic(EXT_TEST.getName() + ".fieldName0").size());
        Assert.assertEquals((long)1L, (long)resultFind.getTopic(EXT_TEST.getName() + ".fieldName1").size());
        criteria = Search.query().keyword("*").criteria().setFirstIndex(0).setEndIndex(0).addFacetField(Element.ELT_EXTENSION);
        resultFind = this.getProxy().findAllIdByCriteria(criteria);
        Assert.assertEquals((long)1L, (long)resultFind.getFacetNames().size());
        Assert.assertNotNull(resultFind.getFacets().get(Element.ELT_EXTENSION));
    }

    @Test
    public void testStoreFindDelete() throws Exception {
        String[] wValues;
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String wValue : wValues = new String[]{"fieldName0 = table,fieldName1 = 003301,fieldName2 = " + StorageTest.format("23/01/1982"), "fieldName0 = chaiseICI,fieldName1 = 113312,fieldName2 = " + StorageTest.format("26/09/2009"), "fieldName0 = bureau,fieldName1 = 223323,fieldName2 = " + StorageTest.format("25/12/2029")}) {
            Wikitty w = StorageTest.createWikitty(wValue, "wikittyExt", EXT_TEST);
            wikitties.add(w);
        }
        HashMap<String, String> oldIdVersion = new HashMap<String, String>();
        for (Wikitty w : wikitties) {
            oldIdVersion.put(w.getId(), w.getVersion());
        }
        WikittyEvent response = this.getWikittyService().store(null, wikitties, false);
        for (Wikitty w : wikitties) {
            response.update(w);
            String v1 = w.getVersion();
            String v2 = (String)oldIdVersion.get(w.getId());
            Assert.assertNotNull((Object)v1);
            Assert.assertNotNull((Object)v2);
            Assert.assertTrue((boolean)WikittyUtil.versionGreaterThan((String)v1, (String)v2));
        }
        WikittyImpl w = new WikittyImpl();
        w.addExtension(EXT_TEST);
        w.setField(EXT_TEST.getName(), "fieldName0", (Object)"chaiseICI");
        Criteria criteria = Search.query((Wikitty)w).criteria();
        Wikitty resultFind = this.getProxy().findByCriteria(criteria);
        Wikitty wikittySource = (Wikitty)wikitties.get(1);
        Assert.assertEquals((Object)w.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        Assert.assertEquals((Object)wikittySource.getId(), (Object)resultFind.getId());
        Assert.assertEquals((Object)wikittySource, (Object)resultFind);
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName0"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName0"));
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName1"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName1"));
        Assert.assertEquals((Object)wikittySource.getFieldAsString(EXT_TEST.getName(), "fieldName2"), (Object)resultFind.getFieldAsString(EXT_TEST.getName(), "fieldName2"));
        Criteria criteria1 = Search.query().eq(Element.ELT_ID, wikittySource.getId()).criteria();
        Wikitty searchedWikitty1 = this.getProxy().findByCriteria(criteria1);
        Assert.assertNotNull((Object)searchedWikitty1);
        this.getProxy().delete(wikittySource.getId());
        Wikitty deletedObject = this.getProxy().restore(wikittySource.getId());
        Assert.assertNull((Object)deletedObject);
        Criteria criteria2 = Search.query().eq(Element.ELT_ID, wikittySource.getId()).criteria();
        Wikitty searchedWikitty2 = this.getProxy().findByCriteria(criteria2);
        Assert.assertNull((Object)searchedWikitty2);
    }

    @Test
    public void testStoreAndLabel() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.getWikittyService());
        long ts = new Date().getTime();
        Wikitty w1 = (Wikitty)wikitties.get(0);
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w1.getId(), (String)("titi" + ts));
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w1.getId(), (String)("toto" + ts));
        Wikitty w2 = (Wikitty)wikitties.get(1);
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w2.getId(), (String)("tata" + ts));
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w2.getId(), (String)("titi" + ts));
        Wikitty w3 = (Wikitty)wikitties.get(2);
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w3.getId(), (String)("tutu" + ts));
        WikittyLabelUtil.addLabel((WikittyProxy)this.getProxy(), (String)w3.getId(), (String)("titi" + ts));
        Wikitty wt = WikittyLabelUtil.findByLabel((WikittyProxy)this.getProxy(), (String)("toto" + ts));
        Assert.assertEquals((Object)w1, (Object)wt);
        Set labels = WikittyLabelUtil.findAllAppliedLabels((WikittyProxy)this.getProxy(), (String)w2.getId());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("tata" + ts, "titi" + ts)), (Object)labels);
    }

    @Test
    public void testStoreAndClassification() throws Exception {
        ArrayList<Wikitty> wikitties = StorageTest.createSampleWikitty(this.getWikittyService());
        List<Wikitty> wikittyNodes = new ArrayList<Wikitty>();
        WikittyTreeNodeImpl root = new WikittyTreeNodeImpl();
        wikittyNodes.add(root.getWikitty());
        root.setName("MyCategoryRoot");
        for (int i = 0; i < 3; ++i) {
            WikittyTreeNodeImpl leaf = new WikittyTreeNodeImpl();
            wikittyNodes.add(leaf.getWikitty());
            leaf.setName("cat-" + i);
            leaf.setParent(root.getWikittyId());
            for (int j = 0; j < 5; ++j) {
                WikittyTreeNodeImpl subLeaf = new WikittyTreeNodeImpl();
                subLeaf.setName("subcat-" + i + "-" + j);
                subLeaf.setParent(leaf.getWikittyId());
                wikittyNodes.add(subLeaf.getWikitty());
            }
        }
        wikittyNodes = this.getProxy().storeWikitty(wikittyNodes);
        Wikitty table = (Wikitty)wikitties.get(0);
        Wikitty chaise = (Wikitty)wikitties.get(1);
        Wikitty bureau = (Wikitty)wikitties.get(2);
        this.assign(chaise, root, "cat-1/subcat-1-4");
        this.assign(table, root, "cat-1");
        this.assign(bureau, root, "cat-2/subcat-2-4");
        WikittyTree t = this.getProxy().restoreTree(root.getWikitty().getId());
        t.getName().equals("MyCategoryRoot");
    }

    protected void assign(Wikitty wikitty, WikittyTreeNodeImpl root, String path) {
        String[] nodeNames = path.split("/");
        WikittyTreeNodeImpl currentNode = root;
        block0: for (String nodeName : nodeNames) {
            WikittyTreeNodeImpl node = new WikittyTreeNodeImpl();
            node.setName(nodeName);
            Criteria criteria = Search.query((Wikitty)node.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
            List wikittiesId = this.getProxy().findAllIdByCriteria(criteria).getAll();
            List wikitties = this.getProxy().restore(wikittiesId);
            for (Wikitty child : wikitties) {
                if (!child.hasExtension("WikittyTreeNode") || !(node = new WikittyTreeNodeImpl(child)).getName().equals(nodeName)) continue;
                currentNode = node;
                continue block0;
            }
            Assert.fail((String)("Unable to find node " + nodeName + " inside " + currentNode.getName()));
        }
        currentNode.addAttachment(wikitty.getId());
        this.getProxy().store(currentNode.getWikitty());
    }

    @Test
    public void testWikittyUtilNewInstanceWithWikitty() {
        WikittyImpl w = new WikittyImpl();
        w.addExtension(WikittyTreeNodeImpl.extensions);
        WikittyTreeNode treeNode = (WikittyTreeNode)WikittyUtil.newInstance(null, (WikittyService)this.getWikittyService(), WikittyTreeNode.class, (Wikitty)w);
        Assert.assertNotNull((Object)treeNode);
    }

    @Test
    public void testCast() {
        WikittyTreeNodeImpl node = new WikittyTreeNodeImpl();
        node.setName("nodeName");
        WikittyLabel label = (WikittyLabel)this.getProxy().cast((BusinessEntity)node, WikittyLabel.class);
        label.addLabels("toto");
        label = (WikittyLabel)this.getProxy().store((BusinessEntity)label);
        String wikittyId = label.getWikittyId();
        WikittyTreeNode node2 = (WikittyTreeNode)this.getProxy().restore(WikittyTreeNode.class, wikittyId);
        Assert.assertEquals((Object)"nodeName", (Object)node2.getName());
        WikittyLabel label2 = (WikittyLabel)this.getProxy().cast((BusinessEntity)node, WikittyLabel.class);
        ArrayList labels = new ArrayList(label2.getLabels());
        Assert.assertFalse((boolean)labels.isEmpty());
        Assert.assertEquals((Object)"toto", labels.get(0));
    }

    @Test
    public void testStorageVersionForce() {
        WikittyImpl myNewWikitty;
        WikittyImpl myWikitty;
        block2: {
            myWikitty = new WikittyImpl();
            myWikitty.addExtension(WikittyTreeNodeImpl.extensions);
            WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"name");
            myWikitty = this.getProxy().store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"1.0", (Object)myWikitty.getVersion());
            myWikitty = this.getProxy().store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"1.0", (Object)myWikitty.getVersion());
            WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"new name");
            myWikitty = this.getProxy().store((Wikitty)myWikitty);
            Assert.assertEquals((Object)"2.0", (Object)myWikitty.getVersion());
            myNewWikitty = new WikittyImpl(myWikitty.getId());
            myNewWikitty.addExtension(WikittyTreeNodeImpl.extensions);
            WikittyTreeNodeHelper.setName((Wikitty)myNewWikitty, (String)"new wikitty");
            try {
                myWikitty = this.getProxy().store((Wikitty)myNewWikitty);
                Assert.fail((String)"Test must throw WikittyObsoleteException");
            }
            catch (WikittyObsoleteException ex) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Wikitty obsolete", (Throwable)ex);
            }
        }
        WikittyEvent event = this.getWikittyService().store(null, Collections.singletonList(myWikitty), true);
        event.update((Wikitty)myWikitty);
        Assert.assertEquals((Object)"3.0", (Object)myWikitty.getVersion());
        myNewWikitty.setVersion("11.0");
        event = this.getWikittyService().store(null, Collections.singletonList(myNewWikitty), true);
        event.update((Wikitty)myNewWikitty);
        Assert.assertEquals((Object)"11.0", (Object)myNewWikitty.getVersion());
    }

    @Test
    public void testStoragePreviouslyDeleted() {
        WikittyImpl myWikitty = new WikittyImpl();
        myWikitty.addExtension(WikittyTreeNodeImpl.extensions);
        WikittyTreeNodeHelper.setName((Wikitty)myWikitty, (String)"name");
        myWikitty = this.getProxy().store((Wikitty)myWikitty);
        this.getProxy().delete(myWikitty.getId());
        Wikitty restoredWikitty = this.getProxy().restore(myWikitty.getId());
        Assert.assertNull((Object)restoredWikitty);
        myWikitty = this.getProxy().store((Wikitty)myWikitty);
        restoredWikitty = this.getProxy().restore(myWikitty.getId());
        Assert.assertNotNull((Object)restoredWikitty);
    }

    @Test
    public void testBinaryFieldStorage() {
        String extName = "BinaryExt";
        byte[] bytes = "Coucou le monde".getBytes();
        WikittyExtension BinaryExt = new WikittyExtension(extName, "1.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name unique=\"true\"", "Binary content"}));
        WikittyImpl w = new WikittyImpl();
        w.addExtension(BinaryExt);
        w.setField(extName, "name", (Object)"LeBin");
        w.setField(extName, "content", (Object)bytes);
        w = this.getProxy().store((Wikitty)w);
        Wikitty restoredWikitty = this.getProxy().restore(w.getId());
        Assert.assertNotNull((Object)restoredWikitty);
        Assert.assertEquals((Object)"LeBin", (Object)restoredWikitty.getFieldAsString(extName, "name"));
        Assert.assertEquals((Object)bytes, (Object)restoredWikitty.getFieldAsBytes(extName, "content"));
    }

    @Test
    public void testStoreUnmodifiedEntity() {
        WikittyLabelImpl wikitty1 = new WikittyLabelImpl();
        WikittyLabelImpl wikitty2 = new WikittyLabelImpl();
        ArrayList toStore = new ArrayList();
        Collections.addAll(toStore, wikitty1, wikitty2);
        List stored = this.getProxy().store(toStore);
        ((WikittyLabel)stored.get(0)).addLabels("lbl");
        try {
            this.getProxy().store(toStore);
        }
        catch (Exception eee) {
            Assert.fail();
        }
    }
}

