/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.api.AbstractTestApi;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class ExtensionFactoryTest
extends AbstractTestApi {
    @Test
    public void testExtensionFactory() throws Exception {
        WikittyExtension ext = ExtensionFactory.create((String)"testExtension", (String)"1.0").addField("name", FieldType.TYPE.STRING).notNull().addField("phoneNumbers", FieldType.TYPE.STRING).minOccur(2).maxOccur(10).addField("matricule", FieldType.TYPE.NUMERIC).unique().addField("fired", FieldType.TYPE.BOOLEAN).extension();
        Assert.assertEquals((Object)"testExtension", (Object)ext.getName());
        Assert.assertEquals((Object)"1.0", (Object)ext.getVersion());
        this.checkField(ext, "name", FieldType.TYPE.STRING, 0, 1, false, true);
        this.checkField(ext, "phoneNumbers", FieldType.TYPE.STRING, 2, 10, false, false);
        this.checkField(ext, "matricule", FieldType.TYPE.NUMERIC, 0, 1, true, false);
        this.checkField(ext, "fired", FieldType.TYPE.BOOLEAN, 0, 1, false, false);
    }

    private void checkField(WikittyExtension ext, String fieldName, FieldType.TYPE type, int min, int max, boolean unique, boolean notNull) {
        FieldType fieldType = ext.getFieldType(fieldName);
        String str = "Checking " + ext.getName() + "." + fieldName + " field...";
        Assert.assertNotNull((String)str, (Object)fieldType);
        Assert.assertEquals((String)str, (Object)type, (Object)fieldType.getType());
        Assert.assertEquals((String)str, (long)min, (long)fieldType.getLowerBound());
        Assert.assertEquals((String)str, (long)max, (long)fieldType.getUpperBound());
        Assert.assertEquals((String)str, (Object)unique, (Object)fieldType.isUnique());
        Assert.assertEquals((String)str, (Object)notNull, (Object)fieldType.isNotNull());
    }
}

