/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittySearchEngine.java 619 2010-12-17 16:33:52Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.2/wikitty-api/src/main/java/org/nuiton/wikitty/storage/WikittySearchEngine.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.wikitty.storage;

import java.util.Collection;
import java.util.Map;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.services.WikittyTransaction;

/**
 * WikittySearchEngine is used to abstract search engine used in WikittyService.
 *
 *
 * @author poussin
 * @version $Revision: 619 $
 *
 * Last update: $Date: 2010-12-17 17:33:52 +0100 (ven., 17 déc. 2010) $
 * by : $Author: bpoussin $
 */
public interface WikittySearchEngine {

    /**
     * Remove all data in index
     */
    public void clear(WikittyTransaction transaction);

    /**
     * Store wikitty in storage
     * Tree are reindexed if necessary.
     */
    public void store(WikittyTransaction transaction,
            Collection<Wikitty> wikitties);

    /**
     * Delete all object with idList argument. If id is not valid or don't exist.
     * Tree are reindexed if necessary.
     * 
     * @param idList list of ids to delete
     * @throws WikittyException
     */
    public void delete(WikittyTransaction transaction,
            Collection<String> idList) throws WikittyException;

    // NOTE poussin 20101216 i don't know why this method exists, i suppress it
//    /**
//     * Delete all object with idList argument. idList is directly passed to search engine
//     * and is processed without any other kind of treatment.
//     *
//     * @param idList list of ids to delete
//     * @throws WikittyException
//     */
//    public void delete(Collection<String> idList) throws WikittyException;
    
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria);

    /**
     * Find count of child for a node
     * @param w
     * @return
     */
    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

    /**
     * Find all children ids with attachment count for a node wikitty.
     * If same attachment found many time in subtree this attachment is count
     * only once.
     *
     * If we have:
     * <ul>
     *  <li> w Node (4)
     *   <ul>
     *     <li> child1 (3) </li>
     *     <li> child2 (4) </li>
     *     <li> child3 (2)
     *      <ul>
     *       <li> subchild1 (1) </li>
     *       <li> subchild2 (5) </li>
     *     </ul>
     *     </li>
     *     <li> child4 (3) </li>
     *     <li> child5 (7) </li>
     *   </ul>
     *  </li>
     * </ul>
     *
     * return count for: child1(3), child2(4), child3(8), child4(3), child5(7)
     * and for the child3 count we have count of subchild1 and subchild2 in
     *
     * but Node and subchild are not returned. This method return only one level
     * of tree
     *
     * @param w
     * @return
     */
    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter);

}
