package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public interface WikittyAuthorisation extends BusinessEntity {     String EXT_WIKITTYAUTHORISATION = "WikittyAuthorisation";
     String FIELD_WIKITTYAUTHORISATION_OWNER = "Owner";
     String FQ_FIELD_WIKITTYAUTHORISATION_OWNER = EXT_WIKITTYAUTHORISATION + ".Owner";
     String FIELD_WIKITTYAUTHORISATION_ADMIN = "Admin";
     String FQ_FIELD_WIKITTYAUTHORISATION_ADMIN = EXT_WIKITTYAUTHORISATION + ".Admin";
     String FIELD_WIKITTYAUTHORISATION_WRITER = "Writer";
     String FQ_FIELD_WIKITTYAUTHORISATION_WRITER = EXT_WIKITTYAUTHORISATION + ".Writer";
     String FIELD_WIKITTYAUTHORISATION_READER = "Reader";
     String FQ_FIELD_WIKITTYAUTHORISATION_READER = EXT_WIKITTYAUTHORISATION + ".Reader";
     String FIELD_WIKITTYAUTHORISATION_PARENT = "parent";
     String FQ_FIELD_WIKITTYAUTHORISATION_PARENT = EXT_WIKITTYAUTHORISATION + ".parent";
    /**
     * getOwner :
     * @return String 
     */

     String getOwner();

    /**
     * setOwner :
     * @param Owner 
     */

     void setOwner(String Owner);

    /**
     * getAdmin :
     * @return Set<String> 
     */

     Set<String> getAdmin();

    /**
     * addAdmin :
     * @param element 
     */

     void addAdmin(String element);

    /**
     * removeAdmin :
     * @param element 
     */

     void removeAdmin(String element);

    /**
     * clearAdmin :
     */

     void clearAdmin();

    /**
     * getWriter :
     * @return Set<String> 
     */

     Set<String> getWriter();

    /**
     * addWriter :
     * @param element 
     */

     void addWriter(String element);

    /**
     * removeWriter :
     * @param element 
     */

     void removeWriter(String element);

    /**
     * clearWriter :
     */

     void clearWriter();

    /**
     * getReader :
     * @return Set<String> 
     */

     Set<String> getReader();

    /**
     * addReader :
     * @param element 
     */

     void addReader(String element);

    /**
     * removeReader :
     * @param element 
     */

     void removeReader(String element);

    /**
     * clearReader :
     */

     void clearReader();

    /**
     * getParent :
     * Pointe sur un autre WikittyAuthorisation qui permet d'indiquer que les droits de l'objet courant sont les mêmes que l'objet pointée. Les droits de l'objet courant s'ajoute au droit de l'objet pointé
     * @return String 
     */

     String getParent();

    /**
     * setParent :
     * @param parent 
     */

     void setParent(String parent);

    /**
     * addMetaExtension :
     * add WikittyAuthorisation meta-extension on given extension to this entity
     * @param extension 
     */

     void addMetaExtension(WikittyExtension extension);


} //WikittyAuthorisation
