package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class TreeNodeAbstract extends BusinessEntityWikitty implements TreeNode {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionTreeNode;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = TreeNodeHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        TreeNodeHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_NAME, oldValue, getName());
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAttachment() {
        Set<String> result = TreeNodeHelper.getAttachment(getWikitty());
        return result;
}

    /**
     * addAttachment :
     * @param element 
     */

    @Override
    public void addAttachment(String element) {
        TreeNodeHelper.addAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * removeAttachment :
     * @param element 
     */

    @Override
    public void removeAttachment(String element) {
        TreeNodeHelper.removeAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * clearAttachment :
     */

    @Override
    public void clearAttachment() {
        TreeNodeHelper.clearAttachment(getWikitty());
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * getParent :
     * @return String 
     */

    @Override
    public String getParent() {
        String value = TreeNodeHelper.getParent(getWikitty());
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    @Override
    public void setParent(String parent) {
        String oldValue = getParent();
        TreeNodeHelper.setParent(getWikitty(), parent);
        getPropertyChangeSupport().firePropertyChange(TreeNode.FIELD_TREENODE_PARENT, oldValue, getParent());
}

    /**
     * TreeNodeAbstract :
     */

    public TreeNodeAbstract() {
        super();
}

    /**
     * TreeNodeAbstract :
     * @param wikitty 
     */

    public TreeNodeAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * TreeNodeAbstract :
     * @param businessEntityWikitty 
     */

    public TreeNodeAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionTreeNode =
                new WikittyExtension(EXT_TREENODE,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=true", 
                                             "Wikitty attachment[0-*] unique=true", 
                                             "Wikitty parent unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionTreeNode);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //TreeNodeAbstract
