/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.notification;

import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.junit.Test;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.XMPPNotifierTransporter;

public class XMPPNotificationTest {
    private static Log log = LogFactory.getLog(XMPPNotificationTest.class);

    @Test
    public void testXMPP() throws Exception {
        String server = "im.codelutin.com";
        String room = "test@conference.im.codelutin.com";
        Properties props = new Properties();
        props.setProperty("wikitty.xmpp.server", server);
        props.setProperty("wikitty.xmpp.room", room);
        XMPPNotifierTransporter xmpp = new XMPPNotifierTransporter(null, props);
        WikittyServiceEvent event = new WikittyServiceEvent((Object)"test", WikittyServiceEvent.WikittyEventType.PUT_WIKITTY);
        HashSet<String> ids = new HashSet<String>();
        ids.add("id1");
        ids.add("id2");
        ids.add("id3");
        event.setIds(ids);
        xmpp.sendMessage(event);
        XMPPConnection connection = new XMPPConnection(server);
        connection.connect();
        connection.loginAnonymously();
        MultiUserChat muc = new MultiUserChat(connection, room);
        String pseudo = XMPPNotifierTransporter.getUniqueLoginName();
        System.out.println("pseudo: " + pseudo);
        DiscussionHistory history = new DiscussionHistory();
        history.setMaxStanzas(1);
        muc.join(pseudo, "", history, 4000L);
        muc.addMessageListener(new PacketListener(){

            public void processPacket(Packet packet) {
                System.out.println("ext: " + packet.getExtensions());
                System.out.println("prop: " + packet.getPropertyNames());
                Object event = packet.getProperty("wikitty-event");
                System.out.println("event " + event + " PACKET: " + " xml: " + packet.toXML());
            }
        });
    }
}

