/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.layers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceInMemory;
import org.nuiton.wikitty.layers.AbstractWikittyServiceTest;

public class WikittyServiceCachedTest
extends AbstractWikittyServiceTest {
    @Before
    public void setUpWikittyServiceCachedTest() {
        this.service = new WikittyServiceCached((WikittyService)new WikittyServiceInMemory());
        this.token = this.service.login(null, null);
        this.service.store(this.token, this.aWikitty);
    }

    @Test
    public void testRestore() throws Exception {
        Wikitty anotherWikitty = this.service.restore(this.token, this.aWikitty.getId());
        anotherWikitty.setField("myextension", "myfield", (Object)"myothervalue");
        anotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString("myextension", "myfield"));
    }

    @Test
    public void testRestoreMultipleIds() throws Exception {
        ArrayList<String> idsToRestore = new ArrayList<String>();
        idsToRestore.add(this.aWikitty.getId());
        List otherWikitties = this.service.restore(this.token, idsToRestore);
        Wikitty anotherWikitty = (Wikitty)otherWikitties.get(0);
        anotherWikitty.setField("myextension", "myfield", (Object)"myothervalue");
        otherWikitties = this.service.restore(this.token, idsToRestore);
        anotherWikitty = (Wikitty)otherWikitties.get(0);
        Assert.assertEquals((Object)"myvalue", (Object)anotherWikitty.getFieldAsString("myextension", "myfield"));
    }

    @Test
    public void testRestoreAllwaysCopyPolicy() throws Exception {
        Properties props = new Properties();
        props.setProperty("wikitty.service.cache.allwaysRestoreCopies", "true");
        this.service = new WikittyServiceCached((WikittyService)new WikittyServiceInMemory(), props);
        this.token = this.service.login(null, null);
        this.service.store(this.token, this.aWikitty);
        Wikitty anotherWikitty = this.service.restore(this.token, this.aWikitty.getId());
        Wikitty yetAnotherWikitty = this.service.restore(this.token, anotherWikitty.getId());
        Assert.assertEquals((Object)anotherWikitty, (Object)yetAnotherWikitty);
        Assert.assertNotSame((Object)anotherWikitty, (Object)yetAnotherWikitty);
    }
}

