/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.importexport;

import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Class used for import process, this class retain numberForCommit object
 * before to send it to storage.
 */
public class WikittyBatchUpdate {

    // TODO poussin 20090902 do configurable numberForCommit
    protected int numberForCommit = 1000;
    protected int currentAdded = 0;
    protected Map<String, WikittyExtension> exts = new HashMap<String, WikittyExtension>();
    protected List<Wikitty> wikitties = new LinkedList<Wikitty>();
    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected String securityToken;

    public WikittyBatchUpdate(String securityToken,
            WikittyService ws, WikittyTransaction transaction) {
        super();
        this.securityToken = securityToken;
        this.ws = ws;
        this.transaction = transaction;
    }

    public void addExtension(WikittyExtension ext) {
        exts.put(ext.getId(), ext);
        inc();
    }

    public void addWikitty(Wikitty w) {
        wikitties.add(w);
        inc();
    }

    /**
     * search extension in local extension list and if missed restore
     * extension from internal WikittyService
     * @param id
     * @return extension
     */
    public WikittyExtension getExtension(String id) {
        WikittyExtension result = exts.get(id);
        if (result == null) {
            result = ws.restoreExtension(securityToken, transaction, id);
        }
        return result;
    }

    public void flush() {
        ws.storeExtension(securityToken, transaction, exts.values());
        ws.store(securityToken, transaction, wikitties, true);
        exts.clear();
        wikitties.clear();
        currentAdded = 0;
    }

    protected void inc() {
        currentAdded++;
        if (currentAdded >= numberForCommit) {
            flush();
        }
    }
}
