/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class WikittyI18nHelper {

    /**
     * WikittyI18nHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyI18nHelper() {// empty
}

    /**
     * getTranslatableValues :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getTranslatableValues(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, String.class);
        return result;
}

    /**
     * addTranslatableValues :
     * @param wikitty 
     * @param element 
     */

    public static void addTranslatableValues(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, element);
}

    /**
     * removeTranslatableValues :
     * @param wikitty 
     * @param element 
     */

    public static void removeTranslatableValues(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, element);
}

    /**
     * clearTranslatableValues :
     * @param wikitty 
     */

    public static void clearTranslatableValues(Wikitty wikitty) {
        wikitty.clearField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
}

    /**
     * getLang :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getLang(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, String.class);
        return result;
}

    /**
     * addLang :
     * @param wikitty 
     * @param element 
     */

    public static void addLang(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, element);
}

    /**
     * removeLang :
     * @param wikitty 
     * @param element 
     */

    public static void removeLang(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, element);
}

    /**
     * clearLang :
     * @param wikitty 
     */

    public static void clearLang(Wikitty wikitty) {
        wikitty.clearField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
}

    /**
     * getTranslations :
     * @param wikitty 
     * @return String 
     */

    public static String getTranslations(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
        return value;
}

    /**
     * setTranslations :
     * @param wikitty 
     * @param translations 
     * @return String 
     */

    public static String setTranslations(Wikitty wikitty, String translations) {
        String oldValue = getTranslations(wikitty);
        wikitty.setField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS, translations);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyI18n.EXT_WIKITTYI18N);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyI18nAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * addMetaExtension :
     * add WikittyI18n meta-extension on given extension to the given wikitty
     * @param extension 
     * @param wikitty 
     */

    public static void addMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        wikitty.addMetaExtension(WikittyI18nAbstract.extensionWikittyI18n, extension);
}

    /**
     * hasMetaExtension :
     * true if given wikitty has WikittyI18n meta-extension on given extension
     * @param extension 
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        return wikitty.hasMetaExtension(WikittyI18n.EXT_WIKITTYI18N, extension.getName());
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyI18n.f'
     * @param extension 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(WikittyExtension extension, String fieldName) {
        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); 
        return metaFieldName;
}

    /**
     * getMetaFieldName :
     * for extension 'Ext' and field 'f', return 'Ext:WikittyI18n.f'
     * @param extensionName 
     * @param fieldName 
     * @return String 
     */

    public static String getMetaFieldName(String extensionName, String fieldName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyI18n", extensionName, fieldName);
        return metaFieldName;
}

    /**
     * getTranslatableValues :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);        
        return result;
}

    /**
     * addTranslatableValues :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addTranslatableValues(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeTranslatableValues :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeTranslatableValues(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearTranslatableValues :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        wikitty.clearField(fieldName);
}

    /**
     * getLang :
     * @param extensionName 
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getLang(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "lang");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);        
        return result;
}

    /**
     * addLang :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void addLang(String extensionName, Wikitty wikitty, String element) {        
        String fieldName = getMetaFieldName(extensionName, "lang");
        wikitty.addToField(fieldName, element);
}

    /**
     * removeLang :
     * @param extensionName 
     * @param wikitty 
     * @param element 
     */

    public static void removeLang(String extensionName, Wikitty wikitty, String element) {
        String fieldName = getMetaFieldName(extensionName, "lang");
        wikitty.removeFromField(fieldName, element);
}

    /**
     * clearLang :
     * @param extensionName 
     * @param wikitty 
     */

    public static void clearLang(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "lang");
        wikitty.clearField(fieldName);
}

    /**
     * getTranslations :
     * @param extensionName 
     * @param wikitty 
     * @return String 
     */

    public static String getTranslations(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translations");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    /**
     * setTranslations :
     * @param extensionName 
     * @param wikitty 
     * @param translations 
     * @return String 
     */

    public static String setTranslations(String extensionName, Wikitty wikitty, String translations) {
        String oldValue = getTranslations(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "translations");
        wikitty.setFqField(fieldName, translations);
        return oldValue;
}


} //WikittyI18nHelper
