/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class WikittyGroupHelper {

    /**
     * WikittyGroupHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyGroupHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME, name);
        return oldValue;
}

    /**
     * getMembers :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getMembers(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, String.class);
        return result;
}

    /**
     * addMembers :
     * @param wikitty 
     * @param element 
     */

    public static void addMembers(Wikitty wikitty, String element) {
        wikitty.addToField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, element);
}

    /**
     * removeMembers :
     * @param wikitty 
     * @param element 
     */

    public static void removeMembers(Wikitty wikitty, String element) {
        wikitty.removeFromField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, element);
}

    /**
     * clearMembers :
     * @param wikitty 
     */

    public static void clearMembers(Wikitty wikitty) {
        wikitty.clearField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            Object f2 = w2.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            Object f2 = w2.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyGroup.EXT_WIKITTYGROUP);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyGroupAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyGroupHelper
