package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class WikittyUserAbstract extends BusinessEntityWikitty implements WikittyUser {

    private static final long serialVersionUID = 556665287L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionWikittyUser =
        new WikittyExtension(EXT_WIKITTYUSER, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String login",
				"String password"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionWikittyUser);

        extensions = Collections.unmodifiableList(exts);
    }

	public WikittyUserAbstract() {
		super();
	}

    public WikittyUserAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public WikittyUserAbstract(Wikitty wi) {
		super(wi);
	}


    public void setLogin(String login) {
        Object oldValue = getField(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_LOGIN);
        getWikitty().setField(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_LOGIN, login);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYUSER_LOGIN, oldValue, login);
    }

    public String getLogin() {
        String result = getWikitty().getFieldAsString(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_LOGIN);
        return result;
    }


    public void setPassword(String password) {
        Object oldValue = getField(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_PASSWORD);
        getWikitty().setField(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_PASSWORD, password);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYUSER_PASSWORD, oldValue, password);
    }

    public String getPassword() {
        String result = getWikitty().getFieldAsString(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_PASSWORD);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_LOGIN);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_LOGIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_PASSWORD);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYUSER, FIELD_WIKITTYUSER_PASSWORD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyUserAbstract
