package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WikittyAuthorisationHelper extends WikittyAuthorisationImpl {

    private static final long serialVersionUID = 1568911264L;


    /**
     * This class is not instanciable, it's just helper
     */
    private WikittyAuthorisationHelper() {
    }


    static public void setOwner(Wikitty w, String Owner) {
        w.setField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, Owner);
    }

    static public String getOwner(Wikitty w) {
        String result = w.getFieldAsString(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
        return result;
    }

    static public Set<String> getAdmin(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, String.class);
        return result;
    }

    static public void addAdmin(Wikitty w, String element) {
        w.addToField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
    }
    
    static public void removeAdmin(Wikitty w, String element) {
        w.removeFromField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, element);
    }
    
    static public void clearAdmin(Wikitty w) {
        w.clearField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
    }

    static public Set<String> getWriter(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, String.class);
        return result;
    }

    static public void addWriter(Wikitty w, String element) {
        w.addToField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
    }
    
    static public void removeWriter(Wikitty w, String element) {
        w.removeFromField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, element);
    }
    
    static public void clearWriter(Wikitty w) {
        w.clearField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
    }

    static public Set<String> getReader(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, String.class);
        return result;
    }

    static public void addReader(Wikitty w, String element) {
        w.addToField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
    }
    
    static public void removeReader(Wikitty w, String element) {
        w.removeFromField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, element);
    }
    
    static public void clearReader(Wikitty w) {
        w.clearField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
    }


    static public void setParent(Wikitty w, String parent) {
        w.setField(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, parent);
    }

    static public String getParent(Wikitty w) {
        String result = w.getFieldAsString(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_WIKITTYAUTHORISATION);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYAUTHORISATION, WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyAuthorisationHelper
