package org.nuiton.wikitty;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface Wikitty extends Cloneable, Serializable {

    void addPropertyChangeListener(PropertyChangeListener listener);

    void removePropertyChangeListener(PropertyChangeListener listener);

    void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    String getId();

    boolean isDeleted();

    Date getDeleteDate();

    /**
     * Server only used
     * @param delete
     */
    void setDeleteDate(Date delete);

    void addExtension(WikittyExtension ext);

    void addExtension(List<WikittyExtension> exts);

    boolean hasExtension(String extName);

    boolean hasField(String extName, String fieldName);

    WikittyExtension getExtension(String ext);

    Collection<String> getExtensionNames();

    Collection<WikittyExtension> getExtensions();

    Collection<WikittyExtension> getExtensionDependencies(String ext,
            boolean recursively);

    /**
     * return field type for the given fieldName.
     * @param fqfieldName fully qualified fieldName extension.fieldname
     * @return field type
     */
    FieldType getFieldType(String fqfieldName);

    void setField(String ext, String fieldName, Object value);

    Object getFieldAsObject(String ext, String fieldName);

    boolean getFieldAsBoolean(String ext, String fieldName);

    BigDecimal getFieldAsBigDecimal(String ext, String fieldName);

    int getFieldAsInt(String ext, String fieldName);

    long getFieldAsLong(String ext, String fieldName);

    float getFieldAsFloat(String ext, String fieldName);

    double getFieldAsDouble(String ext, String fieldName);

    String getFieldAsString(String ext, String fieldName);

    Date getFieldAsDate(String ext, String fieldName);

    /**
     * return wikitty id and not wikitty objet because this method can be call
     * on server or client side and it's better to keep conversion between id
     * and objet to the caller
     * @param ext extension name where this field must to be
     * @param fieldName the field name
     * @return id of wikitty object or null
     * @throws org.nuiton.wikitty.WikittyException
     */
    String getFieldAsWikitty(String ext, String fieldName);

    /**
     * If object is a set, it is automatically transform to list.
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> List<E> getFieldAsList(String ext, String fieldName,
            final Class<E> clazz);

    /**
     *
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> Set<E> getFieldAsSet(String ext, String fieldName, final Class<E> clazz);

    void addToField(String ext, String fieldName, Object value);

    void removeFromField(String ext, String fieldName, Object value);

    void clearField(String ext, String fieldName);

    Set<String> fieldNames();

    Object getFqField(String fqFieldName);

    String getVersion();

    /**
     * Server only used
     * @param version
     */
    void setVersion(String version);

    /**
     * Server only used
     * @param version
     */
    void clearDirty();

    /**
     * Server only used
     * @param fieldName fqn (ex: extensionName.fieldName)
     * @param value new value
     */
    void setFqField(String fieldName, Object value);

    boolean isEmpty();
    
    Wikitty clone() throws CloneNotSupportedException; 

}