package org.nuiton.wikitty.search;

import java.io.Serializable;

/**
 * Between operator is used to build restriction containing "min &lt; element
 * &lt; max" where element could be a Integer, a Float or a Date. <br>
 * <br>
 * For example, use: RestrictionHelper.between( myElement , "15.5" , "22.5" )
 */
public class Between extends Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected Element element;
    protected String min;
    protected String max;

    /**
     * Default constructor
     */
    public Between() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param element
     * @param min
     * @param max
     */
    public Between(Element element, String min, String max) {
        this.element = element;
        this.min = min;
        this.max = max;
    }

    /**
     * Return element
     * 
     * @return
     */
    public Element getElement() {
        return element;
    }

    /**
     * Set a value to parameter element.
     * 
     * @param element
     */
    public void setElement(Element element) {
        this.element = element;
    }

    /**
     * Return min
     * 
     * @return
     */
    public String getMin() {
        return min;
    }

    /**
     * Set a value to parameter min.
     * 
     * @param min
     */
    public void setMin(String min) {
        this.min = min;
    }

    /**
     * Return max
     * 
     * @return
     */
    public String getMax() {
        return max;
    }

    /**
     * Set a value to parameter max.
     * 
     * @param max
     */
    public void setMax(String max) {
        this.max = max;
    }

    /**
     * Equality test based attributes values
     * 
     * @param value
     *            Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Between)) {
            return false;
        }

        final Between between = (Between) other;

        if ((element == null && between.getElement() != null)
                || (element != null && !element.equals(between.getElement()))) {
            return false;
        }
        if ((min == null && between.getMin() != null) 
                || (min != null && !min.equals(between.getMin()))) {
            return false;
        }
        if ((max == null && between.getMax() != null)
                || (max != null && !max.equals(between.getMax()))) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Between.class.getName().hashCode();
        if (element != null) {
            result = 29 * result + element.hashCode();
        }
        if (min != null) {
            result = 29 * result + min.hashCode();
        }
        if (max != null) {
            result = 29 * result + max.hashCode();
        }
        return result;
    }

}