package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;

import org.nuiton.wikitty.FieldType.TYPE;

public class FieldFactory {
    
    protected ExtensionFactory parentFactory;
    protected String fieldName; 
    protected TYPE type;
    protected int minOccur = 0, maxOccur = 1; 
    protected boolean unique = false;
    protected Map<String, String> tagValues = new HashMap<String, String>();
    
    public FieldFactory(ExtensionFactory parentFactory, String fieldName, TYPE type) {
        this.parentFactory = parentFactory;
        this.fieldName = fieldName;
        this.type = type;
    }
    
    public FieldFactory addField(String name, TYPE type) {
        append();
        return parentFactory.addField(name, type);
    }
    
    public WikittyExtension extension() {
        append();
        return parentFactory.extension();
    }
    
    protected void append() {
        FieldType fieldType = new FieldType(type, minOccur, maxOccur);
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            fieldType.addTagValue(tag, value);
        }
        parentFactory.add(fieldName, fieldType);
    }
    
    public FieldFactory maxOccur(int max) {
        maxOccur = max;
        return this;
    }
    
    public FieldFactory minOccur(int min) {
        minOccur = min;
        return this;
    }
    
    public FieldFactory unique() {
        addTagValue(FieldType.UNIQUE, "true");
        return this;
    }

    public FieldFactory notNull() {
        addTagValue(FieldType.NOT_NULL, "true");
        return this;
    }

    public FieldFactory addTagValue(String tag, String value) {
        tagValues.put(tag, value);
        return this;
    }
}
