package org.nuiton.web;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityUser;

@Generated(value = "org.nuiton.topia.templates.EntityEnumTransformer", date = "Thu Dec 12 11:44:06 CET 2013")

public enum SecurityEntityEnum implements TopiaEntityEnum {
    SecurityRole(SecurityRole.class, ArrayUtils.EMPTY_STRING_ARRAY),
    SecurityUser(SecurityUser.class, ArrayUtils.EMPTY_STRING_ARRAY);

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    SecurityEntityEnum(Class<? extends TopiaEntity> contract, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        SecurityEntityEnum constant = valueOf(klass);
        boolean result = constant.getContract() == contract;
        return result;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
            try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static SecurityEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static SecurityEntityEnum valueOf(Class<?> klass) {
        if (klass.isInterface()) {
            return valueOf(klass.getSimpleName());
        }
        for (SecurityEntityEnum entityEnum : SecurityEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(SecurityEntityEnum.values()));
    }

    public static SecurityEntityEnum[] getContracts() {
        SecurityEntityEnum[] result = values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SecurityEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SecurityEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SecurityEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SecurityEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

} //SecurityEntityEnum
