/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.service.sql.batch.actions.AbstractTablesAction;
import org.nuiton.topia.service.sql.batch.actions.ReplicateTablesRequest;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTable;

public class ReplicateTablesAction
extends AbstractTablesAction<ReplicateTablesRequest> {
    public static final String INSERT_STATEMENT = "INSERT INTO %s.%s(%s) VALUES (%%s);\n";
    private static final Log log = LogFactory.getLog(ReplicateTablesAction.class);

    public ReplicateTablesAction(ReplicateTablesRequest request) {
        super(request);
    }

    @Override
    protected void executeOnTable(ReplicateTablesRequest request, TopiaSqlTable table, PreparedStatement readStatement) throws SQLException {
        ResultSet readResultSet = readStatement.getResultSet();
        ResultSetMetaData readResultSetMetaData = readResultSet.getMetaData();
        int columnCount = readResultSetMetaData.getColumnCount();
        List<String> columnNames = this.getColumnNames(readResultSetMetaData, columnCount);
        boolean useOutputWriter = this.useOutputWriter();
        boolean useOutputDb = this.useOutputDb();
        PreparedStatement writeStatement = null;
        String insertStatementSql = this.newInsertStatementSql(table, columnNames);
        if (useOutputDb) {
            String arguments = this.generateWildcardArguments(columnNames);
            String sql = String.format(insertStatementSql, arguments).trim();
            writeStatement = this.targetConnection.prepareStatement(sql);
        }
        int writeBatchSize = request.getWriteBatchSize();
        String tableName = table.getFullyTableName();
        long index = 0L;
        while (readResultSet.next()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Copy " + readResultSet.getString(1)));
            }
            if (useOutputDb) {
                writeStatement.clearParameters();
                for (int i = 1; i <= columnCount; ++i) {
                    Object object = readResultSet.getObject(i);
                    writeStatement.setObject(i, object);
                }
                writeStatement.addBatch();
            }
            if (useOutputWriter) {
                try {
                    String arguments = this.generateSqlArguments(readResultSet, columnNames);
                    String sql = String.format(insertStatementSql, arguments);
                    this.writer.append(sql);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not copyRow", e);
                }
            }
            if (++index % (long)writeBatchSize != 0L) continue;
            this.flush(writeStatement, this.writer, tableName, index);
        }
        this.flush(writeStatement, this.writer, tableName, index);
    }

    protected String newInsertStatementSql(TopiaSqlTable table, List<String> columnNames) throws SQLException {
        StringBuilder columnNamesBuilder = new StringBuilder();
        for (String columnName : columnNames) {
            columnNamesBuilder.append(", ").append(columnName);
        }
        String sql = String.format(INSERT_STATEMENT, table.getSchemaName(), table.getTableName(), columnNamesBuilder.substring(2));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Insert sql: " + sql));
        }
        return sql;
    }
}

