package org.nuiton.topia.taas.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface TaasPrincipal extends TopiaEntity {     String NAME = "name";
     String AUTHORIZATIONS = "authorizations";
    /**
     * setName :
     * @param name La valeur de l'attribut à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * addAuthorizations :
     * @param authorizations L'instance de org.nuiton.topia.taas.entities.TaasAuthorization à ajouter
     */

     void addAuthorizations(TaasAuthorization authorizations);

    /**
     * addAllAuthorizations :
     * @param authorizations Les instances de org.nuiton.topia.taas.entities.TaasAuthorization à ajouter
     */

     void addAllAuthorizations(Collection<TaasAuthorization> authorizations);

    /**
     * setAuthorizations :
     * @param authorizations La valeur de l'attribut à positionner.
     */

     void setAuthorizations(Collection<TaasAuthorization> authorizations);

    /**
     * removeAuthorizations :
     * @param authorizations L'instance de org.nuiton.topia.taas.entities.TaasAuthorization à retirer
     */

     void removeAuthorizations(TaasAuthorization authorizations);

    /**
     * clearAuthorizations :
     */

     void clearAuthorizations();

    /**
     * getAuthorizations :
     * Retourne la collection.
     * @return Collection<TaasAuthorization> 
     */

     Collection<TaasAuthorization> getAuthorizations();

    /**
     * getAuthorizationsByTopiaId :
     * Recupère l'attribut authorizations à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TaasAuthorization 
     */

     TaasAuthorization getAuthorizationsByTopiaId(String topiaId);

    /**
     * sizeAuthorizations :
     * Retourne le nombre d'éléments de la collection authorizations
     * @return int 
     */

     int sizeAuthorizations();

    /**
     * isAuthorizationsEmpty :
     * Retourne {@code true} si la collection authorizations est vide.
     * @return boolean 
     */

     boolean isAuthorizationsEmpty();


} //TaasPrincipal
