package org.nuiton.topia.taas.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={TaasPrincipal.NAME}
)

public interface TaasPrincipal extends TopiaEntity {     String NAME = "name";
     String AUTHORIZATIONS = "authorizations";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * addAuthorizations :
     * @param authorizations L'instance de authorizations à ajouter
     */

     void addAuthorizations(TaasAuthorization authorizations);

    /**
     * addAllAuthorizations :
     * @param authorizations Les instances de authorizations à ajouter
     */

     void addAllAuthorizations(Collection<TaasAuthorization> authorizations);

    /**
     * setAuthorizations :
     * @param authorizations La Collection de authorizations à ajouter
     */

     void setAuthorizations(Collection<TaasAuthorization> authorizations);

    /**
     * removeAuthorizations :
     * @param authorizations Vide la Collection de authorizations
     */

     void removeAuthorizations(TaasAuthorization authorizations);

    /**
     * clearAuthorizations :
     */

     void clearAuthorizations();

    /**
     * getAuthorizations :
     * @return Collection<TaasAuthorization> 
     */

     Collection<TaasAuthorization> getAuthorizations();

    /**
     * getAuthorizationsByTopiaId :
     * Recupère l'attribut authorizations à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TaasAuthorization 
     */

     TaasAuthorization getAuthorizationsByTopiaId(String topiaId);

    /**
     * sizeAuthorizations :
     * Retourne le nombre d'éléments de la collection authorizations
     * @return int 
     */

     int sizeAuthorizations();

    /**
     * isAuthorizationsEmpty :
     * Retourne {@code true} si la collection authorizations est vide.
     * @return boolean 
     */

     boolean isAuthorizationsEmpty();


} //TaasPrincipal
