/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public class ReplicationNode {
    private static final Log log = LogFactory.getLog(ReplicationNode.class);
    protected final TopiaEntityEnum contract;
    protected final EntityOperator<? super TopiaEntity> operator;
    protected Set<ReplicationNode> shell;
    protected final Map<String, ReplicationNode> associations;
    protected final Set<String> associationsToDettach;
    protected final Map<String, ReplicationNode> dependencies;
    protected final Set<String> dependenciesToDettach;
    protected final List<ReplicationOperationDef> operations;

    public ReplicationNode(TopiaEntityEnum contract) {
        this.contract = contract;
        this.operator = EntityOperatorStore.getOperator((TopiaEntityEnum)contract);
        this.associations = new HashMap<String, ReplicationNode>();
        this.dependencies = new HashMap<String, ReplicationNode>();
        this.shell = new HashSet<ReplicationNode>();
        this.associationsToDettach = new HashSet<String>();
        this.dependenciesToDettach = new HashSet<String>();
        this.operations = new ArrayList<ReplicationOperationDef>();
        if (log.isTraceEnabled()) {
            log.trace((Object)("new node : " + this));
        }
    }

    public void addAssociation(String name, ReplicationNode node) {
        this.associations.put(name, node);
    }

    public void addOperation(int index, ReplicationOperationDef op) {
        this.operations.add(index, op);
        if (log.isDebugEnabled()) {
            log.debug((Object)(op + " to node " + this));
        }
    }

    public void addOperation(ReplicationOperationDef op) {
        this.operations.add(op);
        if (log.isDebugEnabled()) {
            log.debug((Object)(op + " to node " + this));
        }
    }

    public void setOperations(List<ReplicationOperationDef> operations) {
        this.clearOperations();
        this.operations.addAll(operations);
    }

    public ReplicationOperationDef[] getOperations() {
        return this.operations.toArray(new ReplicationOperationDef[this.operations.size()]);
    }

    public ReplicationOperationDef[] getUndoableOperations() {
        ArrayList<ReplicationOperationDef> result = new ArrayList<ReplicationOperationDef>();
        for (ReplicationOperationDef operation : this.operations) {
            if (!TopiaReplicationOperationUndoable.class.isAssignableFrom(operation.getOperationClass())) continue;
            result.add(operation);
        }
        return result.toArray(new ReplicationOperationDef[result.size()]);
    }

    public boolean hasAssociation() {
        return !this.associations.isEmpty();
    }

    public boolean hasAssociationsToDettach() {
        return !this.associationsToDettach.isEmpty();
    }

    public String[] getAssociationsDettached(ReplicationNode node) {
        HashSet<String> result = new HashSet<String>();
        for (String name : this.associationsToDettach) {
            ReplicationNode get = this.associations.get(name);
            if (!node.equals(get)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getDependenciesDettached(ReplicationNode node) {
        HashSet<String> result = new HashSet<String>();
        for (String name : this.dependenciesToDettach) {
            ReplicationNode get = this.dependencies.get(name);
            if (!node.equals(get)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean hasDependenciesToDettach() {
        return !this.dependenciesToDettach.isEmpty();
    }

    public boolean hasDependency() {
        return !this.dependencies.isEmpty();
    }

    public void addDependency(String name, ReplicationNode node) {
        this.dependencies.put(name, node);
    }

    public void addAssociationToDettach(String key) {
        this.associationsToDettach.add(key);
    }

    public void addDependencyToDettach(String key) {
        this.dependenciesToDettach.add(key);
    }

    public Map<String, ReplicationNode> getAssociations() {
        return this.associations;
    }

    public Set<String> getAssociationsToDettach() {
        return this.associationsToDettach;
    }

    public Set<String> getDependenciesToDettach() {
        return this.dependenciesToDettach;
    }

    public TopiaEntityEnum getContract() {
        return this.contract;
    }

    public Class<? extends TopiaEntity> getEntityType() {
        return this.contract.getContract();
    }

    public EntityOperator<? super TopiaEntity> getOperator() {
        return this.operator;
    }

    public Map<String, ReplicationNode> getDependencies() {
        return this.dependencies;
    }

    public Set<ReplicationNode> getShell() {
        return this.shell;
    }

    public void setShell(Set<ReplicationNode> shell) {
        this.shell = shell;
    }

    public void sortOperations() {
        Collections.sort(this.operations);
    }

    public void clearOperations() {
        this.operations.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicationNode other = (ReplicationNode)obj;
        return this.contract == other.contract;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.contract.hashCode();
        return hash;
    }

    public String toString() {
        return this.contract.toString();
    }
}

