/* *##% 
 * ToPIA :: Service Migration
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.topia.migration.common;

import java.util.StringTokenizer;

/**
 * SimpleProxyClass.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public class SimpleProxyClass implements ProxyClass {

    /**
     * le nom long (avec package)
     */
    private String canonicalName;
    /**
     * le nom cours
     */
    private String name;

    /**
     * Contructeur avec nom long
     * @param canonicalName le nom avec package
     */
    public SimpleProxyClass(String canonicalName) {
        super();
        this.canonicalName = canonicalName;
        StringTokenizer tokenizer = new StringTokenizer(canonicalName, ".");
        this.name = null;
        while (tokenizer.hasMoreTokens()) {
            this.name = tokenizer.nextToken();
        }
    }

    @Override
    public String getCanonicalName() {
        return canonicalName;
    }

    public String getShortClassName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    @Override
    public ProxyClass clone() {
        return new SimpleProxyClass(this.canonicalName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProxyClass) {
            ProxyClass o = (ProxyClass) other;
            return o.getCanonicalName().equals(this.canonicalName);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.canonicalName;
    }
}
