/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;

public class JdbcHelper {
    private static final Log log = LogFactory.getLog(JdbcHelper.class);
    protected JdbcConfiguration jdbcConfiguration;

    public JdbcHelper(JdbcConfiguration jdbcConfiguration) {
        this.jdbcConfiguration = jdbcConfiguration;
    }

    public String runSelectOnString(String sql) {
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            connection = null;
            preparedStatement = null;
            connection = this.openConnection();
            preparedStatement = connection.prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            String string = resultSet.getString(1);
            this.closeQuietly(preparedStatement);
            this.closeQuietly(connection);
            return string;
        }
        try {
            String string = null;
            this.closeQuietly(preparedStatement);
            this.closeQuietly(connection);
            return string;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(preparedStatement);
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    public void createSchema(String schemaName) {
        Connection connection = null;
        CallableStatement callableStatement = null;
        try {
            connection = this.openConnection();
            callableStatement = connection.prepareCall("create schema " + schemaName);
            callableStatement.execute();
            this.closeQuietly(callableStatement);
            this.closeQuietly(connection);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(callableStatement);
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    public int runUpdate(String sql) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            int result;
            connection = this.openConnection();
            preparedStatement = connection.prepareStatement(sql);
            int n = result = preparedStatement.executeUpdate();
            this.closeQuietly(preparedStatement);
            this.closeQuietly(connection);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(preparedStatement);
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    protected Connection openConnection() throws SQLException {
        this.registerDriver();
        Connection connection = DriverManager.getConnection(this.jdbcConfiguration.getJdbcConnectionUrl(), this.jdbcConfiguration.getJdbcConnectionUser(), this.jdbcConfiguration.getJdbcConnectionPassword());
        return connection;
    }

    protected void closeQuietly(Statement statement) {
        block3: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Unable to close: " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
    }

    protected void closeQuietly(Connection connection) {
        block3: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Unable to close: " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
    }

    protected void closeQuietly(ResultSet resultSet) {
        block3: {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Unable to close: " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
    }

    protected void registerDriver() {
        Driver driver = this.getJdbcDriver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new RuntimeException("unable to register driver " + String.valueOf(driver), e);
        }
    }

    protected Driver getJdbcDriver() {
        Class<? extends Driver> jdbcDriverClass = this.jdbcConfiguration.getJdbcDriverClass();
        try {
            Driver driver = jdbcDriverClass.newInstance();
            return driver;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.valueOf(jdbcDriverClass) + " is not instantiable", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.valueOf(jdbcDriverClass) + " is not instantiable", e);
        }
    }
}

