/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.MoreObjects;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;

public abstract class AbstractTopiaEntity
implements TopiaEntity {
    private static final long serialVersionUID = -7458577454878852241L;
    protected static final TopiaFiresSupport DEFAULT_INSTANCE = new TopiaFiresSupport();
    protected String topiaId;
    protected long topiaVersion;
    protected Date topiaCreateDate = new Date();
    protected transient boolean deleted;
    protected transient WeakReference<TopiaFiresSupport> firesSupport;
    protected transient VetoableChangeSupport preReadListeners;
    protected transient PropertyChangeSupport postReadListeners;
    protected transient VetoableChangeSupport preWriteListeners;
    protected transient PropertyChangeSupport postWriteListeners;

    public void setFiresSupport(TopiaFiresSupport firesSupport) {
        this.firesSupport = new WeakReference<TopiaFiresSupport>(firesSupport);
    }

    protected TopiaFiresSupport getFiresSupportOrNull() {
        TopiaEntityContextable contextable;
        AbstractTopiaDao entityDao;
        TopiaFiresSupport result;
        TopiaFiresSupport topiaFiresSupport = result = this.firesSupport == null ? null : (TopiaFiresSupport)this.firesSupport.get();
        if (result == null && this instanceof TopiaEntityContextable && (entityDao = (AbstractTopiaDao)(contextable = (TopiaEntityContextable)((Object)this)).getGenericEntityDao()) != null) {
            result = entityDao.getTopiaFiresSupport();
            this.setFiresSupport(result);
        }
        return result;
    }

    protected TopiaFiresSupport getFiresSupport() {
        TopiaFiresSupport result = (TopiaFiresSupport)MoreObjects.firstNonNull((Object)this.getFiresSupportOrNull(), (Object)DEFAULT_INSTANCE);
        return result;
    }

    protected PropertyChangeSupport getPostReadListeners(boolean create) {
        if (this.postReadListeners == null && create) {
            this.postReadListeners = new PropertyChangeSupport(this);
        }
        return this.postReadListeners;
    }

    protected PropertyChangeSupport getPostWriteListeners(boolean create) {
        if (this.postWriteListeners == null && create) {
            this.postWriteListeners = new PropertyChangeSupport(this);
        }
        return this.postWriteListeners;
    }

    protected VetoableChangeSupport getPreReadListeners(boolean create) {
        if (this.preReadListeners == null && create) {
            this.preReadListeners = new VetoableChangeSupport(this);
        }
        return this.preReadListeners;
    }

    protected VetoableChangeSupport getPreWriteListeners(boolean create) {
        if (this.preWriteListeners == null && create) {
            this.preWriteListeners = new VetoableChangeSupport(this);
        }
        return this.preWriteListeners;
    }

    @Override
    public String getTopiaId() {
        return this.topiaId;
    }

    @Override
    public void setTopiaId(String v) {
        this.topiaId = v;
    }

    @Override
    public long getTopiaVersion() {
        return this.topiaVersion;
    }

    @Override
    public void setTopiaVersion(long v) {
        this.topiaVersion = v;
    }

    @Override
    public Date getTopiaCreateDate() {
        return this.topiaCreateDate;
    }

    @Override
    public void setTopiaCreateDate(Date topiaCreateDate) {
        this.topiaCreateDate = topiaCreateDate;
    }

    @Override
    public boolean isPersisted() {
        boolean result = this.topiaId != null;
        return result &= !this.deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void notifyDeleted() {
        this.deleted = true;
    }

    public int hashCode() {
        Date date = this.getTopiaCreateDate();
        int result = date == null ? 0 : date.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopiaEntity)) {
            return false;
        }
        TopiaEntity other = (TopiaEntity)obj;
        if (this.getTopiaId() == null || other.getTopiaId() == null) {
            return false;
        }
        boolean result = this.getTopiaId().equals(other.getTopiaId());
        return result;
    }

    protected void fireOnPreRead(String propertyName, Object value) {
        VetoableChangeSupport listeners = this.getPreReadListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPreRead(listeners, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, Object value) {
        PropertyChangeSupport listeners = this.getPostReadListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostRead(listeners, this, propertyName, value);
        }
    }

    protected void fireOnPostRead(String propertyName, int index, Object value) {
        PropertyChangeSupport listeners = this.getPostReadListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostRead(listeners, this, propertyName, index, value);
        }
    }

    protected void fireOnPreWrite(String propertyName, Object oldValue, Object newValue) {
        VetoableChangeSupport listeners = this.getPreWriteListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPreWrite(listeners, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostWrite(listeners, this, propertyName, oldValue, newValue);
        }
    }

    protected void fireOnPostWrite(String propertyName, int index, Object oldValue, Object newValue) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(false);
        if (listeners != null) {
            TopiaFiresSupport topiaFiresSupport = this.getFiresSupport();
            topiaFiresSupport.fireOnPostWrite(listeners, this, propertyName, index, oldValue, newValue);
        }
    }

    public void addPreReadListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreReadListeners(true);
        listeners.addVetoableChangeListener(propertyName, listener);
    }

    public void addPreReadListener(VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreReadListeners(true);
        listeners.addVetoableChangeListener(listener);
    }

    public void removePreReadListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreReadListeners(false);
        if (listeners != null) {
            listeners.removeVetoableChangeListener(propertyName, listener);
        }
    }

    public void removePreReadListener(VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreReadListeners(false);
        if (listeners != null) {
            listeners.removeVetoableChangeListener(listener);
        }
    }

    public void addPostReadListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostReadListeners(true);
        listeners.addPropertyChangeListener(propertyName, listener);
    }

    public void addPostReadListener(PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostReadListeners(true);
        listeners.addPropertyChangeListener(listener);
    }

    public void removePostReadListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostReadListeners(false);
        if (listeners != null) {
            listeners.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void removePostReadListener(PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostReadListeners(false);
        if (listeners != null) {
            listeners.removePropertyChangeListener(listener);
        }
    }

    public void addPreWriteListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreWriteListeners(true);
        listeners.addVetoableChangeListener(propertyName, listener);
    }

    public void addPreWriteListener(VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreWriteListeners(true);
        listeners.addVetoableChangeListener(listener);
    }

    public void removePreWriteListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreWriteListeners(false);
        if (listeners != null) {
            listeners.removeVetoableChangeListener(propertyName, listener);
        }
    }

    public void removePreWriteListener(VetoableChangeListener listener) {
        VetoableChangeSupport listeners = this.getPreWriteListeners(false);
        if (listeners != null) {
            listeners.removeVetoableChangeListener(listener);
        }
    }

    public void addPostWriteListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(true);
        listeners.addPropertyChangeListener(propertyName, listener);
    }

    public void addPostWriteListener(PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(true);
        listeners.addPropertyChangeListener(listener);
    }

    public void removePostWriteListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(false);
        if (listeners != null) {
            listeners.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void removePostWriteListener(PropertyChangeListener listener) {
        PropertyChangeSupport listeners = this.getPostWriteListeners(false);
        if (listeners != null) {
            listeners.removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPostWriteListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.addPostWriteListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePostWriteListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.removePostWriteListener(property, listener);
    }
}

