package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class BillDAOAbstract<E extends Bill> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Bill.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCost(int v) throws TopiaException {
        E result = findByProperty("cost", v);
        return result;
    }

    /**
     * findAllByCost :
     * Retourne les éléments ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCost(int v) throws TopiaException {
        List<E> result = findAllByProperty("cost", v);
        return result;
    }

    /**
     * findByDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut date le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty("date", v);
        return result;
    }

    /**
     * findAllByDate :
     * Retourne les éléments ayant comme valeur pour l'attribut date le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty("date", v);
        return result;
    }

    /**
     * findContainsStore :
     * Retourne le premier élément trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStore(Store... v) throws TopiaException {
        E result = findContainsProperties("store", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStore :
     * Retourne les éléments trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStore(Store... v) throws TopiaException {
        List<E> results = findAllContainsProperties("store", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsCompany :
     * Retourne le premier élément trouvé dont l'attribut company contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsCompany(Company... v) throws TopiaException {
        E result = findContainsProperties("company", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsCompany :
     * Retourne les éléments trouvé dont l'attribut company contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsCompany(Company... v) throws TopiaException {
        List<E> results = findAllContainsProperties("company", Arrays.asList(v));
        return results;
    }


} //BillDAOAbstract<E extends Bill>
