/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1664 $
*
* Mise a jour: $Date: 2009-11-06 18:19:52 +0100 (Fri, 06 Nov 2009) $
* par : $Author: fdesbois $
*/

package org.nuiton.topia.generator;

import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ANNOTATION;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;

/**
 * DTO generator
 */
public class DTOGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(DTOGenerator.class);

    public DTOGenerator() {
        super();
    }

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DTO.java";
    }

    public boolean isDTO(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO);
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
        String clazzName = clazz.getName();
/*{package <%=clazz.getPackageName()%>;

import org.apache.commons.lang.builder.ToStringBuilder;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Collection;

/**
 * DTO implantation for <%=GeneratorUtil.capitalize(clazzName)%> entity.
 *)
public class <%=clazzName%>DTO}*/

/*
 * Définition de la super classe : il ne doit y avoir qu'une
 */        
        
        String extendClass = "";
        Iterator<ObjectModelClass> j = clazz.getSuperclasses().iterator();
        if (j.hasNext()) {
        	ObjectModelClassifier parent = j.next();
        	if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
        		extendClass += parent.getName() + "DTO";
        	} else {
        		extendClass += parent.getName();
        	}
        }

        if (extendClass.length() > 0) {
/*{ extends <%=extendClass%>}*/
        }
/*
 * Définition des interfaces
 */
/*{ implements java.io.Serializable}*/
        String implInterface = "";
        for (Iterator<ObjectModelInterface> i=clazz.getInterfaces().iterator(); i.hasNext();) {
        	ObjectModelClassifier parentInterface = i.next();
        	if (parentInterface.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
        		implInterface += parentInterface.getName() + "DTO";
        	} else {
        		implInterface += parentInterface.getName();
        	}
        	
        	if (i.hasNext()) {
        		implInterface += ", ";
        	}
        }
        if (implInterface.length() > 0) {
/*{, <%=implInterface%> {

}*/
        } else {
        	/*{ {

}*/
        }

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        // TODO Calculer un serialVersionUID si il n'y en a pas
        if (svUID != null) {
/*{    public static final long serialVersionUID = <%=svUID%>;

}*/
        }
/*
 * Définition des attributs
 */
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            
            if (!(attr.isNavigable()
                   || attr.hasAssociationClass())) {
                continue;
            }	
            
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{    /**
     * <%=attr.getDocumentation()%>
     *)
}*/
            }
            String annotation = attr.getTagValue(TAG_ANNOTATION);
            if (annotation != null && annotation.length() > 0) {
/*{    <%=annotation%>
}*/
            }
            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
                	if (isDTO(attrType)) {
                		attrType += "DTO";
                	}
/*{    <%=attrVisibility%> <%=attrType%> <%=attrName%>;
}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
/*{    <%=attrVisibility%> <%=assocClassFQN%>DTO <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
}*/
                }
            } else {
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<";
                	} else {
                		nMultType = "Collection<";
                	}
                	nMultType += attrType;
                	if (isDTO(attrType)) {
                		nMultType += "DTO";
                	}
                	nMultType += ">";
/*{    <%=attrVisibility%> <%=nMultType%> <%=attrName%>;
}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<";
                	} else {
                		nMultType = "Collection<";
                	}
                	nMultType += assocClassFQN;
                	if (isDTO(attrType)) {
                		nMultType += "DTO";
                	}
                	nMultType += ">";
/*{    <%=attrVisibility%> <%=nMultType%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
}*/
                }
            }
        } /* end for*/

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrName = attr.getName();
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                	if (isDTO(attrType)) {
                		attrType += "DTO";
                	}
/*{    <%=attrVisibility%> <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>;
}*/
                }
            }
        }
/*{
    protected java.beans.PropertyChangeSupport p;

    /**
     * Default constructor of <%=clazzName%>DTO.
     *)
    public <%=clazzName%>DTO() {
        p = new java.beans.PropertyChangeSupport(this);
    }

    /**
     * Constructor of <%=clazzName%>DTO with all parameters.
     *)
    public <%=clazzName%>DTO(}*/
        
        boolean une_fois = true;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            if (une_fois) {
                une_fois = false;
            } else {
/*{, }*/
            }

            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
        	if (isDTO(attrType)) {
        		attrTypeDTO += "DTO";
        	}
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{<%=attrTypeDTO%> <%=attrName%>}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
/*{<%=assocClassFQN%>DTO <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>}*/
                }
            } else {
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
/*{<%=nMultType%> <%=attrName%>}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
/*{<%=nMultType%> <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>}*/
                }
            }


        } // end for
        
        /*{ ) {
        this();
}*/


        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            String attrName = attr.getName();

            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{        this.<%=attrName%> = <%=attrName%>;
}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
/*{	       this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
}*/
                }
            } else {
                if (!attr.hasAssociationClass()) {
/*{	       this.<%=attrName%> = <%=attrName%>;
}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
/*{	       this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
}*/
                }
            }
        }
/*{    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }
    
}*/


        /*
         * Définition des getteurs et setteurs
         */
        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!attr.isNavigable()) {
                continue;
            }

            String attrName = attr.getName();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
            if (isDTO(attrType)) {
            	attrTypeDTO += "DTO";
            }

            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
/*{    public void set<%=GeneratorUtil.capitalize(attrName)%>(<%=attrTypeDTO%> value) {
        <%=attrTypeDTO%> oldValue = this.<%=attrName%>;
        this.<%=attrName%> = value;
        p.firePropertyChange("<%=attrName%>", oldValue, value);
    }

    public <%=attrTypeDTO%> get<%=GeneratorUtil.capitalize(attrName)%>() {
        return <%=attrName%>;
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
/*{    public void set<%=GeneratorUtil.capitalize(assocAttrName)%>(<%=assocClassFQN%>DTO association) {
        <%=assocClassFQN%>DTO oldAssocation = this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = association;
        p.firePropertyChange("<%=attrName%>", oldAssocation, assocation);
    }

    public <%=assocClassFQN%>DTO get<%=GeneratorUtil.capitalize(assocAttrName)%>() {
        return <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

}*/
                }
            } else { //NMultiplicity
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des accesseurs sur les classes d'assoc
                    
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
/*{    public void set<%=GeneratorUtil.capitalize(attrName)%>(<%=nMultType%> values) {
        <%=nMultType%> oldValues = this.<%=attrName%>;
        this.<%=attrName%> = values;
        p.firePropertyChange("<%=attrName%>", oldValues, values);
    }

}*/

                    //AddChild
/*{    public <%=attrTypeDTO%> addChild(<%=attrTypeDTO%> <%=attrName%>) {
 	this.<%=attrName%>.add(<%=attrName%>);
}*/
                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
/*{ 	<%=attrName%>.set<%=GeneratorUtil.capitalize(reverseAttrName)%>(this);
}*/
                    }
/*{ 	return <%=attrName%>;
    }
      
}*/
                    //RemoveChild
/*{    public void removeChild(<%=attrTypeDTO%> <%=attrName%>) {
        this.<%=attrName%>.remove(<%=attrName%>);
}*/
                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
/*{ 	<%=attrName%>.set<%=GeneratorUtil.capitalize(reverseAttrName)%>(null);
}*/
                    }
/*{    }
      
}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
/*{    public void set<%=GeneratorUtil.capitalize(assocAttrName)%>(<%=nMultType%> values) {
        <%=nMultType%> oldValues = this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = values;
        p.firePropertyChange("<%=attrName%>", oldValues, values);
    }

}*/
                }
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
/*{    public <%=nMultType%> get<%=GeneratorUtil.capitalize(attrName)%>() {
        return this.<%=attrName%>;
    }

}*/
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
/*{    public <%=nMultType%> get<%=GeneratorUtil.capitalize(assocAttrName)%>() {
        return this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

}*/
                }
            }
        }

/*{
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
}*/
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isDTO = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)); //THIMEL : STEREOTYPE ENTITY ???
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isDTO && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isDTO)) {
            	String attrName = attr.getName();
/*{            append("<%=attrName%>", this.<%=attrName%>).
}*/
            }
        }
/*{         toString();   
        return result;
    }

} //<%=clazz.getName()%>DTO
}*/
    }

} //EntityDTOGenerator
