/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest.beangen;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.beangen.GeneratedVoiture;
import org.nuiton.topiatest.beangen.Voiture;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public abstract class GeneratedVoitureHelper {
    protected static final Function<Voiture, Integer> IMMATRICULATION_FUNCTION = GeneratedVoitureHelper.newImmatriculationFunction();
    protected static final Function<Voiture, String> MODELE_FUNCTION = GeneratedVoitureHelper.newModeleFunction();
    protected static final Function<Voiture, Personne> PROPRIETAIRE_FUNCTION = GeneratedVoitureHelper.newProprietaireFunction();

    public static <BeanType extends Voiture> Class<BeanType> typeOfVoiture() {
        return Voiture.class;
    }

    public static <BeanType extends Voiture> void copyVoiture(BeanType source, BeanType target) {
        Class<BeanType> sourceType = GeneratedVoitureHelper.typeOfVoiture();
        Binder binder = BinderFactory.newBinder(sourceType);
        binder.copy(source, target, new String[0]);
    }

    public static <BeanType extends Voiture> void copyVoiture(BeanType source, BeanType target, Binder<BeanType, BeanType> binder) {
        binder.copy(source, target, new String[0]);
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newImmatriculationPredicate(int immatriculation) {
        final int $tmp = immatriculation;
        return new Predicate<BeanType>(){

            public boolean apply(BeanType input) {
                return Objects.equal((Object)$tmp, (Object)((GeneratedVoiture)input).getImmatriculation());
            }
        };
    }

    public static <BeanType extends Voiture> List<BeanType> filterByImmatriculation(Collection<BeanType> $source, int immatriculation) {
        return Lists.newArrayList((Iterable)Iterables.filter($source, GeneratedVoitureHelper.newImmatriculationPredicate(immatriculation)));
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newModelePredicate(String modele) {
        final String $tmp = modele;
        return new Predicate<BeanType>(){

            public boolean apply(BeanType input) {
                return Objects.equal((Object)$tmp, (Object)((GeneratedVoiture)input).getModele());
            }
        };
    }

    public static <BeanType extends Voiture> List<BeanType> filterByModele(Collection<BeanType> $source, String modele) {
        return Lists.newArrayList((Iterable)Iterables.filter($source, GeneratedVoitureHelper.newModelePredicate(modele)));
    }

    public static <BeanType extends Voiture> Predicate<BeanType> newProprietairePredicate(Personne proprietaire) {
        final Personne $tmp = proprietaire;
        return new Predicate<BeanType>(){

            public boolean apply(BeanType input) {
                return Objects.equal((Object)$tmp, (Object)((GeneratedVoiture)input).getProprietaire());
            }
        };
    }

    public static <BeanType extends Voiture> List<BeanType> filterByProprietaire(Collection<BeanType> $source, Personne proprietaire) {
        return Lists.newArrayList((Iterable)Iterables.filter($source, GeneratedVoitureHelper.newProprietairePredicate(proprietaire)));
    }

    public static <BeanType extends Voiture> Function<BeanType, Integer> getImmatriculationFunction() {
        return IMMATRICULATION_FUNCTION;
    }

    public static <BeanType extends Voiture> Function<BeanType, Integer> newImmatriculationFunction() {
        return new Function<BeanType, Integer>(){

            public Integer apply(BeanType input) {
                return ((GeneratedVoiture)input).getImmatriculation();
            }
        };
    }

    public static <BeanType extends Voiture> ImmutableMap<Integer, BeanType> uniqueIndexByImmatriculation(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, IMMATRICULATION_FUNCTION);
    }

    public static <BeanType extends Voiture> Function<BeanType, String> getModeleFunction() {
        return MODELE_FUNCTION;
    }

    public static <BeanType extends Voiture> Function<BeanType, String> newModeleFunction() {
        return new Function<BeanType, String>(){

            public String apply(BeanType input) {
                return ((GeneratedVoiture)input).getModele();
            }
        };
    }

    public static <BeanType extends Voiture> ImmutableMap<String, BeanType> uniqueIndexByModele(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, MODELE_FUNCTION);
    }

    public static <BeanType extends Voiture> Function<BeanType, Personne> getProprietaireFunction() {
        return PROPRIETAIRE_FUNCTION;
    }

    public static <BeanType extends Voiture> Function<BeanType, Personne> newProprietaireFunction() {
        return new Function<BeanType, Personne>(){

            public Personne apply(BeanType input) {
                return ((GeneratedVoiture)input).getProprietaire();
            }
        };
    }

    public static <BeanType extends Voiture> ImmutableMap<Personne, BeanType> uniqueIndexByProprietaire(Iterable<BeanType> $source) {
        return Maps.uniqueIndex($source, PROPRIETAIRE_FUNCTION);
    }
}

