/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

public class EntityDAOTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityDAOTransformer.class);
    protected Map<ObjectModelClass, Set<ObjectModelClass>> usages;
    Set<String> allEntitiesFqn;
    protected Class<?> daoImplementation;
    protected String entityEnumName;
    protected String entityEnumPackage;
    Map<String, Collection<ObjectModelOperation>> extraOperations = new HashMap<String, Collection<ObjectModelOperation>>();

    public void transformFromModel(ObjectModel model) {
        boolean generateStandaloneEnum = TopiaGeneratorUtil.shouldGenerateStandaloneEnumForDAOHelper(model);
        String modelName = model.getName();
        this.entityEnumName = modelName + "EntityEnum";
        String packageName = this.getDefaultPackageName();
        if (generateStandaloneEnum) {
            this.entityEnumPackage = packageName + "." + this.entityEnumName;
        } else {
            String daoHelperClazzName = modelName + "DAOHelper";
            this.entityEnumPackage = packageName + "." + daoHelperClazzName + "." + this.entityEnumName;
        }
        this.usages = TopiaGeneratorUtil.searchDirectUsages(model);
        boolean extendLegacyDAO = Boolean.valueOf(model.getTagValue("useLegacyDAO"));
        if (extendLegacyDAO) {
            log.warn((Object)"Using a deprecated tag value useLegacyDAO, prefer use the tag value daoImplementation");
            this.daoImplementation = TopiaDAOLegacy.class;
        } else {
            this.daoImplementation = TopiaGeneratorUtil.getDAOImplementation(model);
        }
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses(model, true);
        this.allEntitiesFqn = new HashSet<String>(allEntities.size());
        for (ObjectModelClass entity : allEntities) {
            String fqn = entity.getQualifiedName();
            this.allEntitiesFqn.add(fqn);
            HashSet<ObjectModelOperation> daoOperations = new HashSet<ObjectModelOperation>();
            for (ObjectModelOperation op : entity.getOperations()) {
                if (!TopiaGeneratorUtil.hasDaoStereotype(op)) continue;
                daoOperations.add(op);
            }
            if (!daoOperations.isEmpty()) continue;
            this.extraOperations.put(fqn, daoOperations);
        }
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!TopiaGeneratorUtil.hasDaoStereotype((ObjectModelClassifier)interfacez)) {
            return;
        }
        ObjectModelDependency dependency = interfacez.getDependency("dao");
        if (dependency == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find dependency dao but DAO stereotype was placed on the interface " + interfacez.getName()));
            }
            return;
        }
        ObjectModelClassifier classifier = dependency.getSupplier();
        if (!TopiaGeneratorUtil.isEntity(classifier)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Dependency supplier " + classifier.getQualifiedName() + " is not an entity."));
            }
            return;
        }
        Collection operations = interfacez.getOperations();
        if (CollectionUtils.isEmpty((Collection)operations)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No operation found on interface with DAO stereotype " + classifier.getQualifiedName()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("add " + operations.size() + " extra operation(s) for DAO"));
        }
        this.extraOperations.put(classifier.getQualifiedName(), operations);
    }

    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        if (this.isGenerateDAO(clazz)) {
            this.generateDAOClass(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateImpl(clazz)) {
            this.generateDAOImpl(clazz, clazzName, clazzFQN);
        }
        if (this.isGenerateDAOAbstract(clazz)) {
            this.generateDAOAbstract(clazz, clazzName, clazzFQN);
        }
    }

    protected boolean isGenerateDAO(ObjectModelClass input) {
        String fqn = input.getQualifiedName() + "DAO";
        return !this.isInClassPath(fqn);
    }

    protected boolean isGenerateDAOAbstract(ObjectModelClass input) {
        String fqn = input.getQualifiedName() + "DAOAbstract";
        return !this.isInClassPath(fqn);
    }

    protected boolean isGenerateImpl(ObjectModelClass input) {
        String fqn = input.getQualifiedName() + "DAOImpl";
        if (this.isInClassPath(fqn)) {
            return false;
        }
        Collection<ObjectModelOperation> moreOperations = this.extraOperations.get(input.getQualifiedName());
        return !CollectionUtils.isNotEmpty(moreOperations);
    }

    protected void generateDAOClass(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        ObjectModelClass daoClass = this.createClass(clazzName + "DAO", clazz.getPackageName());
        this.setDocumentation((ObjectModelElement)daoClass, "/**\n * Cette classe etend le DAOImpl pour parametrer la classe avec le bon type\n * Cette classe est marque finale car l'heritage entre les DAO se fait\n * sur les DOAImpl, c-a-d que DAOAbstract peut etendre le DAOImpl\n */");
        this.setSuperClass(daoClass, clazzFQN + "DAOImpl<" + clazzName + ">");
    }

    protected void generateDAOImpl(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        Collection<ObjectModelOperation> moreOperations = this.extraOperations.get(clazz.getQualifiedName());
        if (CollectionUtils.isEmpty(moreOperations)) {
            ObjectModelClass daoImplClass = this.createClass(clazzName + "DAOImpl<E extends " + clazzName + ">", clazz.getPackageName());
            this.setDocumentation((ObjectModelElement)daoImplClass, "/**\n Implantation du DAO pour l'entit\u00e9 " + clazzName + ".\n * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n * simplement dans ces sources. Cette classe g\u00e9n\u00e9r\u00e9e sera alors simplement\n * \u00e9cras\u00e9e\n */");
            this.setSuperClass(daoImplClass, clazzFQN + "DAOAbstract<E>");
        }
    }

    protected void generateDAOAbstract(ObjectModelClass clazz, String clazzName, String clazzFQN) {
        ObjectModelClass daoAbstractClass = this.createAbstractClass(clazzName + "DAOAbstract<E extends " + clazzName + '>', clazz.getPackageName());
        String extendClass = "";
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            extendClass = parent.getQualifiedName();
            if (!TopiaGeneratorUtil.isEntity((ObjectModelClassifier)parent)) continue;
            extendClass = extendClass + "DAOImpl<E>";
            break;
        }
        if (extendClass.length() == 0) {
            extendClass = this.daoImplementation.getName() + "<E>";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("super class = " + extendClass));
        }
        this.setSuperClass(daoAbstractClass, extendClass);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)clazz);
        this.setConstantPrefix(prefix);
        Collection<ObjectModelOperation> DAOoperations = this.getDAOOperations(clazz);
        if (TopiaGeneratorUtil.isCollectionNeeded(DAOoperations)) {
            this.addImport((ObjectModelClassifier)daoAbstractClass, Collection.class);
        }
        if (TopiaGeneratorUtil.isSetNeeded(DAOoperations)) {
            this.addImport((ObjectModelClassifier)daoAbstractClass, Set.class);
        }
        this.addImport((ObjectModelClassifier)daoAbstractClass, List.class);
        this.addImport((ObjectModelClassifier)daoAbstractClass, TopiaException.class);
        boolean enableSecurity = TopiaGeneratorUtil.isClassWithSecurity((ObjectModelClassifier)clazz);
        if (enableSecurity) {
            this.addImport((ObjectModelClassifier)daoAbstractClass, TopiaContextImplementor.class);
            this.addImport((ObjectModelClassifier)daoAbstractClass, ArrayList.class);
            this.addImport((ObjectModelClassifier)daoAbstractClass, Permission.class);
            this.addImport((ObjectModelClassifier)daoAbstractClass, "org.nuiton.topia.taas.entities.TaasAuthorizationImpl");
            this.addImport((ObjectModelClassifier)daoAbstractClass, "org.nuiton.topia.taas.jaas.TaasPermission");
            this.addImport((ObjectModelClassifier)daoAbstractClass, "org.nuiton.topia.taas.TaasUtil");
            this.addImport((ObjectModelClassifier)daoAbstractClass, TopiaDAO.class);
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getEntityClass", "Class<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setOperationBody(op, "\n        return (Class<E>)" + clazzName + ".class;\n    ");
        this.addImport((ObjectModelClassifier)daoAbstractClass, this.entityEnumPackage);
        op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getTopiaEntityEnum", this.entityEnumName, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)daoAbstractClass, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setOperationBody(op, "\n        return " + this.entityEnumName + "." + clazzName + ";\n    ");
        this.generateDAOOperations(daoAbstractClass, DAOoperations);
        this.generateDelete(clazz, daoAbstractClass);
        this.generateNaturalId(daoAbstractClass, clazz);
        this.generateNotNull(daoAbstractClass, clazz);
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, false);
                continue;
            }
            this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(clazzName, daoAbstractClass, attr, true);
                    continue;
                }
                this.generateNMultiplicity(clazzName, daoAbstractClass, attr);
            }
        }
        if (enableSecurity) {
            op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getRequestPermission", "List<Permission>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, String.class, "topiaId");
            this.addParameter(op, Integer.TYPE, "actions");
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n        List<Permission> resultPermissions = new ArrayList<Permission>();\n        if ((actions & TaasUtil.CREATE) == TaasUtil.CREATE) {\n");
            buffer.append(this.generateSecurity(daoAbstractClass, clazz, TopiaGeneratorUtil.getSecurityCreateTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.LOAD) == TaasUtil.LOAD) {\n");
            buffer.append(this.generateSecurity(daoAbstractClass, clazz, TopiaGeneratorUtil.getSecurityLoadTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.UPDATE) == TaasUtil.UPDATE) {\n");
            buffer.append(this.generateSecurity(daoAbstractClass, clazz, TopiaGeneratorUtil.getSecurityUpdateTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        if ((actions & TaasUtil.DELETE) == TaasUtil.DELETE) {\n");
            buffer.append(this.generateSecurity(daoAbstractClass, clazz, TopiaGeneratorUtil.getSecurityDeleteTagValue((ObjectModelClassifier)clazz)));
            buffer.append("\n        }\n        return resultPermissions;\n    ");
            this.setOperationBody(op, buffer.toString());
            op = this.addOperation((ObjectModelClassifier)daoAbstractClass, "getRequestPermission", "List<Permission>", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
            this.addParameter(op, String.class, "topiaId");
            this.addParameter(op, Integer.TYPE, "actions");
            this.addParameter(op, String.class, "query");
            this.addParameter(op, Class.class, "daoClass");
            this.addException(op, TopiaException.class);
            this.setOperationBody(op, "    TopiaContextImplementor context = getContext();\n    List<String> result = context.findAll(query, \"id\", topiaId);\n\n    List<Permission> resultPermissions = new ArrayList<Permission>();\n    for (String topiaIdPermission : result) {\n        TopiaDAO dao = context.getDAO(daoClass);\n        List<Permission> permissions = dao.getRequestPermission(topiaIdPermission, actions);\n        if(permissions != null) {\n            resultPermissions.addAll(permissions);\n        } else {\n            TaasPermission permission = new TaasPermission(topiaIdPermission, actions);\n            resultPermissions.add(permission);\n        }\n    }\n    return resultPermissions;\n    ");
        }
        Set<ObjectModelClass> usagesForclass = this.usages.get(clazz);
        this.generateFindUsages(clazz, daoAbstractClass, usagesForclass);
    }

    protected void generateDelete(ObjectModelClass clazz, ObjectModelClass result) {
        StringBuilder body = new StringBuilder();
        String modelName = StringUtils.capitalize((String)((ObjectModel)this.model).getName());
        String providerFQN = this.getDefaultPackageName() + '.' + modelName + "DAOHelper.getImplementationClass";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrType = GeneratorUtil.getSimpleName((String)attr.getType());
            String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (attr.hasAssociationClass() || reverse == null || !reverse.isNavigable()) continue;
            if (!this.allEntitiesFqn.contains(attr.getType())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[" + result.getName() + "] Skip attribute [" + attr.getName() + "] with type " + attr.getType()));
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                String attrDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr);
                String attrClassifierDBName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attr.getClassifier());
                String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
                String schemaName = TopiaGeneratorUtil.getDbSchemaNameTagValue(attr.getClassifier(), (ObjectModel)this.model);
                if (schemaName != null) {
                    attrJoinTableName = schemaName + "." + attrJoinTableName;
                    attrClassifierDBName = schemaName + "." + attrClassifierDBName;
                }
                String attrReverseDBName = TopiaGeneratorUtil.getReverseDbName(attr);
                String removeName = this.getJavaBeanMethodName("remove", reverseAttrName);
                body.append("\n        {\n            List<" + attrType + "> list = getContext().getHibernate().createNativeQuery(\n                    \" SELECT main.*\" +\n                    \" FROM " + attrClassifierDBName + " main, " + attrJoinTableName + " secondary\" +\n                    \" WHERE main.topiaid = secondary." + attrDBName + "\" +\n                    \" AND secondary." + attrReverseDBName + " = ?\")\n                    .addEntity(\"main\", " + providerFQN + "(" + attrType + ".class))\n                    .setParameter(1, entity.getTopiaId())\n                    .list();\n\n            for (" + attrType + " item : list) {\n                item." + removeName + "(entity);\n            }\n        }\n");
                continue;
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) continue;
            this.addImport((ObjectModelClassifier)result, attrType);
            String attrSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)attrType);
            String getName = this.getJavaBeanMethodName("get", reverseAttrName);
            String setName = this.getJavaBeanMethodName("set", reverseAttrName);
            body.append("\n                                        {\n                                        List<" + attrSimpleType + "> list = getContext()\n                                                    .getDAO(" + attrSimpleType + ".class)\n                                                    .findAllByProperties(" + attrSimpleType + "." + this.getConstantName(reverseAttrName) + ", entity);\n                                            for (" + attrSimpleType + " item : list) {\n\n                                                // sletellier : Set null only if target is concerned by deletion\n                                                if (entity.equals(item." + getName + "())) {\n                                                    item." + setName + "(null);\n                                                }\n                        ");
            if (attr.isAggregate()) {
                body.append("\n            \t\t\tgetContext().getDAO(" + attrSimpleType + ".class).delete(item);\n            \t\t\t//item.delete();\n");
            }
            body.append("\n                    }\n                }\n");
        }
        if (body.length() > 0) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "delete", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)op, Override.class.getSimpleName());
            this.addException(op, TopiaException.class);
            this.addParameter(op, "E", "entity");
            body.append("\n        super.delete(entity);\n    ");
            this.setOperationBody(op, body.toString());
        }
    }

    protected void generateFindUsages(ObjectModelClass clazz, ObjectModelClass result, Set<ObjectModelClass> usagesForclass) {
        this.builder.addImport((ObjectModelClassifier)result, ArrayList.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, Map.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, HashMap.class.getName());
        this.builder.addImport((ObjectModelClassifier)result, TopiaEntity.class.getName());
        if (clazz instanceof ObjectModelAssociationClass || usagesForclass.isEmpty()) {
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Class<U>", "type");
            this.addParameter(operation, "E", "entity");
            this.addException(operation, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
            this.setOperationBody(operation, "\n        return new ArrayList<U>();\n    ");
            operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "E", "entity");
            this.addException(operation, TopiaException.class);
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
            this.setOperationBody(operation, "\n        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();\n    ");
            return;
        }
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        for (ObjectModelClass klass : allEntities) {
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)result, "findUsages", "<U extends TopiaEntity> List<U>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "Class<U>", "type");
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
        StringBuilder buffer = new StringBuilder(300);
        buffer.append("\n        List<?> result = new ArrayList();\n        List tmp;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String usageType = usageClass.getQualifiedName();
            this.builder.addImport((ObjectModelClassifier)result, usageType);
            String usageSimpleType = TopiaGeneratorUtil.getClassNameFromQualifiedName((String)usageType);
            String usageSimplePropertyMethod = "findAllBy" + usageSimpleType;
            String usageCollectionPropertyMethod = "findAllContaining" + usageSimpleType;
            for (ObjectModelAttribute attr : usageClass.getAttributes()) {
                ObjectModelClass targetEntity;
                String type;
                if (!attr.isNavigable()) continue;
                String attrName = attr.getName();
                if (attr.hasAssociationClass() || !allEntitiesByFQN.containsKey(type = attr.getType()) || !(targetEntity = (ObjectModelClass)allEntitiesByFQN.get(type)).equals(clazz)) continue;
                String methodName = TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) ? this.getJavaBeanMethodName("findAllContains", attrName) : this.getJavaBeanMethodName("findAllBy", attrName);
                String daoName = StringUtils.capitalize((String)usageSimpleType) + "DAO";
                this.builder.addImport((ObjectModelClassifier)result, usageClass.getPackageName() + '.' + daoName);
                buffer.append("\n        if (type == " + usageSimpleType + ".class) {\n            " + daoName + " dao = (" + daoName + ")\n                getContext().getDAO(" + usageSimpleType + ".class);\n            tmp = dao." + methodName + "(entity);\n            result.addAll(tmp);\n        }\n");
            }
        }
        buffer.append("\n        return (List<U>) result;\n    ");
        this.setOperationBody(operation, buffer.toString());
        operation = this.addOperation((ObjectModelClassifier)result, "findAllUsages", "Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "E", "entity");
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)operation, "Override");
        buffer = new StringBuilder(300);
        buffer.append("\n        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;\n        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(" + usagesForclass.size() + ");\n\n        List<? extends TopiaEntity> list;\n");
        for (ObjectModelClass usageClass : usagesForclass) {
            String fqn = usageClass.getName();
            buffer.append("\n        list = findUsages(" + fqn + ".class, entity);\n        if (!list.isEmpty()) {\n            result.put(" + fqn + ".class, list);\n        }\n");
        }
        buffer.append("\n        return result;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    private void generateDAOOperations(ObjectModelClass result, Collection<ObjectModelOperation> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        for (ObjectModelOperation op : operations) {
            Set exceptions = op.getExceptions();
            exceptions.add(TopiaException.class.getName());
            this.cloneOperation(op, (ObjectModelClassifier)result, true, new ObjectModelJavaModifier[]{ObjectModelJavaModifier.ABSTRACT, ObjectModelJavaModifier.fromVisibility((String)op.getVisibility())});
        }
    }

    private String generateSecurity(ObjectModelClass result, ObjectModelClass clazz, String tagValue) {
        StringBuilder buffer = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)tagValue)) {
            String[] valuesSecurity;
            String security = tagValue;
            Pattern propertiesPattern = Pattern.compile("((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)attribute\\.(?:([_a-z0-9][_a-zA-Z0-9]*))#(?:(create|load|update|delete))");
            for (String valueSecurity : valuesSecurity = security.split(":")) {
                Matcher matcher = propertiesPattern.matcher(valueSecurity);
                matcher.find();
                String className = matcher.group(1);
                className = StringUtil.substring((String)className, (int)0, (int)-1);
                String attributeName = matcher.group(2);
                String actions = matcher.group(3).toUpperCase();
                String query = "";
                String daoClass = "";
                if (className.equals(clazz.getQualifiedName())) {
                    query = "select " + attributeName + ".topiaId from " + clazz.getQualifiedName() + " where topiaId = :id";
                    daoClass = clazz.getAttribute(attributeName).getClassifier().getQualifiedName();
                } else {
                    query = "select at.topiaId from " + className + " at inner join at." + attributeName + " cl where cl.topiaId = :id";
                    daoClass = className;
                }
                buffer.append("\n              resultPermissions.addAll(getRequestPermission(topiaId,\n                                                            " + actions + ",\n                                                            \"" + query + "\",\n                                                            " + daoClass + ".class));\n");
            }
        } else {
            buffer.append("            return null;\n    ");
        }
        return buffer.toString();
    }

    protected void generateNoNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr, boolean isAssoc) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = clazzName + "." + this.getConstantName(attrName);
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            propertyName = clazzName + '.' + this.getConstantName(assocAttrName) + " + '.' + " + assocClassName + '.' + this.getConstantName(attrName);
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        E result = findByProperty(" + propertyName + ", v);\n        return result;\n    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        List<E> result = findAllByProperty(" + propertyName + ", v);\n        return result;\n    ");
        if (!isAssoc && attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            String assocAttrName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocPropertyConstantName = this.getConstantName(assocAttrName);
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findBy", assocClassName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        E result = findByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n        return result;\n    ");
            op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllBy", assocClassName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.addParameter(op, assocClassFQN, "value");
            this.setOperationBody(op, "\n        List<E> result = findAllByProperty(" + clazzName + "." + assocPropertyConstantName + ", value);\n        return result;\n    ");
        }
    }

    protected void generateNMultiplicity(String clazzName, ObjectModelClass result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            return;
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findContains", attrName), "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        E result = findContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n        return result;\n    ");
        op = this.addOperation((ObjectModelClassifier)result, this.getJavaBeanMethodName("findAllContains", attrName), "List<E>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addParameter(op, attrType, "v");
        this.setOperationBody(op, "\n        List<E> result = findAllContains(" + clazzName + "." + this.getConstantName(attrName) + ", v);\n        return result;\n    ");
    }

    public Collection<ObjectModelOperation> getDAOOperations(ObjectModelClass clazz) {
        Collection<ObjectModelOperation> extra = this.extraOperations.get(clazz.getQualifiedName());
        return extra;
    }

    private void generateNaturalId(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = TopiaGeneratorUtil.getNaturalIdAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNaturalId for " + props));
            }
            ObjectModelOperation findByNaturalId = this.addOperation((ObjectModelClassifier)result, "findByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(findByNaturalId, TopiaException.class);
            ObjectModelOperation existByNaturalId = this.addOperation((ObjectModelClassifier)result, "existByNaturalId", "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(existByNaturalId, TopiaException.class);
            ObjectModelOperation create = this.addOperation((ObjectModelClassifier)result, "create", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.setDocumentation((ObjectModelElement)create, "@deprecated since 2.6.10, prefer use {@link #createByNaturalId}\n");
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)create, "Deprecated");
            this.addException(create, TopiaException.class);
            ObjectModelOperation createByNaturalId = this.addOperation((ObjectModelClassifier)result, "createByNaturalId", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(createByNaturalId, TopiaException.class);
            String searchProperties = "";
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                this.addParameter(findByNaturalId, attr.getType(), propName);
                this.addParameter(existByNaturalId, attr.getType(), propName);
                this.addParameter(create, attr.getType(), propName);
                this.addParameter(createByNaturalId, attr.getType(), propName);
                searchProperties = searchProperties + ", " + clazzName + '.' + this.getConstantName(propName) + ", " + propName;
            }
            searchProperties = searchProperties.substring(2);
            this.setOperationBody(findByNaturalId, "\n        return findByProperties(" + searchProperties + ");\n    ");
            this.setOperationBody(existByNaturalId, "\n        return existByProperties(" + searchProperties + ");\n    ");
            this.setOperationBody(create, "\n        return create(" + searchProperties + ");\n    ");
            this.setOperationBody(createByNaturalId, "\n        return create(" + searchProperties + ");\n    ");
        }
    }

    private void generateNotNull(ObjectModelClass result, ObjectModelClass clazz) {
        Set<ObjectModelAttribute> props = TopiaGeneratorUtil.getNotNullAttributes(clazz);
        if (!props.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("generateNotNull for " + props));
            }
            ObjectModelOperation createByNotNull = this.addOperation((ObjectModelClassifier)result, "createByNotNull", "E", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addException(createByNotNull, TopiaException.class);
            String searchProperties = "";
            String clazzName = clazz.getName();
            for (ObjectModelAttribute attr : props) {
                String propName = attr.getName();
                this.addParameter(createByNotNull, attr.getType(), propName);
                searchProperties = searchProperties + ", " + clazzName + '.' + this.getConstantName(propName) + ", " + propName;
            }
            searchProperties = searchProperties.substring(2);
            this.setOperationBody(createByNotNull, "\n        return create(" + searchProperties + ");\n    ");
        }
    }
}

