/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.Resource;

public class TopiaUtil {
    private static Log log = LogFactory.getLog(TopiaUtil.class);
    @Deprecated
    public static final String HIBERNATE_DEFAULT_SCHEMA = "hibernate.default_schema";
    @Deprecated
    public static final String TOPIA_PERSISTENCE_CLASSES = "topia.persistence.classes";

    public static Properties getProperties(String pathOrUrl) throws TopiaNotFoundException {
        return TopiaUtil.getProperties(null, pathOrUrl);
    }

    public static Properties getProperties(Properties parent, String pathOrUrl) throws TopiaNotFoundException {
        RecursiveProperties result = new RecursiveProperties(parent);
        if (pathOrUrl != null && !pathOrUrl.equals("")) {
            try {
                URL propURL = Resource.getURL((String)pathOrUrl);
                log.info((Object)("Properties file used for " + pathOrUrl + " is: " + propURL));
                result.load(propURL.openStream());
            }
            catch (Exception eee) {
                throw new TopiaNotFoundException("Properties file can't be found: " + pathOrUrl, eee);
            }
        }
        return result;
    }

    public static Pattern getTopiaPattern(String format, Class<? extends TopiaEntity> ... classes) {
        String[] entityPatterns = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<? extends TopiaEntity> aClass = classes[i];
            entityPatterns[i] = "(" + TopiaUtil.getTopiaIdPattern(aClass) + ")";
        }
        String s = String.format(format, entityPatterns);
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
        return Pattern.compile(s);
    }

    public static String getTopiaIdPattern(Class<? extends TopiaEntity> klass) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(klass.getName(), ".");
        while (stk.hasMoreTokens()) {
            buffer.append("\\.").append(stk.nextToken());
        }
        buffer.append("#(?:\\d+?)#(?:\\d+)\\.(?:\\d+)");
        return buffer.substring(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(TopiaContext tx, String entityName) {
        TopiaContextImplementor txi = (TopiaContextImplementor)tx;
        ConnectionProviderSupplier connectionProviderSupplier = null;
        boolean exist = false;
        try {
            connectionProviderSupplier = new ConnectionProviderSupplier(txi);
            Configuration configuration = txi.getHibernateConfiguration();
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        catch (TopiaNotFoundException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            if (connectionProviderSupplier != null) {
                try {
                    connectionProviderSupplier.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cant close connection provider", (Throwable)e);
                }
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(Configuration configuration, String entityName) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        boolean exist = false;
        try {
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaEmpty(Configuration configuration) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        try {
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                Iterator itr = configuration.getClassMappings();
                while (true) {
                    if (itr.hasNext()) {
                        PersistentClass classMapping = (PersistentClass)itr.next();
                        Table testTable = classMapping.getTable();
                        if (testTable == null) {
                            throw new IllegalArgumentException("could not find entity with name " + classMapping.getClassName());
                        }
                        TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                        if (tmd == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Existing table found " + testTable.getName() + " for entity " + classMapping.getClassName() + ", db is not empty."));
                        }
                        boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        finally {
            try {
                connectionProviderSupplier.close();
            }
            catch (IOException e) {
                log.error((Object)"Cant close connection provider", (Throwable)e);
            }
        }
        return true;
    }

    protected static StandardServiceRegistry getStandardServiceRegistry(SessionFactory sessionFactory) {
        SessionFactory.SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        StandardServiceRegistry result = sessionFactoryOptions.getServiceRegistry();
        return result;
    }

    protected static SessionFactoryServiceRegistry getSessionFactoryServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        SessionFactoryServiceRegistry result = (SessionFactoryServiceRegistry)sessionFactoryImplementor.getServiceRegistry();
        return result;
    }

    public static <S extends Service> S getHibernateService(SessionFactory sessionFactory, Class<S> serviceClass) {
        SessionFactoryServiceRegistry serviceRegistry = TopiaUtil.getSessionFactoryServiceRegistry(sessionFactory);
        Service result = serviceRegistry.getService(serviceClass);
        return (S)result;
    }

    public static String getSchemaName(Configuration config) {
        return config.getProperty(HIBERNATE_DEFAULT_SCHEMA);
    }

    public static class ConnectionProviderSupplier
    implements Supplier<ConnectionProvider>,
    Closeable {
        protected StandardServiceRegistry standardServiceRegistry;
        protected ConnectionProvider connectionProvider;
        protected boolean embeddedRegistry;

        public ConnectionProviderSupplier(TopiaContextImplementor topiaContextImplementor) throws TopiaNotFoundException {
            this(topiaContextImplementor.getHibernateConfiguration());
            this.embeddedRegistry = false;
        }

        public ConnectionProviderSupplier(Configuration configuration) {
            Properties properties = configuration.getProperties();
            StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
            this.standardServiceRegistry = builder.applySettings((Map)properties).build();
            this.embeddedRegistry = true;
        }

        public ConnectionProvider get() {
            if (this.connectionProvider == null) {
                this.connectionProvider = (ConnectionProvider)this.standardServiceRegistry.getService(ConnectionProvider.class);
            }
            return this.connectionProvider;
        }

        @Override
        public void close() throws IOException {
            if (this.standardServiceRegistry != null && this.embeddedRegistry) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.standardServiceRegistry);
            }
        }
    }
}

