/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.text.Normalizer;
import javax.servlet.http.HttpSession;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmFileManager;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.MoveFileDto;
import org.nuiton.scmwebeditor.api.dto.result.MoveFileResultDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class MoveFileAction
extends AbstractScmWebEditorAction {
    private static final long serialVersionUID = 4244339447567114412L;
    public static final String REDIRECT = "redirect";
    protected String username;
    protected String pw;
    protected String address;
    protected String scmRoot;
    protected boolean badLogin;
    protected boolean error;
    protected String scmPath;
    protected String fileRoot;
    protected String fileToMove;
    protected String destinationDirectory;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public boolean isError() {
        return this.error;
    }

    public String getScmRoot() {
        return this.scmRoot;
    }

    public void setScmRoot(String scmRoot) {
        this.scmRoot = scmRoot;
    }

    public void setBadLogin(boolean badLogin) {
        this.badLogin = badLogin;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getScmPath() {
        return this.scmPath;
    }

    public void setScmPath(String scmPath) {
        this.scmPath = scmPath;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    public String getFileToMove() {
        return this.fileToMove;
    }

    public void setFileToMove(String fileToMove) {
        this.fileToMove = fileToMove;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(String destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public String execute() {
        String repositoryUUID;
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        ScmFileManager scmFileManager = provider.getFileManager(scmConn);
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.lastIndexOf(47));
        }
        if ((repositoryUUID = scmConn.getRepositoryId()) == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        MoveFileDto dto = new MoveFileDto();
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setScmPath(this.scmPath);
        dto.setFileToMove(this.fileToMove);
        dto.setDestinationDirectory(this.destinationDirectory);
        MoveFileResultDto resultDto = scmFileManager.moveFile(dto);
        if (resultDto.getScmRoot() != null) {
            this.scmRoot = resultDto.getScmRoot();
        }
        if (resultDto.getFileRoot() != null) {
            this.fileRoot = resultDto.getFileRoot();
        }
        if (this.username != null && this.pw != null && this.username.equals("") && this.pw.equals("")) {
            this.username = null;
            this.pw = null;
        }
        if (resultDto.getError() != null) {
            String errorMessage = resultDto.getError();
            this.error = true;
            if (errorMessage.equals("connection failed")) {
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                this.username = null;
                this.pw = null;
                return "error";
            }
            if (errorMessage.equals("auth error")) {
                this.badLogin = true;
                this.username = null;
                this.pw = null;
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                return "login";
            }
            if (errorMessage.equals(REDIRECT)) {
                this.error = false;
                return REDIRECT;
            }
            return "error";
        }
        return "success";
    }
}

