/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import com.opensymphony.xwork2.ActionContext;
import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.ByteOrderMarkDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.nuiton.scmwebeditor.uiweb.ScmSession;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.web.struts2.BaseAction;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractScmWebEditorAction
extends BaseAction
implements ServletRequestAware {
    private static final Log log = LogFactory.getLog(AbstractScmWebEditorAction.class);
    public static final String AUTH_ERROR = "authError";
    public static final String ERROR_PATH = "errorPath";
    protected static final String ENCODING = "UTF-8";
    protected Map<String, Object> session;
    protected transient HttpServletRequest request;
    protected String scmType;
    private static final long serialVersionUID = 1L;
    protected static final String CONTEXT_ACTION_KEY = "action";
    protected static final String PARAMETER_ADDRESS = "address";
    protected static final String PARAMETER_SCM_EDITOR_URL = "scmEditorUrl";
    protected static final String PARAMETER_PROJECT_URL = "projectUrl";
    protected static final String PARAMETER_FILE_NAME = "file_name";
    protected static final String PARAMETER_LANG = "lang";
    protected static final String PARAMETER_DEFAULT_LANG = "defaultLang";
    protected static final String PARAMETER_FORMAT = "format";
    protected static final String PARAMETER_USERNAME = "username";
    protected static final String PARAMETER_PW = "pw";
    protected static final String PARAMETER_MYTEXT = "Mytext";
    protected static final String PARAMETER_ORIG_TEXT = "Orig_text";
    protected static final String PARAMETER_COMMIT_MESSAGE = "Commit_message";
    protected static final String PARAMETER_TEXT = "text";
    protected static final String ATTRIBUTE_REDIRECTION_URL = "Redirection_url";
    protected static final String ATTRIBUTE_ORIG_TEXT = "OrigText";
    protected static final String ATTRIBUTE_INVALIDATE_MAX_TIME = "InvalidateMaxTime";
    protected static final String ATTRIBUTE_LOGIN = "Login";
    protected static final String ATTRIBUTE_IS_LOGIN = "IsLogin";
    protected static final String ATTRIBUTE_BAD_LOGIN = "badLogin";
    protected static final String ATTRIBUTE_PROJECT_URL = "projectUrl";
    protected static final String ATTRIBUTE_SCM_EDITOR_URI = "scmEditorUri";
    protected static final String ATTRIBUTE_PREVIEW_SERVLET_URL = "previewServletUrl";
    protected static final String ATTRIBUTE_FILESEARCH_SERVLET_URL = "searchServletUrl";
    protected static final String ATTRIBUTE_REDIRECT_URL = "Redirect_url";
    protected static final String ATTRIBUTE_PRIVATE_SERVLET_URI = "privateServletUri";
    protected static final String PROPERTIESFILES = "scmwebeditor.properties";
    protected static final String EDITABLESFILES = "editableFiles";
    protected static CodepageDetectorProxy detector;

    public String getScmType() {
        return this.scmType;
    }

    public void setScmType(String scmType) {
        this.scmType = scmType;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    protected CodepageDetectorProxy getCodepageDetector() {
        if (detector == null) {
            detector = CodepageDetectorProxy.getInstance();
            detector.add((ICodepageDetector)new ByteOrderMarkDetector());
            detector.add((ICodepageDetector)new ParsingDetector(true));
            detector.add((ICodepageDetector)JChardetFacade.getInstance());
            detector.add(ASCIIDetector.getInstance());
        }
        return detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertToUnicode(File ... files) {
        CodepageDetectorProxy myDetector = this.getCodepageDetector();
        for (File file : files) {
            try {
                Charset charset = myDetector.detectCodepage(file.toURI().toURL());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Charset for " + file.getAbsolutePath() + " is " + charset));
                }
                if (charset != null && !charset.name().equalsIgnoreCase(ENCODING)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Convert " + file.getAbsolutePath() + " to unicode"));
                    }
                    File tmpFile = File.createTempFile(file.getName(), ".copy");
                    tmpFile.deleteOnExit();
                    FileInputStream is = new FileInputStream(file);
                    FileOutputStream os = new FileOutputStream(tmpFile);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    }
                    is = new FileInputStream(tmpFile);
                    os = new FileOutputStream(file);
                    InputStreamReader ir = new InputStreamReader((InputStream)is, charset);
                    OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING);
                    try {
                        IOUtils.copy((Reader)ir, (Writer)ow);
                        continue;
                    }
                    finally {
                        ((Reader)ir).close();
                        ((Writer)ow).close();
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("File " + file.getAbsolutePath() + " already in unicode : skip"));
            }
            catch (MalformedURLException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't convert file in unicode", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(File file) throws IOException {
        String result = null;
        try (FileInputStream is = new FileInputStream(file);){
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", file.getName());
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            result = metadata.get("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mime type of " + file.getName() + " is : " + result));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(String content, String filename) throws IOException {
        String result = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(ENCODING));){
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            result = metadata.get("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mime type of " + filename + " is : " + result));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getMimeTypes(String content, String filename) throws IOException, SAXException, TikaException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(ENCODING));){
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse((InputStream)is, (ContentHandler)contenthandler, metadata);
            Object[] result = metadata.getValues("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mime type of " + filename + " is : " + Arrays.toString(result)));
            }
            Object[] objectArray = result;
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String file) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(file);){
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static Properties loadProperties(InputStream inStream) throws IOException, NullPointerException {
        Properties properties = new Properties();
        properties.load(inStream);
        return properties;
    }

    public ScmSession getScmSession() {
        ScmSession scmSession;
        this.session = ActionContext.getContext().getSession();
        Object obj = this.session.get("ScmSession");
        if (obj == null) {
            scmSession = new ScmSession();
            this.session.put("ScmSession", scmSession);
        } else {
            scmSession = (ScmSession)obj;
        }
        return scmSession;
    }

    protected String[] getUsernamePwFromSession(String repositoryUUID, String username, String pw) {
        String[] usernamePw = new String[]{username, pw};
        if (username == null || pw == null) {
            String login = this.getScmSession().getUsername(repositoryUUID);
            String password = this.getScmSession().getPassword(repositoryUUID);
            if (login != null && password != null) {
                usernamePw[0] = login;
                usernamePw[1] = password;
            }
        } else if (username.equals("") || pw.equals("")) {
            String login = this.getScmSession().getUsername(repositoryUUID);
            String password = this.getScmSession().getPassword(repositoryUUID);
            if (login != null && password != null) {
                usernamePw[0] = login;
                usernamePw[1] = password;
            }
        } else {
            this.getScmSession().addScmUser(repositoryUUID, username, pw);
        }
        return usernamePw;
    }

    public String getUsername(String url) {
        return this.getScmSession().getUsername(url);
    }

    public String getPassword(String url) {
        return this.getScmSession().getPassword(url);
    }

    public String getSweVersion() {
        return ScmWebEditorConfig.getVersion();
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

