/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.svn;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmRevision;
import org.nuiton.scmwebeditor.api.dto.BrowseDto;
import org.nuiton.scmwebeditor.api.dto.CommitDto;
import org.nuiton.scmwebeditor.api.dto.result.BrowseResultDto;
import org.nuiton.scmwebeditor.api.dto.result.CommitResultDto;
import org.nuiton.util.FileUtil;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnConnection
implements ScmConnection {
    private static final Log log = LogFactory.getLog(SvnConnection.class);
    protected String addressSvn;
    protected String svnPath;
    protected String fileName;
    protected File checkoutdir;
    protected SVNURL remoteUrl;
    protected ISVNAuthenticationManager authManager;
    protected DefaultSVNOptions svnOption;
    protected String pathToLocalRepos;
    protected SVNClientManager manager;

    public String getSvnPath() {
        return this.svnPath;
    }

    public DefaultSVNOptions getSvnOption() {
        return this.svnOption;
    }

    public String getPathToLocalRepos() {
        return this.pathToLocalRepos;
    }

    public void setPathToLocalRepos(String pathToLocalRepos) {
        this.pathToLocalRepos = pathToLocalRepos;
    }

    public SVNClientManager getManager() {
        return this.manager;
    }

    public SvnConnection(String address, String pathToLocalRepos) throws SVNException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SVN repository");
        }
        if (address.lastIndexOf(47) != -1) {
            this.svnPath = address.substring(0, address.lastIndexOf(47));
            this.fileName = address.substring(address.lastIndexOf(47) + 1);
        }
        this.addressSvn = address;
        this.remoteUrl = SVNURL.parseURIEncoded((String)this.svnPath);
        this.authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.svnOption = SVNWCUtil.createDefaultOptions((boolean)false);
        this.svnOption.setPropertyValue("svn:eol-style", "LF");
        this.manager = SVNClientManager.newInstance((ISVNOptions)this.svnOption, (ISVNAuthenticationManager)this.authManager);
        this.pathToLocalRepos = pathToLocalRepos;
    }

    public BrowseResultDto browse(BrowseDto dto) {
        String url;
        BrowseResultDto resultDto = new BrowseResultDto();
        DAVRepositoryFactory.setup();
        String name = dto.getUsername();
        String password = dto.getPassword();
        if (dto.getId().equals("")) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Address svn : " + dto.getAddress()));
                }
                String encodedUrl = SVNEncodingUtil.autoURIEncode((String)this.addressSvn);
                SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)encodedUrl));
                ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
                repository.setAuthenticationManager(svnAuthManager);
                repository.testConnection();
            }
            catch (SVNAuthenticationException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't access to the repository : Auth Problem", (Throwable)e);
                }
                resultDto.setError("auth error");
                return resultDto;
            }
            catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't access to the repository", (Throwable)e);
                }
                resultDto.setError("error");
                return resultDto;
            }
            resultDto.setError("root");
            return resultDto;
        }
        if (dto.getId().equals("0")) {
            url = dto.getAddress();
        } else {
            url = dto.getId();
            dto.setAddress(dto.getId());
        }
        try {
            SVNNodeKind nodeKind;
            String encodedUrl = SVNEncodingUtil.autoURIEncode((String)url);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)encodedUrl));
            ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
            repository.setAuthenticationManager(svnAuthManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repository Root: " + repository.getRepositoryRoot(true)));
                log.debug((Object)("Repository UUID: " + repository.getRepositoryUUID(true)));
            }
            if ((nodeKind = repository.checkPath("", -1L)) == SVNNodeKind.NONE) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("There is no entry at '" + url + "'."));
                }
                resultDto.setError("error");
                return resultDto;
            }
            if (nodeKind == SVNNodeKind.FILE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The entry at '" + url + "' is a file."));
                }
                return resultDto;
            }
            this.listEntries(repository, "", dto.getAddress(), resultDto);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of file : " + resultDto.getFiles().size()));
            }
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository : Auth Problem");
            }
            resultDto.setError("auth error");
            return resultDto;
        }
        catch (SVNException svne) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository");
            }
            resultDto.setError("error");
            return resultDto;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Search success");
        }
        resultDto.setError(null);
        return resultDto;
    }

    public CommitResultDto commit(CommitDto dto) {
        CommitResultDto resultDto;
        block34: {
            block33: {
                block32: {
                    try {
                        this.createCheckoutdir();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block32;
                        log.error((Object)"Can not create checkoutdir", (Throwable)e);
                    }
                }
                resultDto = new CommitResultDto();
                this.updateAuthentication(dto.getUsername(), dto.getPassword());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Entering SVN commit");
                }
                try {
                    this.createCheckoutdir();
                }
                catch (IOException e1) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't create checkoutDir", (Throwable)e1);
                    }
                    resultDto.setError("error");
                    return resultDto;
                }
                try {
                    this.checkout(this.checkoutdir);
                }
                catch (SVNAuthenticationException authexep) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Private SCM on reading " + this.remoteUrl));
                    }
                    this.delTempDirectory(this.checkoutdir);
                    resultDto.setError("auth error");
                    return resultDto;
                }
                catch (SVNException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't checkout the file", (Throwable)e);
                    }
                    this.delTempDirectory(this.checkoutdir);
                    resultDto.setError("error path");
                    return resultDto;
                }
                File checkOutFile = new File(this.checkoutdir, this.fileName);
                resultDto.setLastText(dto.getNewText());
                try {
                    String originalText = FileUtils.readFileToString((File)checkOutFile);
                    resultDto.setOrigText(originalText);
                }
                catch (FileNotFoundException ee) {
                    this.delTempDirectory(this.checkoutdir);
                    resultDto.setError("error");
                    return resultDto;
                }
                catch (IOException e) {
                    log.error((Object)"Can't find the checkout file", (Throwable)e);
                }
                if (!dto.isForce()) {
                    try {
                        ByteArrayOutputStream differents;
                        if (!this.isDifferent(resultDto.getOrigText()) || (differents = this.getDiff(dto.getNewText())).size() <= 0) break block33;
                        resultDto.setDiff(differents.toString("UTF-8"));
                        String diff = resultDto.getDiff();
                        resultDto.setDiff(diff.substring(diff.indexOf("@@")));
                        this.delTempDirectory(this.checkoutdir);
                        try {
                            resultDto.setHeadCommiter(this.getHeadcommiter(dto.getAddress(), dto.getUsername(), dto.getPassword()));
                        }
                        catch (SVNException e) {
                            log.error((Object)"Can't get head commiter", (Throwable)e);
                        }
                        resultDto.setError("file modify");
                        return resultDto;
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block33;
                        log.error((Object)"Can't do diff on file, IO error", (Throwable)e);
                    }
                }
            }
            SVNCommitClient commitClient = new SVNCommitClient((ISVNRepositoryPool)this.manager, (ISVNOptions)this.svnOption);
            File pathToFile = new File(this.checkoutdir, this.fileName);
            try {
                BufferedWriter writer = FileUtil.getWriter((File)pathToFile, (String)"UTF-8");
                writer.write(dto.getNewText());
                ((Writer)writer).flush();
            }
            catch (IOException e1) {
                this.delTempDirectory(this.checkoutdir);
                resultDto.setError("error");
                return resultDto;
            }
            File[] tabFile = new File[]{pathToFile};
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Try to commit");
                }
                commitClient.doCommit(tabFile, false, "From scmwebeditor -- " + dto.getCommitMessage(), null, null, false, false, SVNDepth.FILES);
            }
            catch (SVNAuthenticationException authexep) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"AUTH FAIL", (Throwable)authexep);
                }
                resultDto.setOrigText(dto.getNewText());
                this.delTempDirectory(this.checkoutdir);
                dto.setUsername(null);
                dto.setPassword(null);
                resultDto.setError("auth error");
                return resultDto;
            }
            catch (SVNException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"SVN FAIL", (Throwable)e);
                }
                this.delTempDirectory(this.checkoutdir);
                resultDto.setError("error");
                return resultDto;
            }
            if (this.checkoutdir != null) {
                this.delTempDirectory(this.checkoutdir);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End of commit");
            }
            this.delTempDirectory(this.checkoutdir);
            if (log.isInfoEnabled()) {
                log.info((Object)(dto.getUsername() + " commit the file " + dto.getAddress() + " with message : " + dto.getCommitMessage()));
            }
            try {
                resultDto.setNumRevision(this.getHeadRevisionNumber(dto.getAddress(), dto.getUsername(), dto.getPassword()));
            }
            catch (AuthenticationException e) {
                if (!log.isErrorEnabled()) break block34;
                log.error((Object)"Auth fail", (Throwable)e);
            }
        }
        return resultDto;
    }

    public File getFileContent(String path, String username, String password) throws AuthenticationException {
        File fileContent = this.getFileContentAtRevision(path, username, password, "-1");
        return fileContent;
    }

    public String getHeadRevisionNumber(String path, String username, String password) throws AuthenticationException {
        SVNInfo info;
        block5: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("headRevisionNumber expected " + this.addressSvn + " ; got " + path));
            }
            ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            DefaultSVNOptions svnOptions = new DefaultSVNOptions();
            svnOptions.setPropertyValue("svn:eol-style", "LF");
            SVNWCClient wcClient = new SVNWCClient(svnAuthManager, (ISVNOptions)svnOptions);
            info = null;
            try {
                info = wcClient.doInfo(SVNURL.parseURIEncoded((String)path), SVNRevision.HEAD, SVNRevision.HEAD);
            }
            catch (SVNAuthenticationException e) {
                throw new AuthenticationException("Auth fail");
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can not get info from SVN repository", (Throwable)e);
            }
        }
        String headRevision = "";
        if (info != null) {
            headRevision = info.getRevision().toString();
        }
        return headRevision;
    }

    public String getRepositoryId() {
        String repositoryUUID;
        try {
            String encodedUrl = SVNEncodingUtil.autoURIEncode((String)this.addressSvn);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)encodedUrl));
            ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager();
            repository.setAuthenticationManager(svnAuthManager);
            repositoryUUID = repository.getRepositoryUUID(true);
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can't get UUID", (Throwable)e);
            }
            return null;
        }
        return repositoryUUID;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath(String address, String repositoryRoot, String username, String password) {
        String path = address;
        if (address.toLowerCase().endsWith(".svg")) {
            File svgFile;
            block4: {
                svgFile = null;
                try {
                    svgFile = this.getFileContent(address, username, password);
                }
                catch (AuthenticationException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Can not get file content for address " + address));
                }
            }
            if (svgFile != null) {
                path = svgFile.getAbsolutePath();
            }
        }
        return path;
    }

    public Map<ScmRevision, String> getRevisions(String address, String username, String password) throws AuthenticationException {
        TreeMap<ScmRevision, String> revisions;
        block12: {
            int MAX_MESSAGE_LENGTH = 64;
            String url = address.substring(0, address.lastIndexOf(47));
            String file = address.substring(address.lastIndexOf(47) + 1);
            revisions = new TreeMap<ScmRevision, String>();
            this.updateAuthentication(username, password);
            try {
                SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
                ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
                repository.setAuthenticationManager(svnAuthManager);
                SVNNodeKind nodeKind = repository.checkPath(file, -1L);
                if (nodeKind == SVNNodeKind.NONE) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("There is no entry at '" + address + "'."));
                    }
                    throw new IllegalArgumentException("There is no entry at '" + address + "'.");
                }
                if (nodeKind == SVNNodeKind.DIR) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("The entry at '" + address + "' is a file while a directory was expected."));
                    }
                    throw new IllegalArgumentException("The entry at '" + address + "' is a directory while a file was expected.");
                }
                Collection fileRevisions = repository.getFileRevisions(file, null, 0L, repository.getLatestRevision());
                for (Object fileRev : fileRevisions) {
                    Date commitDate;
                    long revNum;
                    String msg;
                    block11: {
                        msg = ((SVNFileRevision)fileRev).getRevisionProperties().getStringValue("svn:log");
                        if (msg.length() > 64) {
                            msg = msg.substring(0, 64) + "...";
                        }
                        revNum = ((SVNFileRevision)fileRev).getRevision();
                        msg = " (rev " + revNum + ") - " + msg;
                        String date = ((SVNFileRevision)fileRev).getRevisionProperties().getStringValue("svn:date");
                        SimpleDateFormat svnDf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                        commitDate = null;
                        try {
                            commitDate = svnDf.parse(date);
                        }
                        catch (ParseException e) {
                            if (!log.isErrorEnabled()) break block11;
                            log.error((Object)("Can not parse date " + date));
                        }
                    }
                    SimpleDateFormat displayDf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    String formattedDate = displayDf.format(commitDate);
                    msg = formattedDate + " " + msg;
                    if (commitDate == null) continue;
                    ScmRevision scmRev = new ScmRevision(String.valueOf(revNum), commitDate.getTime());
                    revisions.put(scmRev, msg);
                }
            }
            catch (SVNAuthenticationException e) {
                throw new AuthenticationException("Auth fail");
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block12;
                log.error((Object)("Can not get revisions from SVN repository for address " + address), (Throwable)e);
            }
        }
        return revisions;
    }

    public File getFileContentAtRevision(String path, String username, String password, String revision) throws AuthenticationException {
        File tempFile;
        block17: {
            boolean tempFileDeleted;
            String tempFileName;
            boolean localDirectoryCreated;
            String url = path.substring(0, path.lastIndexOf(47));
            String file = path.substring(path.lastIndexOf(47) + 1);
            long rev = Long.parseLong(revision);
            File localDirectory = new File(this.pathToLocalRepos);
            if (!localDirectory.exists() && !(localDirectoryCreated = localDirectory.mkdir()) && log.isDebugEnabled()) {
                log.debug((Object)("Could not create directory " + localDirectory.getAbsolutePath()));
            }
            if ((tempFile = new File(tempFileName = localDirectory.getAbsolutePath() + File.separator + file)).exists() && !(tempFileDeleted = tempFile.delete()) && log.isDebugEnabled()) {
                log.debug((Object)("Could not delete temp file " + tempFileName));
            }
            this.updateAuthentication(username, password);
            try {
                ByteArrayOutputStream baos;
                block16: {
                    SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
                    ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
                    repository.setAuthenticationManager(svnAuthManager);
                    SVNNodeKind nodeKind = repository.checkPath(file, rev);
                    if (nodeKind == SVNNodeKind.NONE) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("There is no entry at '" + url + "'."));
                        }
                        return null;
                    }
                    if (nodeKind == SVNNodeKind.DIR) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("The entry at '" + url + "' is a file while a directory was expected."));
                        }
                        return null;
                    }
                    baos = new ByteArrayOutputStream();
                    SVNProperties fileProperties = new SVNProperties();
                    repository.getFile(file, rev, fileProperties, (OutputStream)baos);
                    fileProperties.getStringValue("svn:entry:revision");
                    try {
                        FileOutputStream fileOutput = new FileOutputStream(tempFileName);
                        baos.writeTo(fileOutput);
                    }
                    catch (FileNotFoundException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can not find file " + tempFileName), (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block16;
                        log.error((Object)("Can not write to file " + tempFileName), (Throwable)e);
                    }
                }
                try {
                    baos.close();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Can't close stream", (Throwable)e);
                    }
                }
            }
            catch (SVNAuthenticationException e) {
                throw new AuthenticationException("Auth fail");
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block17;
                log.error((Object)"Can not get file content from SVN repository", (Throwable)e);
            }
        }
        return tempFile;
    }

    public File getDiffs(String path, String username, String password, String revision1, String revision2) throws AuthenticationException {
        File tempFile;
        block17: {
            boolean tempFileDeleted;
            String tempFileName;
            boolean localDirectoryCreated;
            String url = path.substring(0, path.lastIndexOf(47));
            String file = path.substring(path.lastIndexOf(47) + 1);
            long rev1 = Long.parseLong(revision1);
            long rev2 = Long.parseLong(revision2);
            File localDirectory = new File(this.pathToLocalRepos);
            if (!localDirectory.exists() && !(localDirectoryCreated = localDirectory.mkdir()) && log.isDebugEnabled()) {
                log.debug((Object)("Could not create directory " + localDirectory.getAbsolutePath()));
            }
            if ((tempFile = new File(tempFileName = localDirectory.getAbsolutePath() + File.separator + file)).exists() && !(tempFileDeleted = tempFile.delete()) && log.isDebugEnabled()) {
                log.debug((Object)("Could not delete temp file " + tempFileName));
            }
            this.updateAuthentication(username, password);
            try {
                ByteArrayOutputStream baos;
                block16: {
                    SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
                    ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
                    repository.setAuthenticationManager(svnAuthManager);
                    SVNNodeKind nodeKind1 = repository.checkPath(file, rev1);
                    SVNNodeKind nodeKind2 = repository.checkPath(file, rev2);
                    if (nodeKind1 == SVNNodeKind.NONE || nodeKind2 == SVNNodeKind.NONE) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("There is no entry at '" + url + "'."));
                        }
                        return null;
                    }
                    if (nodeKind1 == SVNNodeKind.DIR || nodeKind2 == SVNNodeKind.DIR) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("The entry at '" + url + "' is a file while a directory was expected."));
                        }
                        return null;
                    }
                    baos = new ByteArrayOutputStream();
                    SVNDiffClient diffClient = new SVNDiffClient(this.authManager, null);
                    String encodedUrl = SVNEncodingUtil.autoURIEncode((String)this.addressSvn);
                    SVNURL fileUrl = SVNURL.parseURIEncoded((String)encodedUrl);
                    SVNRevision svnRev1 = SVNRevision.create((long)rev1);
                    SVNRevision svnRev2 = SVNRevision.create((long)rev2);
                    diffClient.doDiff(fileUrl, SVNRevision.HEAD, svnRev2, svnRev1, SVNDepth.INFINITY, false, (OutputStream)baos);
                    try {
                        FileOutputStream fileOutput = new FileOutputStream(tempFileName);
                        baos.writeTo(fileOutput);
                    }
                    catch (FileNotFoundException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can not find file " + tempFileName), (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block16;
                        log.error((Object)("Can not write to file " + tempFileName), (Throwable)e);
                    }
                }
                try {
                    baos.close();
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Can't close stream", (Throwable)e);
                    }
                }
            }
            catch (SVNAuthenticationException e) {
                throw new AuthenticationException("Auth fail");
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block17;
                log.error((Object)"Can not get file content from SVN repository", (Throwable)e);
            }
        }
        return tempFile;
    }

    public String getSvnRoot(String username, String password) {
        String repositoryRoot;
        try {
            String encodedUrl = SVNEncodingUtil.autoURIEncode((String)this.addressSvn);
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)encodedUrl));
            ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            repository.setAuthenticationManager(svnAuthManager);
            repositoryRoot = repository.getRepositoryRoot(true).toString();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can't get SvnRoot for address " + this.addressSvn), (Throwable)e);
            }
            return null;
        }
        return repositoryRoot;
    }

    public void updateAuthentication(String login, String password) {
        this.authManager = SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password);
        this.manager = SVNClientManager.newInstance((ISVNOptions)this.svnOption, (ISVNAuthenticationManager)this.authManager);
    }

    public void testConnection() throws SVNException {
        String encodedUrl = SVNEncodingUtil.autoURIEncode((String)this.addressSvn);
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)encodedUrl));
        repository.setAuthenticationManager(this.authManager);
        repository.testConnection();
    }

    public boolean isDifferent(String text) throws IOException {
        ByteArrayOutputStream diff = this.getDiff(text);
        boolean positiveSize = diff.size() > 0;
        return positiveSize;
    }

    public ByteArrayOutputStream getDiff(String text) throws IOException {
        File pathToFile = new File(this.checkoutdir, this.fileName);
        SVNDiffClient diffClient = new SVNDiffClient((ISVNRepositoryPool)this.manager, (ISVNOptions)this.svnOption);
        FileUtils.writeStringToFile((File)pathToFile, (String)text, (String)"UTF-8");
        ByteArrayOutputStream diff = new ByteArrayOutputStream();
        try {
            diffClient.doDiff(pathToFile, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, (OutputStream)diff, null);
        }
        catch (SVNException e) {
            log.error((Object)"Diff fail", (Throwable)e);
        }
        return diff;
    }

    public void checkout(File checkoutdir) throws SVNException {
        SVNUpdateClient upclient = new SVNUpdateClient((ISVNRepositoryPool)this.manager, (ISVNOptions)this.svnOption);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do Checkout of " + this.remoteUrl));
        }
        upclient.doCheckout(this.remoteUrl, checkoutdir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.FILES, false);
    }

    public void createCheckoutdir() throws IOException {
        boolean localDirectoryCreated;
        File localDirectory = new File(this.pathToLocalRepos);
        if (!localDirectory.exists() && !(localDirectoryCreated = localDirectory.mkdir()) && log.isDebugEnabled()) {
            log.debug((Object)("Could not create directory " + localDirectory.getAbsolutePath()));
        }
        this.checkoutdir = FileUtil.createTempDirectory((String)"scm_", (String)"", (File)localDirectory);
    }

    public void delTempDirectory(File checkoutdir) {
        block3: {
            if (checkoutdir != null) {
                try {
                    FileUtils.deleteDirectory((File)checkoutdir);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't delete temp directory");
                }
            }
        }
    }

    public String getHeadcommiter(String address, String login, String password) throws SVNException {
        ISVNAuthenticationManager svnAuthManager = SVNWCUtil.createDefaultAuthenticationManager((String)login, (String)password);
        DefaultSVNOptions svnOptions = new DefaultSVNOptions();
        svnOptions.setPropertyValue("svn:eol-style", "LF");
        SVNWCClient wcClient = new SVNWCClient(svnAuthManager, (ISVNOptions)svnOptions);
        SVNInfo info = wcClient.doInfo(SVNURL.parseURIEncoded((String)address), SVNRevision.HEAD, SVNRevision.HEAD);
        String headAuthor = info.getAuthor();
        return headAuthor;
    }

    public void listEntries(SVNRepository repository, String path, String address, BrowseResultDto resultDto) {
        Collection entries;
        block6: {
            entries = null;
            try {
                entries = repository.getDir(path, -1L, null, (Collection)null);
            }
            catch (SVNException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can not reach the repository", (Throwable)e);
            }
        }
        if (entries != null) {
            for (Object entry : entries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("/" + (path.equals("") ? "" : path + "/") + ((SVNDirEntry)entry).getName() + "\n"));
                }
                String file = address + File.separator + (path.equals("") ? "" : path + File.separator) + ((SVNDirEntry)entry).getName();
                if (((SVNDirEntry)entry).getKind() == SVNNodeKind.DIR) {
                    resultDto.getDirectories().put(this.getAddressUnique(file), file);
                    continue;
                }
                resultDto.getFiles().add(file);
            }
        }
    }

    public String getAddressUnique(String fileName) {
        String result = fileName.replaceAll("/|:", "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result of getAddressUnique : " + result));
        }
        return result;
    }
}

