/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.git;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RejectCommitException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.nuiton.scmwebeditor.api.RepositoryNotFoundException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmRevision;
import org.nuiton.scmwebeditor.api.dto.BrowseDto;
import org.nuiton.scmwebeditor.api.dto.CommitDto;
import org.nuiton.scmwebeditor.api.dto.result.BrowseResultDto;
import org.nuiton.scmwebeditor.api.dto.result.CommitResultDto;

public class GitConnection
implements ScmConnection {
    private static final Log log = LogFactory.getLog(GitConnection.class);
    protected Repository gitRepo;
    protected File localDirectory;
    protected String addressGit;
    protected String fileName;
    protected String pathToLocalRepos;
    protected static final String DEFAULT_BRANCH = "master";
    protected final String REPOSITORY_EXTENSION = ".git";

    public Repository getGitRepo() {
        return this.gitRepo;
    }

    public void setGitRepo(Repository gitRepo) {
        this.gitRepo = gitRepo;
    }

    public File getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    public String getAddressGit() {
        return this.addressGit;
    }

    public String getPathToLocalRepos() {
        return this.pathToLocalRepos;
    }

    public void setPathToLocalRepos(String pathToLocalRepos) {
        this.pathToLocalRepos = pathToLocalRepos;
    }

    public GitConnection(String address, String pathToLocalRepos) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Git repository");
        }
        if (address.equals(".git")) {
            throw new IOException("Can not reach Git repository");
        }
        if (address.contains(".git")) {
            this.addressGit = address.substring(0, address.indexOf(".git") + 4);
            this.fileName = address.substring(address.indexOf(".git") + 4);
        } else if (address.startsWith("git://")) {
            String lastPart = address.substring(address.lastIndexOf(47) + 1);
            if (lastPart.contains(".")) {
                this.addressGit = address.replace(lastPart, "");
                this.fileName = address.substring(address.lastIndexOf(47) + 1);
            } else {
                this.addressGit = address;
                this.fileName = "";
            }
        } else {
            this.addressGit = address;
            this.fileName = address.substring(address.lastIndexOf(47) + 1);
        }
        this.pathToLocalRepos = pathToLocalRepos;
    }

    public BrowseResultDto browse(BrowseDto dto) {
        ObjectId commitId;
        String headBranchName;
        BrowseResultDto resultDto = new BrowseResultDto();
        try {
            this.updateRepository(dto.getUsername(), dto.getPassword());
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        try {
            headBranchName = this.gitRepo.getBranch();
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while getting the head branch name", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        resultDto.setHeadBranchName(headBranchName);
        resultDto.setFiles(new LinkedList());
        resultDto.setDirectories(new HashMap());
        try {
            commitId = this.gitRepo.resolve("HEAD");
            String selectedBranch = dto.getSelectedBranch();
            if (selectedBranch != null && !selectedBranch.equals("")) {
                this.changeBranch(selectedBranch);
                commitId = this.gitRepo.resolve(selectedBranch);
                if (commitId == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Branch " + selectedBranch + " was not found, using " + DEFAULT_BRANCH + " instead"));
                    }
                    resultDto.setSelectedBranch(DEFAULT_BRANCH);
                    this.changeBranch(DEFAULT_BRANCH);
                    commitId = this.gitRepo.resolve(DEFAULT_BRANCH);
                }
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        String id = dto.getId();
        String address = dto.getAddress();
        if (id.equals("")) {
            resultDto.setError("root");
            return resultDto;
        }
        String url = id.equals("0") ? address : id;
        try {
            if (!this.gitRepo.getObjectDatabase().exists()) {
                resultDto.setError("error");
                return resultDto;
            }
            RevWalk revWalk = new RevWalk(this.gitRepo);
            if (commitId == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can not access to repository " + url));
                }
                resultDto.setError("error");
                return resultDto;
            }
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            RevTree tree = commit.getTree();
            TreeWalk treeWalk = new TreeWalk(this.gitRepo);
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            String path = url.substring(url.indexOf(".git") + 4);
            ArrayList dirs = Lists.newArrayList((Object[])path.split("/"));
            while (treeWalk.next()) {
                String urlComplete;
                String currentFileName = address + File.separator + treeWalk.getPathString();
                String fileNameComplete = currentFileName + File.separator;
                if (!fileNameComplete.startsWith(urlComplete = url + File.separator) && !urlComplete.startsWith(fileNameComplete)) continue;
                if (treeWalk.isSubtree()) {
                    String pathString = treeWalk.getPathString();
                    String currentDir = pathString.substring(pathString.lastIndexOf(File.separator) + 1);
                    if (dirs.contains(currentDir)) {
                        treeWalk.enterSubtree();
                        continue;
                    }
                    resultDto.getDirectories().put(currentFileName, currentFileName);
                    continue;
                }
                resultDto.getFiles().add(currentFileName);
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't access to the repository", (Throwable)e);
            }
            resultDto.setError("error");
            return resultDto;
        }
        resultDto.setError(null);
        return resultDto;
    }

    public CommitResultDto commit(CommitDto dto) {
        CommitResultDto resultDto;
        block24: {
            block23: {
                resultDto = new CommitResultDto();
                try {
                    this.updateRepository(dto.getUsername(), dto.getPassword());
                }
                catch (RepositoryNotFoundException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                    }
                    resultDto.setError("error");
                    return resultDto;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Entering Git commit");
                }
                File localFile = new File(this.localDirectory.getAbsolutePath() + File.separator + this.fileName);
                resultDto.setLastText(dto.getNewText());
                try {
                    String originalText = FileUtils.readFileToString((File)localFile);
                    resultDto.setOrigText(originalText);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)"Can not find the local file", (Throwable)e);
                    resultDto.setError("error");
                    return resultDto;
                }
                catch (IOException e) {
                    log.error((Object)"Can not open the local file", (Throwable)e);
                    resultDto.setError("error");
                    return resultDto;
                }
                if (dto.getUsername() == null || dto.getPassword() == null) {
                    resultDto.setError("auth error");
                    return resultDto;
                }
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(dto.getUsername(), dto.getPassword());
                try {
                    FileUtils.writeStringToFile((File)localFile, (String)dto.getNewText());
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can not modify the local file", (Throwable)e);
                    }
                    resultDto.setError("error");
                    return resultDto;
                }
                try {
                    Git git = Git.open((File)this.localDirectory);
                    try {
                        this.doCommit(git, dto.getUsername(), "unknown", "From scmwebeditor -- " + dto.getCommitMessage());
                    }
                    catch (GitAPIException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can not commit", (Throwable)e);
                        }
                        resultDto.setError("error");
                        return resultDto;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Preparing push");
                    }
                    if (dto.isCommitOnly()) break block23;
                    PushCommand push = git.push();
                    push.setRemote(this.addressGit);
                    push.setCredentialsProvider((CredentialsProvider)credentials);
                    try {
                        push.call();
                    }
                    catch (GitAPIException e) {
                        this.handlePushException(e);
                        if (e.getMessage().endsWith("not authorized")) {
                            resultDto.setError("auth error");
                        } else {
                            resultDto.setError("error");
                        }
                        return resultDto;
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block23;
                    log.error((Object)("Can not open git local repository : " + this.localDirectory.getAbsolutePath()), (Throwable)e);
                    resultDto.setError("error");
                    return resultDto;
                }
            }
            try {
                resultDto.setNumRevision(this.getHeadRevisionNumber(dto.getAddress(), dto.getUsername(), dto.getPassword()));
            }
            catch (AuthenticationException e) {
                if (!log.isErrorEnabled()) break block24;
                log.error((Object)"Auth fail", (Throwable)e);
            }
        }
        return resultDto;
    }

    public File getFileContent(String path, String username, String password) throws AuthenticationException {
        block3: {
            try {
                this.updateRepository(username, password);
            }
            catch (RepositoryNotFoundException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
        }
        File fileToEdit = new File(this.localDirectory.getAbsolutePath() + File.separator + this.fileName);
        if (!fileToEdit.exists()) {
            throw new IllegalArgumentException("There is no entry at '" + path + "'.");
        }
        return fileToEdit;
    }

    public String getHeadRevisionNumber(String path, String username, String password) throws AuthenticationException {
        String headRevision;
        block5: {
            block4: {
                try {
                    this.updateRepository(username, password);
                }
                catch (RepositoryNotFoundException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
            }
            headRevision = null;
            try {
                ObjectId commitId = this.gitRepo.resolve("HEAD");
                headRevision = commitId.getName();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can not resolve commit HEAD", (Throwable)e);
            }
        }
        return headRevision;
    }

    public String getRepositoryId() {
        return this.addressGit;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath(String address, String repositoryRoot, String username, String password) {
        try {
            this.updateRepository(username, password);
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            return null;
        }
        String path = this.localDirectory.getAbsolutePath() + address.replace(repositoryRoot, "");
        path = path.replaceAll("/", File.separator);
        return path;
    }

    public Map<ScmRevision, String> getRevisions(String address, String username, String password) {
        int MAX_MESSAGE_LENGTH = 64;
        String pathOnRepo = address.replace(this.addressGit + "/", "");
        TreeMap<ScmRevision, String> revisions = new TreeMap<ScmRevision, String>();
        try {
            this.updateRepository(username, password);
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
            }
            return null;
        }
        try {
            Git git = Git.open((File)this.localDirectory);
            LogCommand logCmd = git.log();
            logCmd.addPath(pathOnRepo);
            try {
                Iterable commits = logCmd.call();
                for (RevCommit commit : commits) {
                    String msg = commit.getShortMessage();
                    if (msg.length() > 64) {
                        msg = msg.substring(0, 64) + "...";
                    }
                    long commitTime = (long)commit.getCommitTime() * 1000L;
                    Date commitDate = new Date(commitTime);
                    SimpleDateFormat displayDf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    String formattedDate = displayDf.format(commitDate);
                    msg = formattedDate + " - " + msg;
                    ScmRevision scmRev = new ScmRevision(commit.getName(), commitTime);
                    revisions.put(scmRev, msg);
                }
            }
            catch (GitAPIException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not get revisions for address " + address), (Throwable)e);
                }
                return null;
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not open git local repository : " + this.localDirectory.getAbsolutePath()), (Throwable)e);
            }
            return null;
        }
        return revisions;
    }

    public File getFileContentAtRevision(String path, String username, String password, String revision) throws AuthenticationException {
        File tempFile;
        block6: {
            block5: {
                try {
                    this.updateRepository(username, password);
                }
                catch (RepositoryNotFoundException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
            }
            String pathOnRepo = path.replace(this.addressGit + "/", "");
            String tempFileName = this.localDirectory.getAbsolutePath() + File.separator + pathOnRepo + "_" + revision;
            tempFile = new File(tempFileName);
            try {
                ObjectId commitId = this.gitRepo.resolve(revision);
                RevWalk revWalk = new RevWalk(this.gitRepo);
                RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
                RevTree tree = commit.getTree();
                TreeWalk treeWalk = new TreeWalk(this.gitRepo);
                treeWalk.addTree((AnyObjectId)tree);
                treeWalk.setRecursive(true);
                treeWalk.setFilter((TreeFilter)PathFilter.create((String)pathOnRepo));
                if (!treeWalk.next()) {
                    throw new IllegalStateException("Did not find expected file '" + pathOnRepo + "'");
                }
                ObjectId objectId = treeWalk.getObjectId(0);
                ObjectLoader loader = this.gitRepo.open((AnyObjectId)objectId);
                FileOutputStream fos = new FileOutputStream(tempFile);
                loader.copyTo((OutputStream)fos);
                revWalk.dispose();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)("Error while getting file '" + pathOnRepo + "' content at revision " + revision), (Throwable)e);
            }
        }
        return tempFile;
    }

    public File getDiffs(String path, String username, String password, String revision1, String revision2) throws AuthenticationException {
        File tempFile;
        block8: {
            block7: {
                try {
                    this.updateRepository(username, password);
                }
                catch (RepositoryNotFoundException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Error while cloning or pulling the repository", (Throwable)e);
                }
            }
            String pathOnRepo = path.replace(this.addressGit + "/", "");
            String tempFileName = this.localDirectory.getAbsolutePath() + File.separator + pathOnRepo + "_" + revision1 + "_" + revision2;
            tempFile = new File(tempFileName);
            try {
                ObjectId commitId1 = this.gitRepo.resolve(revision1 + "^{tree}");
                ObjectId commitId2 = this.gitRepo.resolve(revision2 + "^{tree}");
                Git git = Git.open((File)this.localDirectory);
                ObjectReader reader = this.gitRepo.newObjectReader();
                CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                oldTreeIter.reset(reader, (AnyObjectId)commitId2);
                CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                newTreeIter.reset(reader, (AnyObjectId)commitId1);
                DiffCommand diffCommand = git.diff();
                PathFilter pathFilter = PathFilter.create((String)pathOnRepo);
                diffCommand.setPathFilter((TreeFilter)pathFilter);
                diffCommand.setNewTree((AbstractTreeIterator)newTreeIter);
                diffCommand.setOldTree((AbstractTreeIterator)oldTreeIter);
                List diffs = diffCommand.call();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DiffFormatter df = new DiffFormatter((OutputStream)baos);
                df.setRepository(this.gitRepo);
                for (DiffEntry diff : diffs) {
                    df.format(diff);
                    String diffText = baos.toString("UTF-8");
                    FileUtils.writeStringToFile((File)tempFile, (String)diffText);
                    baos.reset();
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Error while getting file '" + pathOnRepo + "' content at revisions " + revision1 + " and " + revision2), (Throwable)e);
                }
            }
            catch (GitAPIException e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)("Can not get revisions for address " + path), (Throwable)e);
            }
        }
        return tempFile;
    }

    public void changeBranch(String branchName) throws IOException {
        if (branchName == null) {
            branchName = DEFAULT_BRANCH;
        } else if (branchName.equals("")) {
            branchName = DEFAULT_BRANCH;
        }
        Git git = Git.open((File)this.localDirectory);
        CheckoutCommand checkout = git.checkout();
        checkout.setCreateBranch(true);
        checkout.setName(branchName);
        checkout.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
        checkout.setStartPoint("origin/" + branchName);
        try {
            checkout.call();
        }
        catch (GitAPIException e) {
            checkout = git.checkout();
            checkout.setName(branchName);
            try {
                checkout.call();
            }
            catch (GitAPIException e1) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not checkout branch " + branchName), (Throwable)e1);
                }
                throw new IOException("Can not checkout branch " + branchName, e1);
            }
        }
    }

    public void updateRepository(String username, String password) throws RepositoryNotFoundException {
        block23: {
            block22: {
                String hashedAddress = this.addressGit;
                String hashResult = this.hash(this.addressGit, "SHA-512");
                if (hashResult != null) {
                    hashedAddress = hashResult;
                }
                this.localDirectory = new File(this.pathToLocalRepos + File.separator + hashedAddress);
                UsernamePasswordCredentialsProvider credentials = null;
                if (username != null && password != null) {
                    credentials = new UsernamePasswordCredentialsProvider(username, password);
                }
                try {
                    if (!this.localDirectory.exists()) {
                        this.cloneRepository((CredentialsProvider)credentials);
                        break block22;
                    }
                    Git git = Git.open((File)this.localDirectory);
                    PullCommand pull = git.pull();
                    pull.setCredentialsProvider((CredentialsProvider)credentials);
                    try {
                        pull.call();
                    }
                    catch (InvalidRemoteException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't pull the remote repository", (Throwable)e);
                        }
                        this.cloneRepository((CredentialsProvider)credentials);
                    }
                    catch (JGitInternalException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't pull the remote repository", (Throwable)e);
                        }
                        this.cloneRepository((CredentialsProvider)credentials);
                    }
                    catch (TransportException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't pull the remote repository: " + this.addressGit), (Throwable)e);
                        }
                        if (e.getMessage().endsWith("500 Internal Server Error")) {
                            throw new AuthenticationException("Can not pull the Git repository: auth failed");
                        }
                        this.cloneRepository((CredentialsProvider)credentials);
                    }
                    catch (GitAPIException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't pull the remote repository", (Throwable)e);
                        }
                        this.cloneRepository((CredentialsProvider)credentials);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Pulled repository " + this.addressGit));
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can not clone repository " + this.addressGit));
                    }
                }
                catch (AuthenticationException e) {
                    if (!log.isErrorEnabled()) break block22;
                    log.error((Object)("Can not clone repository " + this.addressGit + ": authentication error"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection to local repository");
            }
            File gitFile = new File(this.localDirectory.getAbsolutePath() + File.separator + ".git");
            FileRepositoryBuilder gitRepoBuilder = new FileRepositoryBuilder();
            gitRepoBuilder.setGitDir(gitFile);
            try {
                this.gitRepo = gitRepoBuilder.build();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block23;
                log.error((Object)("Can not get repository at address " + this.addressGit));
            }
        }
        if (!this.gitRepo.getObjectDatabase().exists() && log.isErrorEnabled()) {
            log.error((Object)("The repository at address " + this.addressGit + " doesn't exist"));
            throw new RepositoryNotFoundException("The repository at address " + this.addressGit + " doesn't exist");
        }
    }

    protected void cloneRepository(CredentialsProvider credentials) throws IOException, AuthenticationException, RepositoryNotFoundException {
        if (this.localDirectory.exists()) {
            FileUtils.deleteDirectory((File)this.localDirectory);
        }
        CloneCommand clone = Git.cloneRepository();
        clone.setURI(this.addressGit);
        clone.setDirectory(this.localDirectory);
        clone.setCredentialsProvider(credentials);
        try {
            clone.call();
        }
        catch (InvalidRemoteException e) {
            FileUtils.deleteDirectory((File)this.localDirectory);
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't clone the remote repository", (Throwable)e);
            }
        }
        catch (TransportException e) {
            FileUtils.deleteDirectory((File)this.localDirectory);
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't clone the remote repository: " + this.addressGit), (Throwable)e);
            }
            if (e.getMessage().endsWith("500 Internal Server Error") || e.getMessage().endsWith("no CredentialsProvider has been registered")) {
                throw new AuthenticationException("Can not clone the Git repository: auth failed");
            }
            throw new RepositoryNotFoundException("Can not find a Git repository at address " + this.addressGit, (Throwable)e);
        }
        catch (GitAPIException e) {
            FileUtils.deleteDirectory((File)this.localDirectory);
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't clone the remote repository", (Throwable)e);
            }
            throw new RepositoryNotFoundException("Can not find a Git repository at address " + this.addressGit, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cloned repository " + this.addressGit));
        }
    }

    protected String hash(String toHash, String algorithm) {
        String hashed = null;
        try {
            MessageDigest md;
            block6: {
                md = MessageDigest.getInstance(algorithm);
                try {
                    md.update(toHash.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Can not get bytes from UTF-8 encoding");
                }
            }
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aByteData : byteData) {
                String hexByte = Integer.toString((aByteData & 0xFF) + 256, 16);
                hexByte = hexByte.substring(1);
                sb.append(hexByte);
            }
            hashed = sb.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("hashed " + toHash + " : " + hashed));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Can not hash " + toHash + " : the algorithm " + algorithm + " does not exist"), (Throwable)e);
        }
        return hashed;
    }

    protected void doCommit(Git git, String authorName, String authorEmail, String commitMessage) throws GitAPIException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing commit");
        }
        CommitCommand commit = git.commit();
        commit.setAll(true);
        commit.setAuthor(authorName, authorEmail);
        commit.setMessage(commitMessage);
        commit.call();
    }

    protected void handlePushException(GitAPIException e) {
        String logMessage = "Can not push";
        if (e instanceof NoHeadException) {
            logMessage = "Can not push : the Git repository has no HEAD reference";
        } else if (e instanceof UnmergedPathsException) {
            logMessage = "Can not push : conflicts found (unmerged paths)";
        } else if (e instanceof ConcurrentRefUpdateException) {
            logMessage = "Can not push : someone else is updating the HEAD or the branch";
        } else if (e instanceof WrongRepositoryStateException) {
            logMessage = "Can not push : the repository is not in the right state";
        } else if (e instanceof RejectCommitException) {
            logMessage = "Can not push : commit rejected";
        }
        if (log.isErrorEnabled()) {
            log.error((Object)logMessage, (Throwable)e);
        }
    }
}

