/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.GZUtil;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);
    public static final String ENCODING = StandardCharsets.ISO_8859_1.name();

    public static File byteToFile(byte[] bytes) throws IOException {
        File file = File.createTempFile("FileUtil-byteToFile", ".tmp");
        FileUtils.writeByteArrayToFile(file, bytes);
        return file;
    }

    public static BufferedReader getReader(File file) throws IOException {
        return FileUtil.getReader(file, ENCODING);
    }

    public static BufferedReader getReader(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        InputStreamReader in = new InputStreamReader((InputStream)inf, encoding);
        BufferedReader result = new BufferedReader(in);
        return result;
    }

    public static BufferedWriter getWriter(File file) throws IOException {
        return FileUtil.getWriter(file, ENCODING);
    }

    public static BufferedWriter getWriter(File file, String encoding) throws IOException {
        FileOutputStream outf = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, encoding);
        BufferedWriter result = new BufferedWriter(out);
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix, File tmpdir) throws IOException {
        if (tmpdir == null) {
            tmpdir = new File(System.getProperty("java.io.tmpdir"));
        }
        File result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        while (result.exists()) {
            result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        }
        if (!result.mkdirs()) {
            throw new IOException("Can't create temporary directory: " + result);
        }
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static File getTempFile(String content) throws IOException {
        return FileUtil.getTempFile(content, "");
    }

    public static File getTempFile(String content, String fileSuffix) throws IOException {
        File result = File.createTempFile("tmp-" + FileUtil.class.getName(), fileSuffix);
        result.deleteOnExit();
        FileUtils.write(result, (CharSequence)content, Charset.defaultCharset());
        return result;
    }

    public static String basename(File file, String ... suffixes) {
        String result = FileUtil.basename(file.getName(), suffixes);
        return result;
    }

    public static String basename(String name, String ... suffixes) {
        String result = name;
        for (String suffixe : suffixes) {
            if (!result.endsWith(suffixe)) continue;
            result = result.substring(0, result.length() - suffixe.length());
            break;
        }
        return result;
    }

    public static String extension(File file, String ... extchars) {
        String name = file.getName();
        String result = FileUtil.extension(name, extchars);
        return result;
    }

    public static String extension(String name, String ... extchars) {
        String result = "";
        if (extchars.length == 0) {
            extchars = new String[]{"."};
        }
        for (String extchar : extchars) {
            int pos = name.lastIndexOf(extchar);
            if (pos == -1) continue;
            result = name.substring(pos + extchar.length());
            break;
        }
        return result;
    }

    public static File changeExtension(File file, String newExtension, String ... extchars) throws IOException {
        String name = file.getName();
        String newName = FileUtil.changeExtension(name, newExtension, extchars);
        File newFile = new File(file.getParentFile(), newName);
        return newFile;
    }

    public static String changeExtension(String name, String newExtension, String ... extchars) throws IOException {
        String extension = FileUtil.extension(name, extchars);
        if (extension == null) {
            throw new IOException("Could not find extension for name " + name + " within " + Arrays.toString(extchars));
        }
        String nameWithoutExtension = name.substring(0, name.length() - extension.length());
        String newName = nameWithoutExtension + newExtension;
        return newName;
    }

    public static File getRelativeFile(File inputDirectory, File outputDirectory, File file) {
        String inputPath = inputDirectory.getAbsolutePath();
        String s2 = file.getAbsolutePath();
        int index = s2.indexOf(inputPath);
        if (index == -1) {
            throw new IllegalArgumentException("File " + file + " is not in " + inputDirectory);
        }
        String relativePath = s2.substring(inputPath.length());
        File result = new File(outputDirectory, relativePath);
        return result;
    }

    public static List<File> getSubDirectories(File directory) {
        class DirectoryFilter
        implements FileFilter {
            DirectoryFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        }
        return FileUtil.getFilteredElements(directory, new DirectoryFilter(), true);
    }

    public static List<File> getFiles(File directory) {
        class NormalFileFilter
        implements FileFilter {
            NormalFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        }
        return FileUtil.getFilteredElements(directory, new NormalFileFilter(), true);
    }

    public static List<File> find(File directory, final String pattern, boolean recursively) {
        String root = directory.getAbsolutePath();
        final int rootLength = root.length();
        return FileUtil.getFilteredElements(directory, new FileFilter(){

            @Override
            public boolean accept(File f) {
                String longFilename = f.getAbsolutePath();
                String filename = longFilename.substring(rootLength + 1);
                return filename.matches(pattern);
            }
        }, recursively);
    }

    public static List<File> getFilteredElements(File directory, FileFilter ff, boolean recursively) {
        ArrayList<File> result = new ArrayList<File>();
        LinkedList<File> todo = new LinkedList<File>();
        if (directory.isDirectory()) {
            todo.addAll(Arrays.asList(directory.listFiles()));
        }
        while (todo.size() > 0) {
            File[] childs;
            File file = (File)todo.removeFirst();
            if (recursively && file.isDirectory() && (childs = file.listFiles()) != null) {
                todo.addAll(Arrays.asList(childs));
            }
            if (ff != null && !ff.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    public static boolean walkAfter(File f, FileAction fileAction) {
        boolean result = fileAction.doAction(f);
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkAfter(aList, fileAction);
            }
        }
        return result;
    }

    public static boolean walkBefore(File f, FileAction fileAction) {
        boolean result = true;
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkBefore(aList, fileAction);
            }
        }
        return result && fileAction.doAction(f);
    }

    public static void copyRecursively(File srcDir, File destDir, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, null, null, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, String renameFrom, String renameTo, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, true, renameFrom, renameTo, false, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, boolean includeSrcDir, String renameFrom, String renameTo, boolean exclude, String ... includePatterns) throws IOException {
        String rootSrc = includeSrcDir ? srcDir.getParent() : srcDir.getPath();
        List<File> files = FileUtil.getFilteredElements(srcDir, null, true);
        log.debug("copyRecursively: " + files);
        for (File file : files) {
            boolean doCopy = FileUtil.copyRecursivelyAccept(file, includePatterns);
            if (!(exclude ^ doCopy)) continue;
            String path = file.getPath().substring(rootSrc.length());
            if (renameFrom != null && renameTo != null) {
                String tmp = path.replaceAll(renameFrom, renameTo);
                if (log.isDebugEnabled()) {
                    log.debug("rename " + path + " \u2192 " + tmp);
                }
                path = tmp;
            }
            File destFile = new File(destDir, path);
            if (file.isDirectory()) {
                log.debug("create directory: " + destFile);
                FileUtil.createDirectoryIfNecessary(destFile);
                continue;
            }
            log.debug("copy " + path + " to " + destFile);
            FileUtils.copyFile(file, destFile);
        }
    }

    public static ByteArrayOutputStream readBytesFrom(InputStream inputStream, int defaultBufferSize) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(defaultBufferSize);
        byte[] buffer = new byte[defaultBufferSize];
        int readBytes = inputStream.read(buffer);
        while (readBytes > 0) {
            outputStream.write(buffer, 0, readBytes);
            readBytes = inputStream.read(buffer);
        }
        return outputStream;
    }

    private static boolean copyRecursivelyAccept(File file, String[] includePatterns) {
        String pattern;
        boolean result = includePatterns.length == 0;
        String filename = file.getAbsolutePath();
        String[] stringArray = includePatterns;
        int n = stringArray.length;
        for (int i = 0; i < n && !(result = filename.matches(pattern = stringArray[i])); ++i) {
        }
        return result;
    }

    protected static List<CharSequence> grep(String regex, CharBuffer cb) {
        ArrayList<String> linesList = null;
        Pattern pattern = Pattern.compile(regex);
        Pattern linePattern = Pattern.compile(".*\r?\n");
        Matcher lm = linePattern.matcher(cb);
        Matcher pm = null;
        while (lm.find()) {
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                if (linesList == null) {
                    linesList = new ArrayList<String>();
                }
                linesList.add(cs);
            }
            if (lm.end() != cb.limit()) continue;
            break;
        }
        return linesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CharSequence> grep(String searchRegex, File f, String encoding) throws IOException {
        List<CharSequence> lines = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            lines = FileUtil.grep(searchRegex, cb);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return lines;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, File rootDirectory, String fileRegex, String encoding) throws IOException {
        HashMap<File, List<CharSequence>> results = new HashMap<File, List<CharSequence>>();
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            List<CharSequence> lines = FileUtil.grep(searchRegex, file, encoding);
            if (lines == null) continue;
            results.put(file, lines);
        }
        return results;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, String fileRegex, String encoding) throws IOException {
        Map<File, List<CharSequence>> results = FileUtil.grep(searchRegex, new File("."), fileRegex, encoding);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sed(String searchRegex, String replace, File file, String encoding) throws IOException {
        Pattern pattern = Pattern.compile(searchRegex);
        String outString = null;
        try (FileInputStream fis = new FileInputStream(file);){
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            Matcher matcher = pattern.matcher(cb);
            outString = matcher.replaceAll(replace);
        }
        if (outString != null) {
            try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
                ps.print(outString);
            }
        }
    }

    public static void sed(String searchRegex, String replace, File rootDirectory, String fileRegex, String encoding) throws IOException {
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            FileUtil.sed(searchRegex, replace, file, encoding);
        }
    }

    public static void sed(String searchRegex, String replace, String fileRegex, String encoding) throws IOException {
        FileUtil.sed(searchRegex, replace, new File("."), fileRegex, encoding);
    }

    public static boolean createDirectoryIfNecessary(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return false;
    }

    public static File getFileFromPaths(File rootDirectory, String ... paths) {
        File result = rootDirectory;
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }

    public static File getFileFromFQN(File rootDirectory, String fqn) {
        String[] paths = fqn.split("\\.");
        File result = FileUtil.getFileFromPaths(rootDirectory, paths);
        return result;
    }

    public static File getTestSpecificDirectory(Class<?> testClassName, String methodName, String classifier, long timestamp) {
        File tempDirFile = SystemUtils.getJavaIoTmpDir();
        String dataBasePath = testClassName.getName() + File.separator + methodName;
        if (StringUtils.isNotBlank(classifier)) {
            dataBasePath = dataBasePath + classifier;
        }
        dataBasePath = dataBasePath + (95L + timestamp);
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzipFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            boolean gzip = GZUtil.isGzipStream(in);
            ((InputStream)in).close();
            boolean bl = gzip;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static interface FileAction {
        public boolean doAction(File var1);
    }
}

