/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: BeanUtil.java 1948 2010-11-17 21:31:00Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.5.1/src/main/java/org/nuiton/util/beans/BeanUtil.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.beans;

import org.apache.commons.beanutils.MethodUtils;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;

/**
 * Usefull methods around the {@link PropertyChangeListener}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.1
 */
public class BeanUtil {
    public static final String ADD_PROPERTY_CHANGE_LISTENER = "addPropertyChangeListener";

    public static final String REMOVE_PROPERTY_CHANGE_LISTENER = "removePropertyChangeListener";

    protected BeanUtil() {
        // no instance
    }

    /**
     * Add the given {@code listener} to the given {@code bean} using the
     * normalized method named {@code addPropertyChangeListener}.
     *
     * @param listener the listener to add
     * @param bean     the bean on which the listener is added
     * @throws InvocationTargetException if could not invoke the method
     *                                   {@code addPropertyChangeListener}
     * @throws NoSuchMethodException     if method
     *                                   {@code addPropertyChangeListener}
     *                                   does not exist on given bean
     * @throws IllegalAccessException    if an illegal access occurs when
     *                                   invoking the method
     *                                   {@code addPropertyChangeListener}
     */
    public static void addPropertyChangeListener(PropertyChangeListener listener,
                                                 Object bean) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        MethodUtils.invokeExactMethod(bean,
                                      ADD_PROPERTY_CHANGE_LISTENER,
                                      new Object[]{listener},
                                      new Class[]{PropertyChangeListener.class}
        );
    }

    /**
     * Remove the given {@code listener} from the given {@code bean} using the
     * normalized method named {@code removePropertyChangeListener}.
     *
     * @param listener the listener to remove
     * @param bean     the bean on which the listener is removed
     * @throws InvocationTargetException if could not invoke the method
     *                                   {@code removePropertyChangeListener}
     * @throws NoSuchMethodException     if method
     *                                   {@code removePropertyChangeListener}
     *                                   does not exist on given bean
     * @throws IllegalAccessException    if an illegal access occurs when
     *                                   invoking the method
     *                                   {@code removePropertyChangeListener}
     */
    public static void removePropertyChangeListener(PropertyChangeListener listener,
                                                    Object bean) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        MethodUtils.invokeExactMethod(bean,
                                      REMOVE_PROPERTY_CHANGE_LISTENER,
                                      new Object[]{listener},
                                      new Class[]{PropertyChangeListener.class}
        );
    }
}
