/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: StreamKeywordTokenizer.java 1830 2010-04-15 14:29:20Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.3.1/src/main/java/org/nuiton/util/StreamKeywordTokenizer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * StreamKeywordTokenizer.java
 *
 * Created: 27 mai 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 1830 $
 *
 * Mise a jour: $Date: 2010-04-15 16:29:20 +0200 (jeu., 15 avril 2010) $
 * par : */

package org.nuiton.util;

import java.io.StreamTokenizer;
import java.util.HashSet;
import java.io.IOException;
import java.io.Reader;

/**
 * TODO What is it for ?
 */
public class StreamKeywordTokenizer extends StreamTokenizer { // StreamKeywordTokenizer

    public static final int TT_KEYWORD = -101;
    public static final int TT_VARIABLE = -102;
    protected HashSet<String> keywords = new HashSet<String>();
    protected boolean lowerCaseKeyword = false;
    protected int quoteCharVariable = -1;

    public StreamKeywordTokenizer(Reader in){
        super(in);
    }

    public int nextToken() throws IOException {
        super.nextToken();
        if(ttype == TT_WORD){
            String keyword = sval;
            if(lowerCaseKeyword){
                keyword = keyword.toLowerCase();
            }
            if(keywords.contains(keyword)){
                sval = keyword;
                ttype = TT_KEYWORD;
            }
        }else if(ttype == quoteCharVariable){
            ttype = TT_VARIABLE;
        }
        return ttype;
    }

    public void addKeyword(String keyword){
        if(lowerCaseKeyword){
            keywords.add(keyword.toLowerCase());
        }else{
            keywords.add(keyword);
        }
    }

    /**
    * This method must be call before addKeyword.
     * @param fl
     */
    public void lowerCaseKeyword(boolean fl){
        lowerCaseKeyword = fl;
    }

    public void quoteCharVariable(int c){
        quoteChar(c);
        quoteCharVariable = c;
    }

} // StreamKeywordTokenizer

